/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.StartShotDetectionFilter;
import software.amazon.awssdk.services.rekognition.model.StartTechnicalCueDetectionFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSegmentDetectionFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartSegmentDetectionFilters> {
    private static final SdkField<StartTechnicalCueDetectionFilter> TECHNICAL_CUE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TechnicalCueFilter").getter(StartSegmentDetectionFilters.getter(StartSegmentDetectionFilters::technicalCueFilter)).setter(StartSegmentDetectionFilters.setter(Builder::technicalCueFilter)).constructor(StartTechnicalCueDetectionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechnicalCueFilter").build()}).build();
    private static final SdkField<StartShotDetectionFilter> SHOT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShotFilter").getter(StartSegmentDetectionFilters.getter(StartSegmentDetectionFilters::shotFilter)).setter(StartSegmentDetectionFilters.setter(Builder::shotFilter)).constructor(StartShotDetectionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShotFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TECHNICAL_CUE_FILTER_FIELD, SHOT_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TechnicalCueFilter", TECHNICAL_CUE_FILTER_FIELD);
            this.put("ShotFilter", SHOT_FILTER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final StartTechnicalCueDetectionFilter technicalCueFilter;
    private final StartShotDetectionFilter shotFilter;

    private StartSegmentDetectionFilters(BuilderImpl builder) {
        this.technicalCueFilter = builder.technicalCueFilter;
        this.shotFilter = builder.shotFilter;
    }

    public final StartTechnicalCueDetectionFilter technicalCueFilter() {
        return this.technicalCueFilter;
    }

    public final StartShotDetectionFilter shotFilter() {
        return this.shotFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.technicalCueFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.shotFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSegmentDetectionFilters)) {
            return false;
        }
        StartSegmentDetectionFilters other = (StartSegmentDetectionFilters)obj;
        return Objects.equals(this.technicalCueFilter(), other.technicalCueFilter()) && Objects.equals(this.shotFilter(), other.shotFilter());
    }

    public final String toString() {
        return ToString.builder((String)"StartSegmentDetectionFilters").add("TechnicalCueFilter", (Object)this.technicalCueFilter()).add("ShotFilter", (Object)this.shotFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TechnicalCueFilter": {
                return Optional.ofNullable(clazz.cast(this.technicalCueFilter()));
            }
            case "ShotFilter": {
                return Optional.ofNullable(clazz.cast(this.shotFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartSegmentDetectionFilters, T> g) {
        return obj -> g.apply((StartSegmentDetectionFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StartTechnicalCueDetectionFilter technicalCueFilter;
        private StartShotDetectionFilter shotFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSegmentDetectionFilters model) {
            this.technicalCueFilter(model.technicalCueFilter);
            this.shotFilter(model.shotFilter);
        }

        public final StartTechnicalCueDetectionFilter.Builder getTechnicalCueFilter() {
            return this.technicalCueFilter != null ? this.technicalCueFilter.toBuilder() : null;
        }

        public final void setTechnicalCueFilter(StartTechnicalCueDetectionFilter.BuilderImpl technicalCueFilter) {
            this.technicalCueFilter = technicalCueFilter != null ? technicalCueFilter.build() : null;
        }

        @Override
        public final Builder technicalCueFilter(StartTechnicalCueDetectionFilter technicalCueFilter) {
            this.technicalCueFilter = technicalCueFilter;
            return this;
        }

        public final StartShotDetectionFilter.Builder getShotFilter() {
            return this.shotFilter != null ? this.shotFilter.toBuilder() : null;
        }

        public final void setShotFilter(StartShotDetectionFilter.BuilderImpl shotFilter) {
            this.shotFilter = shotFilter != null ? shotFilter.build() : null;
        }

        @Override
        public final Builder shotFilter(StartShotDetectionFilter shotFilter) {
            this.shotFilter = shotFilter;
            return this;
        }

        public StartSegmentDetectionFilters build() {
            return new StartSegmentDetectionFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartSegmentDetectionFilters> {
        public Builder technicalCueFilter(StartTechnicalCueDetectionFilter var1);

        default public Builder technicalCueFilter(Consumer<StartTechnicalCueDetectionFilter.Builder> technicalCueFilter) {
            return this.technicalCueFilter((StartTechnicalCueDetectionFilter)((StartTechnicalCueDetectionFilter.Builder)StartTechnicalCueDetectionFilter.builder().applyMutation(technicalCueFilter)).build());
        }

        public Builder shotFilter(StartShotDetectionFilter var1);

        default public Builder shotFilter(Consumer<StartShotDetectionFilter.Builder> shotFilter) {
            return this.shotFilter((StartShotDetectionFilter)((StartShotDetectionFilter.Builder)StartShotDetectionFilter.builder().applyMutation(shotFilter)).build());
        }
    }
}

