/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.TextDetection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextDetectionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextDetectionResult> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Timestamp").getter(TextDetectionResult.getter(TextDetectionResult::timestamp)).setter(TextDetectionResult.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<TextDetection> TEXT_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TextDetection").getter(TextDetectionResult.getter(TextDetectionResult::textDetection)).setter(TextDetectionResult.setter(Builder::textDetection)).constructor(TextDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextDetection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, TEXT_DETECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Timestamp", TIMESTAMP_FIELD);
            this.put("TextDetection", TEXT_DETECTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long timestamp;
    private final TextDetection textDetection;

    private TextDetectionResult(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.textDetection = builder.textDetection;
    }

    public final Long timestamp() {
        return this.timestamp;
    }

    public final TextDetection textDetection() {
        return this.textDetection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.textDetection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextDetectionResult)) {
            return false;
        }
        TextDetectionResult other = (TextDetectionResult)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.textDetection(), other.textDetection());
    }

    public final String toString() {
        return ToString.builder((String)"TextDetectionResult").add("Timestamp", (Object)this.timestamp()).add("TextDetection", (Object)this.textDetection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "TextDetection": {
                return Optional.ofNullable(clazz.cast(this.textDetection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TextDetectionResult, T> g) {
        return obj -> g.apply((TextDetectionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private TextDetection textDetection;

        private BuilderImpl() {
        }

        private BuilderImpl(TextDetectionResult model) {
            this.timestamp(model.timestamp);
            this.textDetection(model.textDetection);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final TextDetection.Builder getTextDetection() {
            return this.textDetection != null ? this.textDetection.toBuilder() : null;
        }

        public final void setTextDetection(TextDetection.BuilderImpl textDetection) {
            this.textDetection = textDetection != null ? textDetection.build() : null;
        }

        @Override
        public final Builder textDetection(TextDetection textDetection) {
            this.textDetection = textDetection;
            return this;
        }

        public TextDetectionResult build() {
            return new TextDetectionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextDetectionResult> {
        public Builder timestamp(Long var1);

        public Builder textDetection(TextDetection var1);

        default public Builder textDetection(Consumer<TextDetection.Builder> textDetection) {
            return this.textDetection((TextDetection)((TextDetection.Builder)TextDetection.builder().applyMutation(textDetection)).build());
        }
    }
}

