/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DisassociatedFace;
import software.amazon.awssdk.services.rekognition.model.DisassociatedFacesListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociation;
import software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociationListCopier;
import software.amazon.awssdk.services.rekognition.model.UserStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DisassociateFacesResponse> {
    private static final SdkField<List<DisassociatedFace>> DISASSOCIATED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DisassociatedFaces").getter(DisassociateFacesResponse.getter(DisassociateFacesResponse::disassociatedFaces)).setter(DisassociateFacesResponse.setter(Builder::disassociatedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociatedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisassociatedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnsuccessfulFaceDisassociation>> UNSUCCESSFUL_FACE_DISASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnsuccessfulFaceDisassociations").getter(DisassociateFacesResponse.getter(DisassociateFacesResponse::unsuccessfulFaceDisassociations)).setter(DisassociateFacesResponse.setter(Builder::unsuccessfulFaceDisassociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFaceDisassociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnsuccessfulFaceDisassociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserStatus").getter(DisassociateFacesResponse.getter(DisassociateFacesResponse::userStatusAsString)).setter(DisassociateFacesResponse.setter(Builder::userStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISASSOCIATED_FACES_FIELD, UNSUCCESSFUL_FACE_DISASSOCIATIONS_FIELD, USER_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateFacesResponse.memberNameToFieldInitializer();
    private final List<DisassociatedFace> disassociatedFaces;
    private final List<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations;
    private final String userStatus;

    private DisassociateFacesResponse(BuilderImpl builder) {
        super(builder);
        this.disassociatedFaces = builder.disassociatedFaces;
        this.unsuccessfulFaceDisassociations = builder.unsuccessfulFaceDisassociations;
        this.userStatus = builder.userStatus;
    }

    public final boolean hasDisassociatedFaces() {
        return this.disassociatedFaces != null && !(this.disassociatedFaces instanceof SdkAutoConstructList);
    }

    public final List<DisassociatedFace> disassociatedFaces() {
        return this.disassociatedFaces;
    }

    public final boolean hasUnsuccessfulFaceDisassociations() {
        return this.unsuccessfulFaceDisassociations != null && !(this.unsuccessfulFaceDisassociations instanceof SdkAutoConstructList);
    }

    public final List<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations() {
        return this.unsuccessfulFaceDisassociations;
    }

    public final UserStatus userStatus() {
        return UserStatus.fromValue(this.userStatus);
    }

    public final String userStatusAsString() {
        return this.userStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisassociatedFaces() ? this.disassociatedFaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessfulFaceDisassociations() ? this.unsuccessfulFaceDisassociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateFacesResponse)) {
            return false;
        }
        DisassociateFacesResponse other = (DisassociateFacesResponse)((Object)obj);
        return this.hasDisassociatedFaces() == other.hasDisassociatedFaces() && Objects.equals(this.disassociatedFaces(), other.disassociatedFaces()) && this.hasUnsuccessfulFaceDisassociations() == other.hasUnsuccessfulFaceDisassociations() && Objects.equals(this.unsuccessfulFaceDisassociations(), other.unsuccessfulFaceDisassociations()) && Objects.equals(this.userStatusAsString(), other.userStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateFacesResponse").add("DisassociatedFaces", this.hasDisassociatedFaces() ? this.disassociatedFaces() : null).add("UnsuccessfulFaceDisassociations", this.hasUnsuccessfulFaceDisassociations() ? this.unsuccessfulFaceDisassociations() : null).add("UserStatus", (Object)this.userStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisassociatedFaces": {
                return Optional.ofNullable(clazz.cast(this.disassociatedFaces()));
            }
            case "UnsuccessfulFaceDisassociations": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfulFaceDisassociations()));
            }
            case "UserStatus": {
                return Optional.ofNullable(clazz.cast(this.userStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DisassociatedFaces", DISASSOCIATED_FACES_FIELD);
        map.put("UnsuccessfulFaceDisassociations", UNSUCCESSFUL_FACE_DISASSOCIATIONS_FIELD);
        map.put("UserStatus", USER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateFacesResponse, T> g) {
        return obj -> g.apply((DisassociateFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<DisassociatedFace> disassociatedFaces = DefaultSdkAutoConstructList.getInstance();
        private List<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations = DefaultSdkAutoConstructList.getInstance();
        private String userStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateFacesResponse model) {
            super(model);
            this.disassociatedFaces(model.disassociatedFaces);
            this.unsuccessfulFaceDisassociations(model.unsuccessfulFaceDisassociations);
            this.userStatus(model.userStatus);
        }

        public final List<DisassociatedFace.Builder> getDisassociatedFaces() {
            List<DisassociatedFace.Builder> result = DisassociatedFacesListCopier.copyToBuilder(this.disassociatedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisassociatedFaces(Collection<DisassociatedFace.BuilderImpl> disassociatedFaces) {
            this.disassociatedFaces = DisassociatedFacesListCopier.copyFromBuilder(disassociatedFaces);
        }

        @Override
        public final Builder disassociatedFaces(Collection<DisassociatedFace> disassociatedFaces) {
            this.disassociatedFaces = DisassociatedFacesListCopier.copy(disassociatedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disassociatedFaces(DisassociatedFace ... disassociatedFaces) {
            this.disassociatedFaces(Arrays.asList(disassociatedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disassociatedFaces(Consumer<DisassociatedFace.Builder> ... disassociatedFaces) {
            this.disassociatedFaces(Stream.of(disassociatedFaces).map(c -> (DisassociatedFace)((DisassociatedFace.Builder)DisassociatedFace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnsuccessfulFaceDisassociation.Builder> getUnsuccessfulFaceDisassociations() {
            List<UnsuccessfulFaceDisassociation.Builder> result = UnsuccessfulFaceDisassociationListCopier.copyToBuilder(this.unsuccessfulFaceDisassociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulFaceDisassociations(Collection<UnsuccessfulFaceDisassociation.BuilderImpl> unsuccessfulFaceDisassociations) {
            this.unsuccessfulFaceDisassociations = UnsuccessfulFaceDisassociationListCopier.copyFromBuilder(unsuccessfulFaceDisassociations);
        }

        @Override
        public final Builder unsuccessfulFaceDisassociations(Collection<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations) {
            this.unsuccessfulFaceDisassociations = UnsuccessfulFaceDisassociationListCopier.copy(unsuccessfulFaceDisassociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceDisassociations(UnsuccessfulFaceDisassociation ... unsuccessfulFaceDisassociations) {
            this.unsuccessfulFaceDisassociations(Arrays.asList(unsuccessfulFaceDisassociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceDisassociations(Consumer<UnsuccessfulFaceDisassociation.Builder> ... unsuccessfulFaceDisassociations) {
            this.unsuccessfulFaceDisassociations(Stream.of(unsuccessfulFaceDisassociations).map(c -> (UnsuccessfulFaceDisassociation)((UnsuccessfulFaceDisassociation.Builder)UnsuccessfulFaceDisassociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserStatus() {
            return this.userStatus;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatus userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        @Override
        public DisassociateFacesResponse build() {
            return new DisassociateFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateFacesResponse> {
        public Builder disassociatedFaces(Collection<DisassociatedFace> var1);

        public Builder disassociatedFaces(DisassociatedFace ... var1);

        public Builder disassociatedFaces(Consumer<DisassociatedFace.Builder> ... var1);

        public Builder unsuccessfulFaceDisassociations(Collection<UnsuccessfulFaceDisassociation> var1);

        public Builder unsuccessfulFaceDisassociations(UnsuccessfulFaceDisassociation ... var1);

        public Builder unsuccessfulFaceDisassociations(Consumer<UnsuccessfulFaceDisassociation.Builder> ... var1);

        public Builder userStatus(String var1);

        public Builder userStatus(UserStatus var1);
    }
}

