/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<AssociateFacesRequest.Builder, AssociateFacesRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionId").getter(getter(AssociateFacesRequest::collectionId)).setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(AssociateFacesRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<List<String>> FACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FaceIds")
            .getter(getter(AssociateFacesRequest::faceIds))
            .setter(setter(Builder::faceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> USER_MATCH_THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("UserMatchThreshold").getter(getter(AssociateFacesRequest::userMatchThreshold))
            .setter(setter(Builder::userMatchThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatchThreshold").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(AssociateFacesRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            USER_ID_FIELD, FACE_IDS_FIELD, USER_MATCH_THRESHOLD_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collectionId;

    private final String userId;

    private final List<String> faceIds;

    private final Float userMatchThreshold;

    private final String clientRequestToken;

    private AssociateFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.userId = builder.userId;
        this.faceIds = builder.faceIds;
        this.userMatchThreshold = builder.userMatchThreshold;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The ID of an existing collection containing the UserID.
     * </p>
     * 
     * @return The ID of an existing collection containing the UserID.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * The ID for the existing UserID.
     * </p>
     * 
     * @return The ID for the existing UserID.
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FaceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFaceIds() {
        return faceIds != null && !(faceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of FaceIDs to associate with the UserID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFaceIds} method.
     * </p>
     * 
     * @return An array of FaceIDs to associate with the UserID.
     */
    public final List<String> faceIds() {
        return faceIds;
    }

    /**
     * <p>
     * An optional value specifying the minimum confidence in the UserID match to return. The default value is 75.
     * </p>
     * 
     * @return An optional value specifying the minimum confidence in the UserID match to return. The default value is
     *         75.
     */
    public final Float userMatchThreshold() {
        return userMatchThreshold;
    }

    /**
     * <p>
     * Idempotent token used to identify the request to <code>AssociateFaces</code>. If you use the same token with
     * multiple <code>AssociateFaces</code> requests, the same response is returned. Use ClientRequestToken to prevent
     * the same request from being processed more than once.
     * </p>
     * 
     * @return Idempotent token used to identify the request to <code>AssociateFaces</code>. If you use the same token
     *         with multiple <code>AssociateFaces</code> requests, the same response is returned. Use ClientRequestToken
     *         to prevent the same request from being processed more than once.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFaceIds() ? faceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userMatchThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFacesRequest)) {
            return false;
        }
        AssociateFacesRequest other = (AssociateFacesRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(userId(), other.userId())
                && hasFaceIds() == other.hasFaceIds() && Objects.equals(faceIds(), other.faceIds())
                && Objects.equals(userMatchThreshold(), other.userMatchThreshold())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateFacesRequest").add("CollectionId", collectionId()).add("UserId", userId())
                .add("FaceIds", hasFaceIds() ? faceIds() : null).add("UserMatchThreshold", userMatchThreshold())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "FaceIds":
            return Optional.ofNullable(clazz.cast(faceIds()));
        case "UserMatchThreshold":
            return Optional.ofNullable(clazz.cast(userMatchThreshold()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CollectionId", COLLECTION_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("FaceIds", FACE_IDS_FIELD);
        map.put("UserMatchThreshold", USER_MATCH_THRESHOLD_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateFacesRequest, T> g) {
        return obj -> g.apply((AssociateFacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateFacesRequest> {
        /**
         * <p>
         * The ID of an existing collection containing the UserID.
         * </p>
         * 
         * @param collectionId
         *        The ID of an existing collection containing the UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * The ID for the existing UserID.
         * </p>
         * 
         * @param userId
         *        The ID for the existing UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * An array of FaceIDs to associate with the UserID.
         * </p>
         * 
         * @param faceIds
         *        An array of FaceIDs to associate with the UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceIds(Collection<String> faceIds);

        /**
         * <p>
         * An array of FaceIDs to associate with the UserID.
         * </p>
         * 
         * @param faceIds
         *        An array of FaceIDs to associate with the UserID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceIds(String... faceIds);

        /**
         * <p>
         * An optional value specifying the minimum confidence in the UserID match to return. The default value is 75.
         * </p>
         * 
         * @param userMatchThreshold
         *        An optional value specifying the minimum confidence in the UserID match to return. The default value
         *        is 75.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMatchThreshold(Float userMatchThreshold);

        /**
         * <p>
         * Idempotent token used to identify the request to <code>AssociateFaces</code>. If you use the same token with
         * multiple <code>AssociateFaces</code> requests, the same response is returned. Use ClientRequestToken to
         * prevent the same request from being processed more than once.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotent token used to identify the request to <code>AssociateFaces</code>. If you use the same
         *        token with multiple <code>AssociateFaces</code> requests, the same response is returned. Use
         *        ClientRequestToken to prevent the same request from being processed more than once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private String userId;

        private List<String> faceIds = DefaultSdkAutoConstructList.getInstance();

        private Float userMatchThreshold;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFacesRequest model) {
            super(model);
            collectionId(model.collectionId);
            userId(model.userId);
            faceIds(model.faceIds);
            userMatchThreshold(model.userMatchThreshold);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getFaceIds() {
            if (faceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return faceIds;
        }

        public final void setFaceIds(Collection<String> faceIds) {
            this.faceIds = UserFaceIdListCopier.copy(faceIds);
        }

        @Override
        public final Builder faceIds(Collection<String> faceIds) {
            this.faceIds = UserFaceIdListCopier.copy(faceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceIds(String... faceIds) {
            faceIds(Arrays.asList(faceIds));
            return this;
        }

        public final Float getUserMatchThreshold() {
            return userMatchThreshold;
        }

        public final void setUserMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
        }

        @Override
        public final Builder userMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateFacesRequest build() {
            return new AssociateFacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
