/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The label detection settings you want to use in your stream processor. This includes the labels you want the stream
 * processor to detect and the minimum confidence level allowed to label objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectedHomeSettingsForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectedHomeSettingsForUpdate.Builder, ConnectedHomeSettingsForUpdate> {
    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(ConnectedHomeSettingsForUpdate::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MinConfidence").getter(getter(ConnectedHomeSettingsForUpdate::minConfidence))
            .setter(setter(Builder::minConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD,
            MIN_CONFIDENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Labels", LABELS_FIELD);
                    put("MinConfidence", MIN_CONFIDENCE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> labels;

    private final Float minConfidence;

    private ConnectedHomeSettingsForUpdate(BuilderImpl builder) {
        this.labels = builder.labels;
        this.minConfidence = builder.minConfidence;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you
     * can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return Specifies what you want to detect in the video, such as people, packages, or pets. The current valid
     *         labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
     */
    public final List<String> labels() {
        return labels;
    }

    /**
     * <p>
     * The minimum confidence required to label an object in the video.
     * </p>
     * 
     * @return The minimum confidence required to label an object in the video.
     */
    public final Float minConfidence() {
        return minConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minConfidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectedHomeSettingsForUpdate)) {
            return false;
        }
        ConnectedHomeSettingsForUpdate other = (ConnectedHomeSettingsForUpdate) obj;
        return hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && Objects.equals(minConfidence(), other.minConfidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectedHomeSettingsForUpdate").add("Labels", hasLabels() ? labels() : null)
                .add("MinConfidence", minConfidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "MinConfidence":
            return Optional.ofNullable(clazz.cast(minConfidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectedHomeSettingsForUpdate, T> g) {
        return obj -> g.apply((ConnectedHomeSettingsForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectedHomeSettingsForUpdate> {
        /**
         * <p>
         * Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels
         * you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
         * </p>
         * 
         * @param labels
         *        Specifies what you want to detect in the video, such as people, packages, or pets. The current valid
         *        labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels
         * you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
         * </p>
         * 
         * @param labels
         *        Specifies what you want to detect in the video, such as people, packages, or pets. The current valid
         *        labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        /**
         * <p>
         * The minimum confidence required to label an object in the video.
         * </p>
         * 
         * @param minConfidence
         *        The minimum confidence required to label an object in the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minConfidence(Float minConfidence);
    }

    static final class BuilderImpl implements Builder {
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectedHomeSettingsForUpdate model) {
            labels(model.labels);
            minConfidence(model.minConfidence);
        }

        public final Collection<String> getLabels() {
            if (labels instanceof SdkAutoConstructList) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ConnectedHomeLabelsCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ConnectedHomeLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final Float getMinConfidence() {
            return minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        @Override
        public ConnectedHomeSettingsForUpdate build() {
            return new ConnectedHomeSettingsForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
