/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyProjectVersionRequest extends RekognitionRequest implements
        ToCopyableBuilder<CopyProjectVersionRequest.Builder, CopyProjectVersionRequest> {
    private static final SdkField<String> SOURCE_PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceProjectArn").getter(getter(CopyProjectVersionRequest::sourceProjectArn))
            .setter(setter(Builder::sourceProjectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProjectArn").build()).build();

    private static final SdkField<String> SOURCE_PROJECT_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceProjectVersionArn").getter(getter(CopyProjectVersionRequest::sourceProjectVersionArn))
            .setter(setter(Builder::sourceProjectVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProjectVersionArn").build())
            .build();

    private static final SdkField<String> DESTINATION_PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationProjectArn").getter(getter(CopyProjectVersionRequest::destinationProjectArn))
            .setter(setter(Builder::destinationProjectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationProjectArn").build())
            .build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(CopyProjectVersionRequest::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(CopyProjectVersionRequest::outputConfig))
            .setter(setter(Builder::outputConfig)).constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CopyProjectVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CopyProjectVersionRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PROJECT_ARN_FIELD,
            SOURCE_PROJECT_VERSION_ARN_FIELD, DESTINATION_PROJECT_ARN_FIELD, VERSION_NAME_FIELD, OUTPUT_CONFIG_FIELD, TAGS_FIELD,
            KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SourceProjectArn", SOURCE_PROJECT_ARN_FIELD);
                    put("SourceProjectVersionArn", SOURCE_PROJECT_VERSION_ARN_FIELD);
                    put("DestinationProjectArn", DESTINATION_PROJECT_ARN_FIELD);
                    put("VersionName", VERSION_NAME_FIELD);
                    put("OutputConfig", OUTPUT_CONFIG_FIELD);
                    put("Tags", TAGS_FIELD);
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                }
            });

    private final String sourceProjectArn;

    private final String sourceProjectVersionArn;

    private final String destinationProjectArn;

    private final String versionName;

    private final OutputConfig outputConfig;

    private final Map<String, String> tags;

    private final String kmsKeyId;

    private CopyProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.sourceProjectArn = builder.sourceProjectArn;
        this.sourceProjectVersionArn = builder.sourceProjectVersionArn;
        this.destinationProjectArn = builder.destinationProjectArn;
        this.versionName = builder.versionName;
        this.outputConfig = builder.outputConfig;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The ARN of the source project in the trusting AWS account.
     * </p>
     * 
     * @return The ARN of the source project in the trusting AWS account.
     */
    public final String sourceProjectArn() {
        return sourceProjectArn;
    }

    /**
     * <p>
     * The ARN of the model version in the source project that you want to copy to a destination project.
     * </p>
     * 
     * @return The ARN of the model version in the source project that you want to copy to a destination project.
     */
    public final String sourceProjectVersionArn() {
        return sourceProjectVersionArn;
    }

    /**
     * <p>
     * The ARN of the project in the trusted AWS account that you want to copy the model version to.
     * </p>
     * 
     * @return The ARN of the project in the trusted AWS account that you want to copy the model version to.
     */
    public final String destinationProjectArn() {
        return destinationProjectArn;
    }

    /**
     * <p>
     * A name for the version of the model that's copied to the destination project.
     * </p>
     * 
     * @return A name for the version of the model that's copied to the destination project.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The S3 bucket and folder location where the training output for the source model version is placed.
     * </p>
     * 
     * @return The S3 bucket and folder location where the training output for the source model version is placed.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value tags to assign to the model version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value tags to assign to the model version.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name
     * (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to
     * encrypt training results and manifest files written to the output Amazon S3 bucket (<code>OutputConfig</code>).
     * </p>
     * <p>
     * If you choose to use your own KMS key, you need the following permissions on the KMS key.
     * </p>
     * <ul>
     * <li>
     * <p>
     * kms:CreateGrant
     * </p>
     * </li>
     * <li>
     * <p>
     * kms:DescribeKey
     * </p>
     * </li>
     * <li>
     * <p>
     * kms:GenerateDataKey
     * </p>
     * </li>
     * <li>
     * <p>
     * kms:Decrypt
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted using a key
     * that AWS owns and manages.
     * </p>
     * 
     * @return The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource
     *         Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key
     *         is used to encrypt training results and manifest files written to the output Amazon S3 bucket (
     *         <code>OutputConfig</code>).</p>
     *         <p>
     *         If you choose to use your own KMS key, you need the following permissions on the KMS key.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         kms:CreateGrant
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         kms:DescribeKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         kms:GenerateDataKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         kms:Decrypt
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted
     *         using a key that AWS owns and manages.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceProjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProjectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationProjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyProjectVersionRequest)) {
            return false;
        }
        CopyProjectVersionRequest other = (CopyProjectVersionRequest) obj;
        return Objects.equals(sourceProjectArn(), other.sourceProjectArn())
                && Objects.equals(sourceProjectVersionArn(), other.sourceProjectVersionArn())
                && Objects.equals(destinationProjectArn(), other.destinationProjectArn())
                && Objects.equals(versionName(), other.versionName()) && Objects.equals(outputConfig(), other.outputConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyProjectVersionRequest").add("SourceProjectArn", sourceProjectArn())
                .add("SourceProjectVersionArn", sourceProjectVersionArn()).add("DestinationProjectArn", destinationProjectArn())
                .add("VersionName", versionName()).add("OutputConfig", outputConfig()).add("Tags", hasTags() ? tags() : null)
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceProjectArn":
            return Optional.ofNullable(clazz.cast(sourceProjectArn()));
        case "SourceProjectVersionArn":
            return Optional.ofNullable(clazz.cast(sourceProjectVersionArn()));
        case "DestinationProjectArn":
            return Optional.ofNullable(clazz.cast(destinationProjectArn()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CopyProjectVersionRequest, T> g) {
        return obj -> g.apply((CopyProjectVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyProjectVersionRequest> {
        /**
         * <p>
         * The ARN of the source project in the trusting AWS account.
         * </p>
         * 
         * @param sourceProjectArn
         *        The ARN of the source project in the trusting AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProjectArn(String sourceProjectArn);

        /**
         * <p>
         * The ARN of the model version in the source project that you want to copy to a destination project.
         * </p>
         * 
         * @param sourceProjectVersionArn
         *        The ARN of the model version in the source project that you want to copy to a destination project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProjectVersionArn(String sourceProjectVersionArn);

        /**
         * <p>
         * The ARN of the project in the trusted AWS account that you want to copy the model version to.
         * </p>
         * 
         * @param destinationProjectArn
         *        The ARN of the project in the trusted AWS account that you want to copy the model version to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationProjectArn(String destinationProjectArn);

        /**
         * <p>
         * A name for the version of the model that's copied to the destination project.
         * </p>
         * 
         * @param versionName
         *        A name for the version of the model that's copied to the destination project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The S3 bucket and folder location where the training output for the source model version is placed.
         * </p>
         * 
         * @param outputConfig
         *        The S3 bucket and folder location where the training output for the source model version is placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * The S3 bucket and folder location where the training output for the source model version is placed.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The key-value tags to assign to the model version.
         * </p>
         * 
         * @param tags
         *        The key-value tags to assign to the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name
         * (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to
         * encrypt training results and manifest files written to the output Amazon S3 bucket (<code>OutputConfig</code>
         * ).
         * </p>
         * <p>
         * If you choose to use your own KMS key, you need the following permissions on the KMS key.
         * </p>
         * <ul>
         * <li>
         * <p>
         * kms:CreateGrant
         * </p>
         * </li>
         * <li>
         * <p>
         * kms:DescribeKey
         * </p>
         * </li>
         * <li>
         * <p>
         * kms:GenerateDataKey
         * </p>
         * </li>
         * <li>
         * <p>
         * kms:Decrypt
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted using a
         * key that AWS owns and manages.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon
         *        Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias
         *        ARN. The key is used to encrypt training results and manifest files written to the output Amazon S3
         *        bucket (<code>OutputConfig</code>).</p>
         *        <p>
         *        If you choose to use your own KMS key, you need the following permissions on the KMS key.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        kms:CreateGrant
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        kms:DescribeKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        kms:GenerateDataKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        kms:Decrypt
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted
         *        using a key that AWS owns and manages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String sourceProjectArn;

        private String sourceProjectVersionArn;

        private String destinationProjectArn;

        private String versionName;

        private OutputConfig outputConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyProjectVersionRequest model) {
            super(model);
            sourceProjectArn(model.sourceProjectArn);
            sourceProjectVersionArn(model.sourceProjectVersionArn);
            destinationProjectArn(model.destinationProjectArn);
            versionName(model.versionName);
            outputConfig(model.outputConfig);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getSourceProjectArn() {
            return sourceProjectArn;
        }

        public final void setSourceProjectArn(String sourceProjectArn) {
            this.sourceProjectArn = sourceProjectArn;
        }

        @Override
        public final Builder sourceProjectArn(String sourceProjectArn) {
            this.sourceProjectArn = sourceProjectArn;
            return this;
        }

        public final String getSourceProjectVersionArn() {
            return sourceProjectVersionArn;
        }

        public final void setSourceProjectVersionArn(String sourceProjectVersionArn) {
            this.sourceProjectVersionArn = sourceProjectVersionArn;
        }

        @Override
        public final Builder sourceProjectVersionArn(String sourceProjectVersionArn) {
            this.sourceProjectVersionArn = sourceProjectVersionArn;
            return this;
        }

        public final String getDestinationProjectArn() {
            return destinationProjectArn;
        }

        public final void setDestinationProjectArn(String destinationProjectArn) {
            this.destinationProjectArn = destinationProjectArn;
        }

        @Override
        public final Builder destinationProjectArn(String destinationProjectArn) {
            this.destinationProjectArn = destinationProjectArn;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyProjectVersionRequest build() {
            return new CopyProjectVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
