/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics about a label used in a dataset. For more information, see <a>DatasetLabelDescription</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetLabelStats implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetLabelStats.Builder, DatasetLabelStats> {
    private static final SdkField<Integer> ENTRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EntryCount").getter(getter(DatasetLabelStats::entryCount)).setter(setter(Builder::entryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryCount").build()).build();

    private static final SdkField<Integer> BOUNDING_BOX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BoundingBoxCount").getter(getter(DatasetLabelStats::boundingBoxCount))
            .setter(setter(Builder::boundingBoxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBoxCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_COUNT_FIELD,
            BOUNDING_BOX_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EntryCount", ENTRY_COUNT_FIELD);
                    put("BoundingBoxCount", BOUNDING_BOX_COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer entryCount;

    private final Integer boundingBoxCount;

    private DatasetLabelStats(BuilderImpl builder) {
        this.entryCount = builder.entryCount;
        this.boundingBoxCount = builder.boundingBoxCount;
    }

    /**
     * <p>
     * The total number of images that use the label.
     * </p>
     * 
     * @return The total number of images that use the label.
     */
    public final Integer entryCount() {
        return entryCount;
    }

    /**
     * <p>
     * The total number of images that have the label assigned to a bounding box.
     * </p>
     * 
     * @return The total number of images that have the label assigned to a bounding box.
     */
    public final Integer boundingBoxCount() {
        return boundingBoxCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryCount());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBoxCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetLabelStats)) {
            return false;
        }
        DatasetLabelStats other = (DatasetLabelStats) obj;
        return Objects.equals(entryCount(), other.entryCount()) && Objects.equals(boundingBoxCount(), other.boundingBoxCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetLabelStats").add("EntryCount", entryCount()).add("BoundingBoxCount", boundingBoxCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntryCount":
            return Optional.ofNullable(clazz.cast(entryCount()));
        case "BoundingBoxCount":
            return Optional.ofNullable(clazz.cast(boundingBoxCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasetLabelStats, T> g) {
        return obj -> g.apply((DatasetLabelStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetLabelStats> {
        /**
         * <p>
         * The total number of images that use the label.
         * </p>
         * 
         * @param entryCount
         *        The total number of images that use the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryCount(Integer entryCount);

        /**
         * <p>
         * The total number of images that have the label assigned to a bounding box.
         * </p>
         * 
         * @param boundingBoxCount
         *        The total number of images that have the label assigned to a bounding box.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBoxCount(Integer boundingBoxCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer entryCount;

        private Integer boundingBoxCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetLabelStats model) {
            entryCount(model.entryCount);
            boundingBoxCount(model.boundingBoxCount);
        }

        public final Integer getEntryCount() {
            return entryCount;
        }

        public final void setEntryCount(Integer entryCount) {
            this.entryCount = entryCount;
        }

        @Override
        public final Builder entryCount(Integer entryCount) {
            this.entryCount = entryCount;
            return this;
        }

        public final Integer getBoundingBoxCount() {
            return boundingBoxCount;
        }

        public final void setBoundingBoxCount(Integer boundingBoxCount) {
            this.boundingBoxCount = boundingBoxCount;
        }

        @Override
        public final Builder boundingBoxCount(Integer boundingBoxCount) {
            this.boundingBoxCount = boundingBoxCount;
            return this;
        }

        @Override
        public DatasetLabelStats build() {
            return new DatasetLabelStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
