/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for an Amazon Rekognition Custom Labels dataset. For more information, see
 * <a>ProjectDescription</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetMetadata implements SdkPojo, Serializable, ToCopyableBuilder<DatasetMetadata.Builder, DatasetMetadata> {
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(DatasetMetadata::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(DatasetMetadata::datasetTypeAsString)).setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DatasetMetadata::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DatasetMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DatasetMetadata::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessageCode").getter(getter(DatasetMetadata::statusMessageCodeAsString))
            .setter(setter(Builder::statusMessageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIMESTAMP_FIELD,
            DATASET_TYPE_FIELD, DATASET_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STATUS_MESSAGE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
                    put("DatasetType", DATASET_TYPE_FIELD);
                    put("DatasetArn", DATASET_ARN_FIELD);
                    put("Status", STATUS_FIELD);
                    put("StatusMessage", STATUS_MESSAGE_FIELD);
                    put("StatusMessageCode", STATUS_MESSAGE_CODE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant creationTimestamp;

    private final String datasetType;

    private final String datasetArn;

    private final String status;

    private final String statusMessage;

    private final String statusMessageCode;

    private DatasetMetadata(BuilderImpl builder) {
        this.creationTimestamp = builder.creationTimestamp;
        this.datasetType = builder.datasetType;
        this.datasetArn = builder.datasetArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.statusMessageCode = builder.statusMessageCode;
    }

    /**
     * <p>
     * The Unix timestamp for the date and time that the dataset was created.
     * </p>
     * 
     * @return The Unix timestamp for the date and time that the dataset was created.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The type of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The type of the dataset.
     * @see DatasetType
     */
    public final DatasetType datasetType() {
        return DatasetType.fromValue(datasetType);
    }

    /**
     * <p>
     * The type of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The type of the dataset.
     * @see DatasetType
     */
    public final String datasetTypeAsString() {
        return datasetType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the dataset.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The status for the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for the dataset.
     * @see DatasetStatus
     */
    public final DatasetStatus status() {
        return DatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status for the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for the dataset.
     * @see DatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message for the dataset.
     * </p>
     * 
     * @return The status message for the dataset.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The status message code for the dataset operation. If a service error occurs, try the API call again later. If a
     * client error occurs, check the input parameters to the dataset API call that failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusMessageCode}
     * will return {@link DatasetStatusMessageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusMessageCodeAsString}.
     * </p>
     * 
     * @return The status message code for the dataset operation. If a service error occurs, try the API call again
     *         later. If a client error occurs, check the input parameters to the dataset API call that failed.
     * @see DatasetStatusMessageCode
     */
    public final DatasetStatusMessageCode statusMessageCode() {
        return DatasetStatusMessageCode.fromValue(statusMessageCode);
    }

    /**
     * <p>
     * The status message code for the dataset operation. If a service error occurs, try the API call again later. If a
     * client error occurs, check the input parameters to the dataset API call that failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusMessageCode}
     * will return {@link DatasetStatusMessageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusMessageCodeAsString}.
     * </p>
     * 
     * @return The status message code for the dataset operation. If a service error occurs, try the API call again
     *         later. If a client error occurs, check the input parameters to the dataset API call that failed.
     * @see DatasetStatusMessageCode
     */
    public final String statusMessageCodeAsString() {
        return statusMessageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessageCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetMetadata)) {
            return false;
        }
        DatasetMetadata other = (DatasetMetadata) obj;
        return Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(datasetTypeAsString(), other.datasetTypeAsString())
                && Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(statusMessageCodeAsString(), other.statusMessageCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetMetadata").add("CreationTimestamp", creationTimestamp())
                .add("DatasetType", datasetTypeAsString()).add("DatasetArn", datasetArn()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("StatusMessageCode", statusMessageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetTypeAsString()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "StatusMessageCode":
            return Optional.ofNullable(clazz.cast(statusMessageCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasetMetadata, T> g) {
        return obj -> g.apply((DatasetMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetMetadata> {
        /**
         * <p>
         * The Unix timestamp for the date and time that the dataset was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The Unix timestamp for the date and time that the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The type of the dataset.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The type of the dataset.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(DatasetType datasetType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the dataset.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The status for the dataset.
         * </p>
         * 
         * @param status
         *        The status for the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status for the dataset.
         * </p>
         * 
         * @param status
         *        The status for the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(DatasetStatus status);

        /**
         * <p>
         * The status message for the dataset.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The status message code for the dataset operation. If a service error occurs, try the API call again later.
         * If a client error occurs, check the input parameters to the dataset API call that failed.
         * </p>
         * 
         * @param statusMessageCode
         *        The status message code for the dataset operation. If a service error occurs, try the API call again
         *        later. If a client error occurs, check the input parameters to the dataset API call that failed.
         * @see DatasetStatusMessageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatusMessageCode
         */
        Builder statusMessageCode(String statusMessageCode);

        /**
         * <p>
         * The status message code for the dataset operation. If a service error occurs, try the API call again later.
         * If a client error occurs, check the input parameters to the dataset API call that failed.
         * </p>
         * 
         * @param statusMessageCode
         *        The status message code for the dataset operation. If a service error occurs, try the API call again
         *        later. If a client error occurs, check the input parameters to the dataset API call that failed.
         * @see DatasetStatusMessageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatusMessageCode
         */
        Builder statusMessageCode(DatasetStatusMessageCode statusMessageCode);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTimestamp;

        private String datasetType;

        private String datasetArn;

        private String status;

        private String statusMessage;

        private String statusMessageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetMetadata model) {
            creationTimestamp(model.creationTimestamp);
            datasetType(model.datasetType);
            datasetArn(model.datasetArn);
            status(model.status);
            statusMessage(model.statusMessage);
            statusMessageCode(model.statusMessageCode);
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStatusMessageCode() {
            return statusMessageCode;
        }

        public final void setStatusMessageCode(String statusMessageCode) {
            this.statusMessageCode = statusMessageCode;
        }

        @Override
        public final Builder statusMessageCode(String statusMessageCode) {
            this.statusMessageCode = statusMessageCode;
            return this;
        }

        @Override
        public final Builder statusMessageCode(DatasetStatusMessageCode statusMessageCode) {
            this.statusMessageCode(statusMessageCode == null ? null : statusMessageCode.toString());
            return this;
        }

        @Override
        public DatasetMetadata build() {
            return new DatasetMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
