/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for the IMAGE_PROPERTIES feature type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectLabelsImagePropertiesSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectLabelsImagePropertiesSettings.Builder, DetectLabelsImagePropertiesSettings> {
    private static final SdkField<Integer> MAX_DOMINANT_COLORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxDominantColors").getter(getter(DetectLabelsImagePropertiesSettings::maxDominantColors))
            .setter(setter(Builder::maxDominantColors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDominantColors").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_DOMINANT_COLORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MaxDominantColors", MAX_DOMINANT_COLORS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer maxDominantColors;

    private DetectLabelsImagePropertiesSettings(BuilderImpl builder) {
        this.maxDominantColors = builder.maxDominantColors;
    }

    /**
     * <p>
     * The maximum number of dominant colors to return when detecting labels in an image. The default value is 10.
     * </p>
     * 
     * @return The maximum number of dominant colors to return when detecting labels in an image. The default value is
     *         10.
     */
    public final Integer maxDominantColors() {
        return maxDominantColors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxDominantColors());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsImagePropertiesSettings)) {
            return false;
        }
        DetectLabelsImagePropertiesSettings other = (DetectLabelsImagePropertiesSettings) obj;
        return Objects.equals(maxDominantColors(), other.maxDominantColors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectLabelsImagePropertiesSettings").add("MaxDominantColors", maxDominantColors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxDominantColors":
            return Optional.ofNullable(clazz.cast(maxDominantColors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsImagePropertiesSettings, T> g) {
        return obj -> g.apply((DetectLabelsImagePropertiesSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectLabelsImagePropertiesSettings> {
        /**
         * <p>
         * The maximum number of dominant colors to return when detecting labels in an image. The default value is 10.
         * </p>
         * 
         * @param maxDominantColors
         *        The maximum number of dominant colors to return when detecting labels in an image. The default value
         *        is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDominantColors(Integer maxDominantColors);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxDominantColors;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsImagePropertiesSettings model) {
            maxDominantColors(model.maxDominantColors);
        }

        public final Integer getMaxDominantColors() {
            return maxDominantColors;
        }

        public final void setMaxDominantColors(Integer maxDominantColors) {
            this.maxDominantColors = maxDominantColors;
        }

        @Override
        public final Builder maxDominantColors(Integer maxDominantColors) {
            this.maxDominantColors = maxDominantColors;
            return this;
        }

        @Override
        public DetectLabelsImagePropertiesSettings build() {
            return new DetectLabelsImagePropertiesSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
