/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of parameters that allow you to filter out certain results from your returned results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectionFilter implements SdkPojo, Serializable, ToCopyableBuilder<DetectionFilter.Builder, DetectionFilter> {
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MinConfidence").getter(getter(DetectionFilter::minConfidence)).setter(setter(Builder::minConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()).build();

    private static final SdkField<Float> MIN_BOUNDING_BOX_HEIGHT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MinBoundingBoxHeight").getter(getter(DetectionFilter::minBoundingBoxHeight))
            .setter(setter(Builder::minBoundingBoxHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinBoundingBoxHeight").build())
            .build();

    private static final SdkField<Float> MIN_BOUNDING_BOX_WIDTH_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MinBoundingBoxWidth").getter(getter(DetectionFilter::minBoundingBoxWidth))
            .setter(setter(Builder::minBoundingBoxWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinBoundingBoxWidth").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CONFIDENCE_FIELD,
            MIN_BOUNDING_BOX_HEIGHT_FIELD, MIN_BOUNDING_BOX_WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MinConfidence", MIN_CONFIDENCE_FIELD);
                    put("MinBoundingBoxHeight", MIN_BOUNDING_BOX_HEIGHT_FIELD);
                    put("MinBoundingBoxWidth", MIN_BOUNDING_BOX_WIDTH_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Float minConfidence;

    private final Float minBoundingBoxHeight;

    private final Float minBoundingBoxWidth;

    private DetectionFilter(BuilderImpl builder) {
        this.minConfidence = builder.minConfidence;
        this.minBoundingBoxHeight = builder.minBoundingBoxHeight;
        this.minBoundingBoxWidth = builder.minBoundingBoxWidth;
    }

    /**
     * <p>
     * Sets the confidence of word detection. Words with detection confidence below this will be excluded from the
     * result. Values should be between 0 and 100. The default MinConfidence is 80.
     * </p>
     * 
     * @return Sets the confidence of word detection. Words with detection confidence below this will be excluded from
     *         the result. Values should be between 0 and 100. The default MinConfidence is 80.
     */
    public final Float minConfidence() {
        return minConfidence;
    }

    /**
     * <p>
     * Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this value will be
     * excluded from the result. Value is relative to the video frame height.
     * </p>
     * 
     * @return Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this value
     *         will be excluded from the result. Value is relative to the video frame height.
     */
    public final Float minBoundingBoxHeight() {
        return minBoundingBoxHeight;
    }

    /**
     * <p>
     * Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this value will be
     * excluded from the result. Value is relative to the video frame width.
     * </p>
     * 
     * @return Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this value
     *         will be excluded from the result. Value is relative to the video frame width.
     */
    public final Float minBoundingBoxWidth() {
        return minBoundingBoxWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(minBoundingBoxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(minBoundingBoxWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectionFilter)) {
            return false;
        }
        DetectionFilter other = (DetectionFilter) obj;
        return Objects.equals(minConfidence(), other.minConfidence())
                && Objects.equals(minBoundingBoxHeight(), other.minBoundingBoxHeight())
                && Objects.equals(minBoundingBoxWidth(), other.minBoundingBoxWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectionFilter").add("MinConfidence", minConfidence())
                .add("MinBoundingBoxHeight", minBoundingBoxHeight()).add("MinBoundingBoxWidth", minBoundingBoxWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinConfidence":
            return Optional.ofNullable(clazz.cast(minConfidence()));
        case "MinBoundingBoxHeight":
            return Optional.ofNullable(clazz.cast(minBoundingBoxHeight()));
        case "MinBoundingBoxWidth":
            return Optional.ofNullable(clazz.cast(minBoundingBoxWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetectionFilter, T> g) {
        return obj -> g.apply((DetectionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectionFilter> {
        /**
         * <p>
         * Sets the confidence of word detection. Words with detection confidence below this will be excluded from the
         * result. Values should be between 0 and 100. The default MinConfidence is 80.
         * </p>
         * 
         * @param minConfidence
         *        Sets the confidence of word detection. Words with detection confidence below this will be excluded
         *        from the result. Values should be between 0 and 100. The default MinConfidence is 80.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minConfidence(Float minConfidence);

        /**
         * <p>
         * Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this value will
         * be excluded from the result. Value is relative to the video frame height.
         * </p>
         * 
         * @param minBoundingBoxHeight
         *        Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this
         *        value will be excluded from the result. Value is relative to the video frame height.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBoundingBoxHeight(Float minBoundingBoxHeight);

        /**
         * <p>
         * Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this value will
         * be excluded from the result. Value is relative to the video frame width.
         * </p>
         * 
         * @param minBoundingBoxWidth
         *        Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this
         *        value will be excluded from the result. Value is relative to the video frame width.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBoundingBoxWidth(Float minBoundingBoxWidth);
    }

    static final class BuilderImpl implements Builder {
        private Float minConfidence;

        private Float minBoundingBoxHeight;

        private Float minBoundingBoxWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectionFilter model) {
            minConfidence(model.minConfidence);
            minBoundingBoxHeight(model.minBoundingBoxHeight);
            minBoundingBoxWidth(model.minBoundingBoxWidth);
        }

        public final Float getMinConfidence() {
            return minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final Float getMinBoundingBoxHeight() {
            return minBoundingBoxHeight;
        }

        public final void setMinBoundingBoxHeight(Float minBoundingBoxHeight) {
            this.minBoundingBoxHeight = minBoundingBoxHeight;
        }

        @Override
        public final Builder minBoundingBoxHeight(Float minBoundingBoxHeight) {
            this.minBoundingBoxHeight = minBoundingBoxHeight;
            return this;
        }

        public final Float getMinBoundingBoxWidth() {
            return minBoundingBoxWidth;
        }

        public final void setMinBoundingBoxWidth(Float minBoundingBoxWidth) {
            this.minBoundingBoxWidth = minBoundingBoxWidth;
        }

        @Override
        public final Builder minBoundingBoxWidth(Float minBoundingBoxWidth) {
            this.minBoundingBoxWidth = minBoundingBoxWidth;
            return this;
        }

        @Override
        public DetectionFilter build() {
            return new DetectionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
