/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCelebrityInfoResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetCelebrityInfoResponse.Builder, GetCelebrityInfoResponse> {
    private static final SdkField<List<String>> URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Urls")
            .getter(getter(GetCelebrityInfoResponse::urls))
            .setter(setter(Builder::urls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetCelebrityInfoResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<KnownGender> KNOWN_GENDER_FIELD = SdkField.<KnownGender> builder(MarshallingType.SDK_POJO)
            .memberName("KnownGender").getter(getter(GetCelebrityInfoResponse::knownGender)).setter(setter(Builder::knownGender))
            .constructor(KnownGender::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnownGender").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URLS_FIELD, NAME_FIELD,
            KNOWN_GENDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Urls", URLS_FIELD);
                    put("Name", NAME_FIELD);
                    put("KnownGender", KNOWN_GENDER_FIELD);
                }
            });

    private final List<String> urls;

    private final String name;

    private final KnownGender knownGender;

    private GetCelebrityInfoResponse(BuilderImpl builder) {
        super(builder);
        this.urls = builder.urls;
        this.name = builder.name;
        this.knownGender = builder.knownGender;
    }

    /**
     * For responses, this returns true if the service returned a value for the Urls property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUrls() {
        return urls != null && !(urls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of URLs pointing to additional celebrity information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUrls} method.
     * </p>
     * 
     * @return An array of URLs pointing to additional celebrity information.
     */
    public final List<String> urls() {
        return urls;
    }

    /**
     * <p>
     * The name of the celebrity.
     * </p>
     * 
     * @return The name of the celebrity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Retrieves the known gender for the celebrity.
     * </p>
     * 
     * @return Retrieves the known gender for the celebrity.
     */
    public final KnownGender knownGender() {
        return knownGender;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUrls() ? urls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(knownGender());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCelebrityInfoResponse)) {
            return false;
        }
        GetCelebrityInfoResponse other = (GetCelebrityInfoResponse) obj;
        return hasUrls() == other.hasUrls() && Objects.equals(urls(), other.urls()) && Objects.equals(name(), other.name())
                && Objects.equals(knownGender(), other.knownGender());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCelebrityInfoResponse").add("Urls", hasUrls() ? urls() : null).add("Name", name())
                .add("KnownGender", knownGender()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Urls":
            return Optional.ofNullable(clazz.cast(urls()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "KnownGender":
            return Optional.ofNullable(clazz.cast(knownGender()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCelebrityInfoResponse, T> g) {
        return obj -> g.apply((GetCelebrityInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCelebrityInfoResponse> {
        /**
         * <p>
         * An array of URLs pointing to additional celebrity information.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional celebrity information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(Collection<String> urls);

        /**
         * <p>
         * An array of URLs pointing to additional celebrity information.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional celebrity information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(String... urls);

        /**
         * <p>
         * The name of the celebrity.
         * </p>
         * 
         * @param name
         *        The name of the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Retrieves the known gender for the celebrity.
         * </p>
         * 
         * @param knownGender
         *        Retrieves the known gender for the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knownGender(KnownGender knownGender);

        /**
         * <p>
         * Retrieves the known gender for the celebrity.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnownGender.Builder} avoiding the need to
         * create one manually via {@link KnownGender#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnownGender.Builder#build()} is called immediately and its result
         * is passed to {@link #knownGender(KnownGender)}.
         * 
         * @param knownGender
         *        a consumer that will call methods on {@link KnownGender.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knownGender(KnownGender)
         */
        default Builder knownGender(Consumer<KnownGender.Builder> knownGender) {
            return knownGender(KnownGender.builder().applyMutation(knownGender).build());
        }
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private KnownGender knownGender;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCelebrityInfoResponse model) {
            super(model);
            urls(model.urls);
            name(model.name);
            knownGender(model.knownGender);
        }

        public final Collection<String> getUrls() {
            if (urls instanceof SdkAutoConstructList) {
                return null;
            }
            return urls;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String... urls) {
            urls(Arrays.asList(urls));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final KnownGender.Builder getKnownGender() {
            return knownGender != null ? knownGender.toBuilder() : null;
        }

        public final void setKnownGender(KnownGender.BuilderImpl knownGender) {
            this.knownGender = knownGender != null ? knownGender.build() : null;
        }

        @Override
        public final Builder knownGender(KnownGender knownGender) {
            this.knownGender = knownGender;
            return this;
        }

        @Override
        public GetCelebrityInfoResponse build() {
            return new GetCelebrityInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
