/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a label detection request, including the SortBy and AggregateBy options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLabelDetectionRequestMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<GetLabelDetectionRequestMetadata.Builder, GetLabelDetectionRequestMetadata> {
    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(GetLabelDetectionRequestMetadata::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> AGGREGATE_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregateBy").getter(getter(GetLabelDetectionRequestMetadata::aggregateByAsString))
            .setter(setter(Builder::aggregateBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_FIELD,
            AGGREGATE_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SortBy", SORT_BY_FIELD);
                    put("AggregateBy", AGGREGATE_BY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String sortBy;

    private final String aggregateBy;

    private GetLabelDetectionRequestMetadata(BuilderImpl builder) {
        this.sortBy = builder.sortBy;
        this.aggregateBy = builder.aggregateBy;
    }

    /**
     * <p>
     * The sorting method chosen for a GetLabelDetection request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link LabelDetectionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The sorting method chosen for a GetLabelDetection request.
     * @see LabelDetectionSortBy
     */
    public final LabelDetectionSortBy sortBy() {
        return LabelDetectionSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The sorting method chosen for a GetLabelDetection request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link LabelDetectionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The sorting method chosen for a GetLabelDetection request.
     * @see LabelDetectionSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The aggregation method chosen for a GetLabelDetection request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregateBy} will
     * return {@link LabelDetectionAggregateBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #aggregateByAsString}.
     * </p>
     * 
     * @return The aggregation method chosen for a GetLabelDetection request.
     * @see LabelDetectionAggregateBy
     */
    public final LabelDetectionAggregateBy aggregateBy() {
        return LabelDetectionAggregateBy.fromValue(aggregateBy);
    }

    /**
     * <p>
     * The aggregation method chosen for a GetLabelDetection request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregateBy} will
     * return {@link LabelDetectionAggregateBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #aggregateByAsString}.
     * </p>
     * 
     * @return The aggregation method chosen for a GetLabelDetection request.
     * @see LabelDetectionAggregateBy
     */
    public final String aggregateByAsString() {
        return aggregateBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLabelDetectionRequestMetadata)) {
            return false;
        }
        GetLabelDetectionRequestMetadata other = (GetLabelDetectionRequestMetadata) obj;
        return Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(aggregateByAsString(), other.aggregateByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLabelDetectionRequestMetadata").add("SortBy", sortByAsString())
                .add("AggregateBy", aggregateByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "AggregateBy":
            return Optional.ofNullable(clazz.cast(aggregateByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLabelDetectionRequestMetadata, T> g) {
        return obj -> g.apply((GetLabelDetectionRequestMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetLabelDetectionRequestMetadata> {
        /**
         * <p>
         * The sorting method chosen for a GetLabelDetection request.
         * </p>
         * 
         * @param sortBy
         *        The sorting method chosen for a GetLabelDetection request.
         * @see LabelDetectionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelDetectionSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The sorting method chosen for a GetLabelDetection request.
         * </p>
         * 
         * @param sortBy
         *        The sorting method chosen for a GetLabelDetection request.
         * @see LabelDetectionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelDetectionSortBy
         */
        Builder sortBy(LabelDetectionSortBy sortBy);

        /**
         * <p>
         * The aggregation method chosen for a GetLabelDetection request.
         * </p>
         * 
         * @param aggregateBy
         *        The aggregation method chosen for a GetLabelDetection request.
         * @see LabelDetectionAggregateBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelDetectionAggregateBy
         */
        Builder aggregateBy(String aggregateBy);

        /**
         * <p>
         * The aggregation method chosen for a GetLabelDetection request.
         * </p>
         * 
         * @param aggregateBy
         *        The aggregation method chosen for a GetLabelDetection request.
         * @see LabelDetectionAggregateBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelDetectionAggregateBy
         */
        Builder aggregateBy(LabelDetectionAggregateBy aggregateBy);
    }

    static final class BuilderImpl implements Builder {
        private String sortBy;

        private String aggregateBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLabelDetectionRequestMetadata model) {
            sortBy(model.sortBy);
            aggregateBy(model.aggregateBy);
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(LabelDetectionSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getAggregateBy() {
            return aggregateBy;
        }

        public final void setAggregateBy(String aggregateBy) {
            this.aggregateBy = aggregateBy;
        }

        @Override
        public final Builder aggregateBy(String aggregateBy) {
            this.aggregateBy = aggregateBy;
            return this;
        }

        @Override
        public final Builder aggregateBy(LabelDetectionAggregateBy aggregateBy) {
            this.aggregateBy(aggregateBy == null ? null : aggregateBy.toString());
            return this;
        }

        @Override
        public GetLabelDetectionRequestMetadata build() {
            return new GetLabelDetectionRequestMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
