/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sets up the flow definition the image will be sent to if one of the conditions is met. You can also set certain
 * attributes of the image before review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopConfig implements SdkPojo, Serializable, ToCopyableBuilder<HumanLoopConfig.Builder, HumanLoopConfig> {
    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopName").getter(getter(HumanLoopConfig::humanLoopName)).setter(setter(Builder::humanLoopName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()).build();

    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowDefinitionArn").getter(getter(HumanLoopConfig::flowDefinitionArn))
            .setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()).build();

    private static final SdkField<HumanLoopDataAttributes> DATA_ATTRIBUTES_FIELD = SdkField
            .<HumanLoopDataAttributes> builder(MarshallingType.SDK_POJO).memberName("DataAttributes")
            .getter(getter(HumanLoopConfig::dataAttributes)).setter(setter(Builder::dataAttributes))
            .constructor(HumanLoopDataAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_NAME_FIELD,
            FLOW_DEFINITION_ARN_FIELD, DATA_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("HumanLoopName", HUMAN_LOOP_NAME_FIELD);
                    put("FlowDefinitionArn", FLOW_DEFINITION_ARN_FIELD);
                    put("DataAttributes", DATA_ATTRIBUTES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String humanLoopName;

    private final String flowDefinitionArn;

    private final HumanLoopDataAttributes dataAttributes;

    private HumanLoopConfig(BuilderImpl builder) {
        this.humanLoopName = builder.humanLoopName;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.dataAttributes = builder.dataAttributes;
    }

    /**
     * <p>
     * The name of the human review used for this image. This should be kept unique within a region.
     * </p>
     * 
     * @return The name of the human review used for this image. This should be kept unique within a region.
     */
    public final String humanLoopName() {
        return humanLoopName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the Amazon
     * Sagemaker <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html">CreateFlowDefinition</a>
     * Operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the
     *         Amazon Sagemaker <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html">
     *         CreateFlowDefinition</a> Operation.
     */
    public final String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    /**
     * <p>
     * Sets attributes of the input data.
     * </p>
     * 
     * @return Sets attributes of the input data.
     */
    public final HumanLoopDataAttributes dataAttributes() {
        return dataAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopConfig)) {
            return false;
        }
        HumanLoopConfig other = (HumanLoopConfig) obj;
        return Objects.equals(humanLoopName(), other.humanLoopName())
                && Objects.equals(flowDefinitionArn(), other.flowDefinitionArn())
                && Objects.equals(dataAttributes(), other.dataAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanLoopConfig").add("HumanLoopName", humanLoopName())
                .add("FlowDefinitionArn", flowDefinitionArn()).add("DataAttributes", dataAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopName":
            return Optional.ofNullable(clazz.cast(humanLoopName()));
        case "FlowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        case "DataAttributes":
            return Optional.ofNullable(clazz.cast(dataAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopConfig, T> g) {
        return obj -> g.apply((HumanLoopConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopConfig> {
        /**
         * <p>
         * The name of the human review used for this image. This should be kept unique within a region.
         * </p>
         * 
         * @param humanLoopName
         *        The name of the human review used for this image. This should be kept unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopName(String humanLoopName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the Amazon
         * Sagemaker <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html">CreateFlowDefinition</a>
         * Operation.
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the
         *        Amazon Sagemaker <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html"
         *        >CreateFlowDefinition</a> Operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);

        /**
         * <p>
         * Sets attributes of the input data.
         * </p>
         * 
         * @param dataAttributes
         *        Sets attributes of the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAttributes(HumanLoopDataAttributes dataAttributes);

        /**
         * <p>
         * Sets attributes of the input data.
         * </p>
         * This is a convenience method that creates an instance of the {@link HumanLoopDataAttributes.Builder} avoiding
         * the need to create one manually via {@link HumanLoopDataAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HumanLoopDataAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #dataAttributes(HumanLoopDataAttributes)}.
         * 
         * @param dataAttributes
         *        a consumer that will call methods on {@link HumanLoopDataAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataAttributes(HumanLoopDataAttributes)
         */
        default Builder dataAttributes(Consumer<HumanLoopDataAttributes.Builder> dataAttributes) {
            return dataAttributes(HumanLoopDataAttributes.builder().applyMutation(dataAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String humanLoopName;

        private String flowDefinitionArn;

        private HumanLoopDataAttributes dataAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopConfig model) {
            humanLoopName(model.humanLoopName);
            flowDefinitionArn(model.flowDefinitionArn);
            dataAttributes(model.dataAttributes);
        }

        public final String getHumanLoopName() {
            return humanLoopName;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final HumanLoopDataAttributes.Builder getDataAttributes() {
            return dataAttributes != null ? dataAttributes.toBuilder() : null;
        }

        public final void setDataAttributes(HumanLoopDataAttributes.BuilderImpl dataAttributes) {
            this.dataAttributes = dataAttributes != null ? dataAttributes.build() : null;
        }

        @Override
        public final Builder dataAttributes(HumanLoopDataAttributes dataAttributes) {
            this.dataAttributes = dataAttributes;
            return this;
        }

        @Override
        public HumanLoopConfig build() {
            return new HumanLoopConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
