/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the location of the landmark on the face.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Landmark implements SdkPojo, Serializable, ToCopyableBuilder<Landmark.Builder, Landmark> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Landmark::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Float> X_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("X")
            .getter(getter(Landmark::x)).setter(setter(Builder::x))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("X").build()).build();

    private static final SdkField<Float> Y_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Y")
            .getter(getter(Landmark::y)).setter(setter(Builder::y))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Y").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, X_FIELD, Y_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Type", TYPE_FIELD);
                    put("X", X_FIELD);
                    put("Y", Y_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Float x;

    private final Float y;

    private Landmark(BuilderImpl builder) {
        this.type = builder.type;
        this.x = builder.x;
        this.y = builder.y;
    }

    /**
     * <p>
     * Type of landmark.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LandmarkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of landmark.
     * @see LandmarkType
     */
    public final LandmarkType type() {
        return LandmarkType.fromValue(type);
    }

    /**
     * <p>
     * Type of landmark.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LandmarkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of landmark.
     * @see LandmarkType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The x-coordinate of the landmark expressed as a ratio of the width of the image. The x-coordinate is measured
     * from the left-side of the image. For example, if the image is 700 pixels wide and the x-coordinate of the
     * landmark is at 350 pixels, this value is 0.5.
     * </p>
     * 
     * @return The x-coordinate of the landmark expressed as a ratio of the width of the image. The x-coordinate is
     *         measured from the left-side of the image. For example, if the image is 700 pixels wide and the
     *         x-coordinate of the landmark is at 350 pixels, this value is 0.5.
     */
    public final Float x() {
        return x;
    }

    /**
     * <p>
     * The y-coordinate of the landmark expressed as a ratio of the height of the image. The y-coordinate is measured
     * from the top of the image. For example, if the image height is 200 pixels and the y-coordinate of the landmark is
     * at 50 pixels, this value is 0.25.
     * </p>
     * 
     * @return The y-coordinate of the landmark expressed as a ratio of the height of the image. The y-coordinate is
     *         measured from the top of the image. For example, if the image height is 200 pixels and the y-coordinate
     *         of the landmark is at 50 pixels, this value is 0.25.
     */
    public final Float y() {
        return y;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(x());
        hashCode = 31 * hashCode + Objects.hashCode(y());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Landmark)) {
            return false;
        }
        Landmark other = (Landmark) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(x(), other.x())
                && Objects.equals(y(), other.y());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Landmark").add("Type", typeAsString()).add("X", x()).add("Y", y()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "X":
            return Optional.ofNullable(clazz.cast(x()));
        case "Y":
            return Optional.ofNullable(clazz.cast(y()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Landmark, T> g) {
        return obj -> g.apply((Landmark) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Landmark> {
        /**
         * <p>
         * Type of landmark.
         * </p>
         * 
         * @param type
         *        Type of landmark.
         * @see LandmarkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandmarkType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of landmark.
         * </p>
         * 
         * @param type
         *        Type of landmark.
         * @see LandmarkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandmarkType
         */
        Builder type(LandmarkType type);

        /**
         * <p>
         * The x-coordinate of the landmark expressed as a ratio of the width of the image. The x-coordinate is measured
         * from the left-side of the image. For example, if the image is 700 pixels wide and the x-coordinate of the
         * landmark is at 350 pixels, this value is 0.5.
         * </p>
         * 
         * @param x
         *        The x-coordinate of the landmark expressed as a ratio of the width of the image. The x-coordinate is
         *        measured from the left-side of the image. For example, if the image is 700 pixels wide and the
         *        x-coordinate of the landmark is at 350 pixels, this value is 0.5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x(Float x);

        /**
         * <p>
         * The y-coordinate of the landmark expressed as a ratio of the height of the image. The y-coordinate is
         * measured from the top of the image. For example, if the image height is 200 pixels and the y-coordinate of
         * the landmark is at 50 pixels, this value is 0.25.
         * </p>
         * 
         * @param y
         *        The y-coordinate of the landmark expressed as a ratio of the height of the image. The y-coordinate is
         *        measured from the top of the image. For example, if the image height is 200 pixels and the
         *        y-coordinate of the landmark is at 50 pixels, this value is 0.25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder y(Float y);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Float x;

        private Float y;

        private BuilderImpl() {
        }

        private BuilderImpl(Landmark model) {
            type(model.type);
            x(model.x);
            y(model.y);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LandmarkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getX() {
            return x;
        }

        public final void setX(Float x) {
            this.x = x;
        }

        @Override
        public final Builder x(Float x) {
            this.x = x;
            return this;
        }

        public final Float getY() {
            return y;
        }

        public final void setY(Float y) {
            this.y = y;
        }

        @Override
        public final Builder y(Float y) {
            this.y = y;
            return this;
        }

        @Override
        public Landmark build() {
            return new Landmark(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
