/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatasetEntriesRequest extends RekognitionRequest implements
        ToCopyableBuilder<ListDatasetEntriesRequest.Builder, ListDatasetEntriesRequest> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(ListDatasetEntriesRequest::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<List<String>> CONTAINS_LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContainsLabels")
            .getter(getter(ListDatasetEntriesRequest::containsLabels))
            .setter(setter(Builder::containsLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> LABELED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Labeled").getter(getter(ListDatasetEntriesRequest::labeled)).setter(setter(Builder::labeled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labeled").build()).build();

    private static final SdkField<String> SOURCE_REF_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRefContains").getter(getter(ListDatasetEntriesRequest::sourceRefContains))
            .setter(setter(Builder::sourceRefContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRefContains").build()).build();

    private static final SdkField<Boolean> HAS_ERRORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasErrors").getter(getter(ListDatasetEntriesRequest::hasErrors)).setter(setter(Builder::hasErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasErrors").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDatasetEntriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDatasetEntriesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD,
            CONTAINS_LABELS_FIELD, LABELED_FIELD, SOURCE_REF_CONTAINS_FIELD, HAS_ERRORS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DatasetArn", DATASET_ARN_FIELD);
                    put("ContainsLabels", CONTAINS_LABELS_FIELD);
                    put("Labeled", LABELED_FIELD);
                    put("SourceRefContains", SOURCE_REF_CONTAINS_FIELD);
                    put("HasErrors", HAS_ERRORS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                }
            });

    private final String datasetArn;

    private final List<String> containsLabels;

    private final Boolean labeled;

    private final String sourceRefContains;

    private final Boolean hasErrors;

    private final String nextToken;

    private final Integer maxResults;

    private ListDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.datasetArn = builder.datasetArn;
        this.containsLabels = builder.containsLabels;
        this.labeled = builder.labeled;
        this.sourceRefContains = builder.sourceRefContains;
        this.hasErrors = builder.hasErrors;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the dataset that you want to use.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the dataset that you want to use.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainsLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainsLabels() {
        return containsLabels != null && !(containsLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a label filter for the response. The response includes an entry only if one or more of the labels in
     * <code>ContainsLabels</code> exist in the entry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainsLabels} method.
     * </p>
     * 
     * @return Specifies a label filter for the response. The response includes an entry only if one or more of the
     *         labels in <code>ContainsLabels</code> exist in the entry.
     */
    public final List<String> containsLabels() {
        return containsLabels;
    }

    /**
     * <p>
     * Specify <code>true</code> to get only the JSON Lines where the image is labeled. Specify <code>false</code> to
     * get only the JSON Lines where the image isn't labeled. If you don't specify <code>Labeled</code>,
     * <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled images.
     * </p>
     * 
     * @return Specify <code>true</code> to get only the JSON Lines where the image is labeled. Specify
     *         <code>false</code> to get only the JSON Lines where the image isn't labeled. If you don't specify
     *         <code>Labeled</code>, <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled
     *         images.
     */
    public final Boolean labeled() {
        return labeled;
    }

    /**
     * <p>
     * If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of
     * <code>SourceRefContains</code> is part of the <code>source-ref</code> field. The <code>source-ref</code> field
     * contains the Amazon S3 location of the image. You can use <code>SouceRefContains</code> for tasks such as getting
     * the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.
     * </p>
     * 
     * @return If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of
     *         <code>SourceRefContains</code> is part of the <code>source-ref</code> field. The <code>source-ref</code>
     *         field contains the Amazon S3 location of the image. You can use <code>SouceRefContains</code> for tasks
     *         such as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific
     *         folder.
     */
    public final String sourceRefContains() {
        return sourceRefContains;
    }

    /**
     * <p>
     * Specifies an error filter for the response. Specify <code>True</code> to only include entries that have errors.
     * </p>
     * 
     * @return Specifies an error filter for the response. Specify <code>True</code> to only include entries that have
     *         errors.
     */
    public final Boolean hasErrors() {
        return hasErrors;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom
     * Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     * results.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition
     *         Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve
     *         the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
     * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     * </p>
     * 
     * @return The maximum number of results to return per paginated call. The largest value you can specify is 100. If
     *         you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainsLabels() ? containsLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(labeled());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRefContains());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetEntriesRequest)) {
            return false;
        }
        ListDatasetEntriesRequest other = (ListDatasetEntriesRequest) obj;
        return Objects.equals(datasetArn(), other.datasetArn()) && hasContainsLabels() == other.hasContainsLabels()
                && Objects.equals(containsLabels(), other.containsLabels()) && Objects.equals(labeled(), other.labeled())
                && Objects.equals(sourceRefContains(), other.sourceRefContains())
                && Objects.equals(hasErrors(), other.hasErrors()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDatasetEntriesRequest").add("DatasetArn", datasetArn())
                .add("ContainsLabels", hasContainsLabels() ? containsLabels() : null).add("Labeled", labeled())
                .add("SourceRefContains", sourceRefContains()).add("HasErrors", hasErrors()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "ContainsLabels":
            return Optional.ofNullable(clazz.cast(containsLabels()));
        case "Labeled":
            return Optional.ofNullable(clazz.cast(labeled()));
        case "SourceRefContains":
            return Optional.ofNullable(clazz.cast(sourceRefContains()));
        case "HasErrors":
            return Optional.ofNullable(clazz.cast(hasErrors()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetEntriesRequest, T> g) {
        return obj -> g.apply((ListDatasetEntriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDatasetEntriesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the dataset that you want to use.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) for the dataset that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * Specifies a label filter for the response. The response includes an entry only if one or more of the labels
         * in <code>ContainsLabels</code> exist in the entry.
         * </p>
         * 
         * @param containsLabels
         *        Specifies a label filter for the response. The response includes an entry only if one or more of the
         *        labels in <code>ContainsLabels</code> exist in the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsLabels(Collection<String> containsLabels);

        /**
         * <p>
         * Specifies a label filter for the response. The response includes an entry only if one or more of the labels
         * in <code>ContainsLabels</code> exist in the entry.
         * </p>
         * 
         * @param containsLabels
         *        Specifies a label filter for the response. The response includes an entry only if one or more of the
         *        labels in <code>ContainsLabels</code> exist in the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsLabels(String... containsLabels);

        /**
         * <p>
         * Specify <code>true</code> to get only the JSON Lines where the image is labeled. Specify <code>false</code>
         * to get only the JSON Lines where the image isn't labeled. If you don't specify <code>Labeled</code>,
         * <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled images.
         * </p>
         * 
         * @param labeled
         *        Specify <code>true</code> to get only the JSON Lines where the image is labeled. Specify
         *        <code>false</code> to get only the JSON Lines where the image isn't labeled. If you don't specify
         *        <code>Labeled</code>, <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labeled(Boolean labeled);

        /**
         * <p>
         * If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of
         * <code>SourceRefContains</code> is part of the <code>source-ref</code> field. The <code>source-ref</code>
         * field contains the Amazon S3 location of the image. You can use <code>SouceRefContains</code> for tasks such
         * as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.
         * </p>
         * 
         * @param sourceRefContains
         *        If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of
         *        <code>SourceRefContains</code> is part of the <code>source-ref</code> field. The
         *        <code>source-ref</code> field contains the Amazon S3 location of the image. You can use
         *        <code>SouceRefContains</code> for tasks such as getting the JSON Line for a single image, or gettting
         *        JSON Lines for all images within a specific folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRefContains(String sourceRefContains);

        /**
         * <p>
         * Specifies an error filter for the response. Specify <code>True</code> to only include entries that have
         * errors.
         * </p>
         * 
         * @param hasErrors
         *        Specifies an error filter for the response. Specify <code>True</code> to only include entries that
         *        have errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasErrors(Boolean hasErrors);

        /**
         * <p>
         * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition
         * Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more results to retrieve), Amazon
         *        Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
         *        token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per paginated call. The largest value you can specify is 100. If you
         * specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per paginated call. The largest value you can specify is 100.
         *        If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String datasetArn;

        private List<String> containsLabels = DefaultSdkAutoConstructList.getInstance();

        private Boolean labeled;

        private String sourceRefContains;

        private Boolean hasErrors;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetEntriesRequest model) {
            super(model);
            datasetArn(model.datasetArn);
            containsLabels(model.containsLabels);
            labeled(model.labeled);
            sourceRefContains(model.sourceRefContains);
            hasErrors(model.hasErrors);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final Collection<String> getContainsLabels() {
            if (containsLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return containsLabels;
        }

        public final void setContainsLabels(Collection<String> containsLabels) {
            this.containsLabels = DatasetLabelsCopier.copy(containsLabels);
        }

        @Override
        public final Builder containsLabels(Collection<String> containsLabels) {
            this.containsLabels = DatasetLabelsCopier.copy(containsLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containsLabels(String... containsLabels) {
            containsLabels(Arrays.asList(containsLabels));
            return this;
        }

        public final Boolean getLabeled() {
            return labeled;
        }

        public final void setLabeled(Boolean labeled) {
            this.labeled = labeled;
        }

        @Override
        public final Builder labeled(Boolean labeled) {
            this.labeled = labeled;
            return this;
        }

        public final String getSourceRefContains() {
            return sourceRefContains;
        }

        public final void setSourceRefContains(String sourceRefContains) {
            this.sourceRefContains = sourceRefContains;
        }

        @Override
        public final Builder sourceRefContains(String sourceRefContains) {
            this.sourceRefContains = sourceRefContains;
            return this;
        }

        public final Boolean getHasErrors() {
            return hasErrors;
        }

        public final void setHasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
        }

        @Override
        public final Builder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDatasetEntriesRequest build() {
            return new ListDatasetEntriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
