/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Description for a media analysis job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaAnalysisJobDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaAnalysisJobDescription.Builder, MediaAnalysisJobDescription> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(MediaAnalysisJobDescription::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(MediaAnalysisJobDescription::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<MediaAnalysisOperationsConfig> OPERATIONS_CONFIG_FIELD = SdkField
            .<MediaAnalysisOperationsConfig> builder(MarshallingType.SDK_POJO).memberName("OperationsConfig")
            .getter(getter(MediaAnalysisJobDescription::operationsConfig)).setter(setter(Builder::operationsConfig))
            .constructor(MediaAnalysisOperationsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationsConfig").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MediaAnalysisJobDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<MediaAnalysisJobFailureDetails> FAILURE_DETAILS_FIELD = SdkField
            .<MediaAnalysisJobFailureDetails> builder(MarshallingType.SDK_POJO).memberName("FailureDetails")
            .getter(getter(MediaAnalysisJobDescription::failureDetails)).setter(setter(Builder::failureDetails))
            .constructor(MediaAnalysisJobFailureDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(MediaAnalysisJobDescription::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<Instant> COMPLETION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTimestamp").getter(getter(MediaAnalysisJobDescription::completionTimestamp))
            .setter(setter(Builder::completionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTimestamp").build())
            .build();

    private static final SdkField<MediaAnalysisInput> INPUT_FIELD = SdkField
            .<MediaAnalysisInput> builder(MarshallingType.SDK_POJO).memberName("Input")
            .getter(getter(MediaAnalysisJobDescription::input)).setter(setter(Builder::input))
            .constructor(MediaAnalysisInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<MediaAnalysisOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<MediaAnalysisOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(MediaAnalysisJobDescription::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(MediaAnalysisOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(MediaAnalysisJobDescription::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<MediaAnalysisResults> RESULTS_FIELD = SdkField
            .<MediaAnalysisResults> builder(MarshallingType.SDK_POJO).memberName("Results")
            .getter(getter(MediaAnalysisJobDescription::results)).setter(setter(Builder::results))
            .constructor(MediaAnalysisResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build()).build();

    private static final SdkField<MediaAnalysisManifestSummary> MANIFEST_SUMMARY_FIELD = SdkField
            .<MediaAnalysisManifestSummary> builder(MarshallingType.SDK_POJO).memberName("ManifestSummary")
            .getter(getter(MediaAnalysisJobDescription::manifestSummary)).setter(setter(Builder::manifestSummary))
            .constructor(MediaAnalysisManifestSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD,
            OPERATIONS_CONFIG_FIELD, STATUS_FIELD, FAILURE_DETAILS_FIELD, CREATION_TIMESTAMP_FIELD, COMPLETION_TIMESTAMP_FIELD,
            INPUT_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD, RESULTS_FIELD, MANIFEST_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("JobId", JOB_ID_FIELD);
                    put("JobName", JOB_NAME_FIELD);
                    put("OperationsConfig", OPERATIONS_CONFIG_FIELD);
                    put("Status", STATUS_FIELD);
                    put("FailureDetails", FAILURE_DETAILS_FIELD);
                    put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
                    put("CompletionTimestamp", COMPLETION_TIMESTAMP_FIELD);
                    put("Input", INPUT_FIELD);
                    put("OutputConfig", OUTPUT_CONFIG_FIELD);
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                    put("Results", RESULTS_FIELD);
                    put("ManifestSummary", MANIFEST_SUMMARY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobName;

    private final MediaAnalysisOperationsConfig operationsConfig;

    private final String status;

    private final MediaAnalysisJobFailureDetails failureDetails;

    private final Instant creationTimestamp;

    private final Instant completionTimestamp;

    private final MediaAnalysisInput input;

    private final MediaAnalysisOutputConfig outputConfig;

    private final String kmsKeyId;

    private final MediaAnalysisResults results;

    private final MediaAnalysisManifestSummary manifestSummary;

    private MediaAnalysisJobDescription(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.operationsConfig = builder.operationsConfig;
        this.status = builder.status;
        this.failureDetails = builder.failureDetails;
        this.creationTimestamp = builder.creationTimestamp;
        this.completionTimestamp = builder.completionTimestamp;
        this.input = builder.input;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.results = builder.results;
        this.manifestSummary = builder.manifestSummary;
    }

    /**
     * <p>
     * The identifier for a media analysis job.
     * </p>
     * 
     * @return The identifier for a media analysis job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of a media analysis job.
     * </p>
     * 
     * @return The name of a media analysis job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Operation configurations that were provided during job creation.
     * </p>
     * 
     * @return Operation configurations that were provided during job creation.
     */
    public final MediaAnalysisOperationsConfig operationsConfig() {
        return operationsConfig;
    }

    /**
     * <p>
     * The status of the media analysis job being retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaAnalysisJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the media analysis job being retrieved.
     * @see MediaAnalysisJobStatus
     */
    public final MediaAnalysisJobStatus status() {
        return MediaAnalysisJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the media analysis job being retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaAnalysisJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the media analysis job being retrieved.
     * @see MediaAnalysisJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Details about the error that resulted in failure of the job.
     * </p>
     * 
     * @return Details about the error that resulted in failure of the job.
     */
    public final MediaAnalysisJobFailureDetails failureDetails() {
        return failureDetails;
    }

    /**
     * <p>
     * The Unix date and time when the job was started.
     * </p>
     * 
     * @return The Unix date and time when the job was started.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The Unix date and time when the job finished.
     * </p>
     * 
     * @return The Unix date and time when the job finished.
     */
    public final Instant completionTimestamp() {
        return completionTimestamp;
    }

    /**
     * <p>
     * Reference to the input manifest that was provided in the job creation request.
     * </p>
     * 
     * @return Reference to the input manifest that was provided in the job creation request.
     */
    public final MediaAnalysisInput input() {
        return input;
    }

    /**
     * <p>
     * Output configuration that was provided in the creation request.
     * </p>
     * 
     * @return Output configuration that was provided in the creation request.
     */
    public final MediaAnalysisOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * KMS Key that was provided in the creation request.
     * </p>
     * 
     * @return KMS Key that was provided in the creation request.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Output manifest that contains prediction results.
     * </p>
     * 
     * @return Output manifest that contains prediction results.
     */
    public final MediaAnalysisResults results() {
        return results;
    }

    /**
     * <p>
     * Provides statistics on input manifest and errors identified in the input manifest.
     * </p>
     * 
     * @return Provides statistics on input manifest and errors identified in the input manifest.
     */
    public final MediaAnalysisManifestSummary manifestSummary() {
        return manifestSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(operationsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(completionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(results());
        hashCode = 31 * hashCode + Objects.hashCode(manifestSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaAnalysisJobDescription)) {
            return false;
        }
        MediaAnalysisJobDescription other = (MediaAnalysisJobDescription) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(operationsConfig(), other.operationsConfig())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureDetails(), other.failureDetails())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(completionTimestamp(), other.completionTimestamp()) && Objects.equals(input(), other.input())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(results(), other.results()) && Objects.equals(manifestSummary(), other.manifestSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaAnalysisJobDescription").add("JobId", jobId()).add("JobName", jobName())
                .add("OperationsConfig", operationsConfig()).add("Status", statusAsString())
                .add("FailureDetails", failureDetails()).add("CreationTimestamp", creationTimestamp())
                .add("CompletionTimestamp", completionTimestamp()).add("Input", input()).add("OutputConfig", outputConfig())
                .add("KmsKeyId", kmsKeyId()).add("Results", results()).add("ManifestSummary", manifestSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "OperationsConfig":
            return Optional.ofNullable(clazz.cast(operationsConfig()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureDetails":
            return Optional.ofNullable(clazz.cast(failureDetails()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "CompletionTimestamp":
            return Optional.ofNullable(clazz.cast(completionTimestamp()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "ManifestSummary":
            return Optional.ofNullable(clazz.cast(manifestSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MediaAnalysisJobDescription, T> g) {
        return obj -> g.apply((MediaAnalysisJobDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaAnalysisJobDescription> {
        /**
         * <p>
         * The identifier for a media analysis job.
         * </p>
         * 
         * @param jobId
         *        The identifier for a media analysis job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of a media analysis job.
         * </p>
         * 
         * @param jobName
         *        The name of a media analysis job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Operation configurations that were provided during job creation.
         * </p>
         * 
         * @param operationsConfig
         *        Operation configurations that were provided during job creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationsConfig(MediaAnalysisOperationsConfig operationsConfig);

        /**
         * <p>
         * Operation configurations that were provided during job creation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisOperationsConfig.Builder}
         * avoiding the need to create one manually via {@link MediaAnalysisOperationsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisOperationsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #operationsConfig(MediaAnalysisOperationsConfig)}.
         * 
         * @param operationsConfig
         *        a consumer that will call methods on {@link MediaAnalysisOperationsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationsConfig(MediaAnalysisOperationsConfig)
         */
        default Builder operationsConfig(Consumer<MediaAnalysisOperationsConfig.Builder> operationsConfig) {
            return operationsConfig(MediaAnalysisOperationsConfig.builder().applyMutation(operationsConfig).build());
        }

        /**
         * <p>
         * The status of the media analysis job being retrieved.
         * </p>
         * 
         * @param status
         *        The status of the media analysis job being retrieved.
         * @see MediaAnalysisJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaAnalysisJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the media analysis job being retrieved.
         * </p>
         * 
         * @param status
         *        The status of the media analysis job being retrieved.
         * @see MediaAnalysisJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaAnalysisJobStatus
         */
        Builder status(MediaAnalysisJobStatus status);

        /**
         * <p>
         * Details about the error that resulted in failure of the job.
         * </p>
         * 
         * @param failureDetails
         *        Details about the error that resulted in failure of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDetails(MediaAnalysisJobFailureDetails failureDetails);

        /**
         * <p>
         * Details about the error that resulted in failure of the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisJobFailureDetails.Builder}
         * avoiding the need to create one manually via {@link MediaAnalysisJobFailureDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisJobFailureDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #failureDetails(MediaAnalysisJobFailureDetails)}.
         * 
         * @param failureDetails
         *        a consumer that will call methods on {@link MediaAnalysisJobFailureDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureDetails(MediaAnalysisJobFailureDetails)
         */
        default Builder failureDetails(Consumer<MediaAnalysisJobFailureDetails.Builder> failureDetails) {
            return failureDetails(MediaAnalysisJobFailureDetails.builder().applyMutation(failureDetails).build());
        }

        /**
         * <p>
         * The Unix date and time when the job was started.
         * </p>
         * 
         * @param creationTimestamp
         *        The Unix date and time when the job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The Unix date and time when the job finished.
         * </p>
         * 
         * @param completionTimestamp
         *        The Unix date and time when the job finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTimestamp(Instant completionTimestamp);

        /**
         * <p>
         * Reference to the input manifest that was provided in the job creation request.
         * </p>
         * 
         * @param input
         *        Reference to the input manifest that was provided in the job creation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(MediaAnalysisInput input);

        /**
         * <p>
         * Reference to the input manifest that was provided in the job creation request.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisInput.Builder} avoiding the
         * need to create one manually via {@link MediaAnalysisInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisInput.Builder#build()} is called immediately and its
         * result is passed to {@link #input(MediaAnalysisInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link MediaAnalysisInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(MediaAnalysisInput)
         */
        default Builder input(Consumer<MediaAnalysisInput.Builder> input) {
            return input(MediaAnalysisInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Output configuration that was provided in the creation request.
         * </p>
         * 
         * @param outputConfig
         *        Output configuration that was provided in the creation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(MediaAnalysisOutputConfig outputConfig);

        /**
         * <p>
         * Output configuration that was provided in the creation request.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisOutputConfig.Builder}
         * avoiding the need to create one manually via {@link MediaAnalysisOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfig(MediaAnalysisOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link MediaAnalysisOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(MediaAnalysisOutputConfig)
         */
        default Builder outputConfig(Consumer<MediaAnalysisOutputConfig.Builder> outputConfig) {
            return outputConfig(MediaAnalysisOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * KMS Key that was provided in the creation request.
         * </p>
         * 
         * @param kmsKeyId
         *        KMS Key that was provided in the creation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Output manifest that contains prediction results.
         * </p>
         * 
         * @param results
         *        Output manifest that contains prediction results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(MediaAnalysisResults results);

        /**
         * <p>
         * Output manifest that contains prediction results.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisResults.Builder} avoiding
         * the need to create one manually via {@link MediaAnalysisResults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisResults.Builder#build()} is called immediately and
         * its result is passed to {@link #results(MediaAnalysisResults)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link MediaAnalysisResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(MediaAnalysisResults)
         */
        default Builder results(Consumer<MediaAnalysisResults.Builder> results) {
            return results(MediaAnalysisResults.builder().applyMutation(results).build());
        }

        /**
         * <p>
         * Provides statistics on input manifest and errors identified in the input manifest.
         * </p>
         * 
         * @param manifestSummary
         *        Provides statistics on input manifest and errors identified in the input manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestSummary(MediaAnalysisManifestSummary manifestSummary);

        /**
         * <p>
         * Provides statistics on input manifest and errors identified in the input manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisManifestSummary.Builder}
         * avoiding the need to create one manually via {@link MediaAnalysisManifestSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisManifestSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #manifestSummary(MediaAnalysisManifestSummary)}.
         * 
         * @param manifestSummary
         *        a consumer that will call methods on {@link MediaAnalysisManifestSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestSummary(MediaAnalysisManifestSummary)
         */
        default Builder manifestSummary(Consumer<MediaAnalysisManifestSummary.Builder> manifestSummary) {
            return manifestSummary(MediaAnalysisManifestSummary.builder().applyMutation(manifestSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobName;

        private MediaAnalysisOperationsConfig operationsConfig;

        private String status;

        private MediaAnalysisJobFailureDetails failureDetails;

        private Instant creationTimestamp;

        private Instant completionTimestamp;

        private MediaAnalysisInput input;

        private MediaAnalysisOutputConfig outputConfig;

        private String kmsKeyId;

        private MediaAnalysisResults results;

        private MediaAnalysisManifestSummary manifestSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaAnalysisJobDescription model) {
            jobId(model.jobId);
            jobName(model.jobName);
            operationsConfig(model.operationsConfig);
            status(model.status);
            failureDetails(model.failureDetails);
            creationTimestamp(model.creationTimestamp);
            completionTimestamp(model.completionTimestamp);
            input(model.input);
            outputConfig(model.outputConfig);
            kmsKeyId(model.kmsKeyId);
            results(model.results);
            manifestSummary(model.manifestSummary);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final MediaAnalysisOperationsConfig.Builder getOperationsConfig() {
            return operationsConfig != null ? operationsConfig.toBuilder() : null;
        }

        public final void setOperationsConfig(MediaAnalysisOperationsConfig.BuilderImpl operationsConfig) {
            this.operationsConfig = operationsConfig != null ? operationsConfig.build() : null;
        }

        @Override
        public final Builder operationsConfig(MediaAnalysisOperationsConfig operationsConfig) {
            this.operationsConfig = operationsConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaAnalysisJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final MediaAnalysisJobFailureDetails.Builder getFailureDetails() {
            return failureDetails != null ? failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(MediaAnalysisJobFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(MediaAnalysisJobFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getCompletionTimestamp() {
            return completionTimestamp;
        }

        public final void setCompletionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
        }

        @Override
        public final Builder completionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
            return this;
        }

        public final MediaAnalysisInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(MediaAnalysisInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(MediaAnalysisInput input) {
            this.input = input;
            return this;
        }

        public final MediaAnalysisOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(MediaAnalysisOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(MediaAnalysisOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final MediaAnalysisResults.Builder getResults() {
            return results != null ? results.toBuilder() : null;
        }

        public final void setResults(MediaAnalysisResults.BuilderImpl results) {
            this.results = results != null ? results.build() : null;
        }

        @Override
        public final Builder results(MediaAnalysisResults results) {
            this.results = results;
            return this;
        }

        public final MediaAnalysisManifestSummary.Builder getManifestSummary() {
            return manifestSummary != null ? manifestSummary.toBuilder() : null;
        }

        public final void setManifestSummary(MediaAnalysisManifestSummary.BuilderImpl manifestSummary) {
            this.manifestSummary = manifestSummary != null ? manifestSummary.build() : null;
        }

        @Override
        public final Builder manifestSummary(MediaAnalysisManifestSummary manifestSummary) {
            this.manifestSummary = manifestSummary;
            return this;
        }

        @Override
        public MediaAnalysisJobDescription build() {
            return new MediaAnalysisJobDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
