/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object containing information about the model versions of selected features in a given job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaAnalysisModelVersions implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaAnalysisModelVersions.Builder, MediaAnalysisModelVersions> {
    private static final SdkField<String> MODERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Moderation").getter(getter(MediaAnalysisModelVersions::moderation)).setter(setter(Builder::moderation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Moderation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Moderation", MODERATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String moderation;

    private MediaAnalysisModelVersions(BuilderImpl builder) {
        this.moderation = builder.moderation;
    }

    /**
     * <p>
     * The Moderation base model version.
     * </p>
     * 
     * @return The Moderation base model version.
     */
    public final String moderation() {
        return moderation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moderation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaAnalysisModelVersions)) {
            return false;
        }
        MediaAnalysisModelVersions other = (MediaAnalysisModelVersions) obj;
        return Objects.equals(moderation(), other.moderation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaAnalysisModelVersions").add("Moderation", moderation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Moderation":
            return Optional.ofNullable(clazz.cast(moderation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MediaAnalysisModelVersions, T> g) {
        return obj -> g.apply((MediaAnalysisModelVersions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaAnalysisModelVersions> {
        /**
         * <p>
         * The Moderation base model version.
         * </p>
         * 
         * @param moderation
         *        The Moderation base model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderation(String moderation);
    }

    static final class BuilderImpl implements Builder {
        private String moderation;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaAnalysisModelVersions model) {
            moderation(model.moderation);
        }

        public final String getModeration() {
            return moderation;
        }

        public final void setModeration(String moderation) {
            this.moderation = moderation;
        }

        @Override
        public final Builder moderation(String moderation) {
            this.moderation = moderation;
            return this;
        }

        @Override
        public MediaAnalysisModelVersions build() {
            return new MediaAnalysisModelVersions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
