/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for required items of personal protective equipment (PPE) detected on persons by a call to
 * <a>DetectProtectiveEquipment</a>. You specify the required type of PPE in the <code>SummarizationAttributes</code>
 * (<a>ProtectiveEquipmentSummarizationAttributes</a>) input parameter. The summary includes which persons were detected
 * wearing the required personal protective equipment (<code>PersonsWithRequiredEquipment</code>), which persons were
 * detected as not wearing the required PPE (<code>PersonsWithoutRequiredEquipment</code>), and the persons in which a
 * determination could not be made (<code>PersonsIndeterminate</code>).
 * </p>
 * <p>
 * To get a total for each category, use the size of the field array. For example, to find out how many people were
 * detected as wearing the specified PPE, use the size of the <code>PersonsWithRequiredEquipment</code> array. If you
 * want to find out more about a person, such as the location (<a>BoundingBox</a>) of the person on the image, use the
 * person ID in each array element. Each person ID matches the ID field of a <a>ProtectiveEquipmentPerson</a> object
 * returned in the <code>Persons</code> array by <code>DetectProtectiveEquipment</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectiveEquipmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectiveEquipmentSummary.Builder, ProtectiveEquipmentSummary> {
    private static final SdkField<List<Integer>> PERSONS_WITH_REQUIRED_EQUIPMENT_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("PersonsWithRequiredEquipment")
            .getter(getter(ProtectiveEquipmentSummary::personsWithRequiredEquipment))
            .setter(setter(Builder::personsWithRequiredEquipment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonsWithRequiredEquipment")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> PERSONS_WITHOUT_REQUIRED_EQUIPMENT_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("PersonsWithoutRequiredEquipment")
            .getter(getter(ProtectiveEquipmentSummary::personsWithoutRequiredEquipment))
            .setter(setter(Builder::personsWithoutRequiredEquipment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonsWithoutRequiredEquipment")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> PERSONS_INDETERMINATE_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("PersonsIndeterminate")
            .getter(getter(ProtectiveEquipmentSummary::personsIndeterminate))
            .setter(setter(Builder::personsIndeterminate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonsIndeterminate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PERSONS_WITH_REQUIRED_EQUIPMENT_FIELD, PERSONS_WITHOUT_REQUIRED_EQUIPMENT_FIELD, PERSONS_INDETERMINATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PersonsWithRequiredEquipment", PERSONS_WITH_REQUIRED_EQUIPMENT_FIELD);
                    put("PersonsWithoutRequiredEquipment", PERSONS_WITHOUT_REQUIRED_EQUIPMENT_FIELD);
                    put("PersonsIndeterminate", PERSONS_INDETERMINATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<Integer> personsWithRequiredEquipment;

    private final List<Integer> personsWithoutRequiredEquipment;

    private final List<Integer> personsIndeterminate;

    private ProtectiveEquipmentSummary(BuilderImpl builder) {
        this.personsWithRequiredEquipment = builder.personsWithRequiredEquipment;
        this.personsWithoutRequiredEquipment = builder.personsWithoutRequiredEquipment;
        this.personsIndeterminate = builder.personsIndeterminate;
    }

    /**
     * For responses, this returns true if the service returned a value for the PersonsWithRequiredEquipment property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPersonsWithRequiredEquipment() {
        return personsWithRequiredEquipment != null && !(personsWithRequiredEquipment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IDs for persons who are wearing detected personal protective equipment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersonsWithRequiredEquipment} method.
     * </p>
     * 
     * @return An array of IDs for persons who are wearing detected personal protective equipment.
     */
    public final List<Integer> personsWithRequiredEquipment() {
        return personsWithRequiredEquipment;
    }

    /**
     * For responses, this returns true if the service returned a value for the PersonsWithoutRequiredEquipment
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPersonsWithoutRequiredEquipment() {
        return personsWithoutRequiredEquipment != null && !(personsWithoutRequiredEquipment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IDs for persons who are not wearing all of the types of PPE specified in the
     * <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersonsWithoutRequiredEquipment}
     * method.
     * </p>
     * 
     * @return An array of IDs for persons who are not wearing all of the types of PPE specified in the
     *         <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment.
     */
    public final List<Integer> personsWithoutRequiredEquipment() {
        return personsWithoutRequiredEquipment;
    }

    /**
     * For responses, this returns true if the service returned a value for the PersonsIndeterminate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPersonsIndeterminate() {
        return personsIndeterminate != null && !(personsIndeterminate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IDs for persons where it was not possible to determine if they are wearing personal protective
     * equipment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersonsIndeterminate} method.
     * </p>
     * 
     * @return An array of IDs for persons where it was not possible to determine if they are wearing personal
     *         protective equipment.
     */
    public final List<Integer> personsIndeterminate() {
        return personsIndeterminate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPersonsWithRequiredEquipment() ? personsWithRequiredEquipment() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPersonsWithoutRequiredEquipment() ? personsWithoutRequiredEquipment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPersonsIndeterminate() ? personsIndeterminate() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectiveEquipmentSummary)) {
            return false;
        }
        ProtectiveEquipmentSummary other = (ProtectiveEquipmentSummary) obj;
        return hasPersonsWithRequiredEquipment() == other.hasPersonsWithRequiredEquipment()
                && Objects.equals(personsWithRequiredEquipment(), other.personsWithRequiredEquipment())
                && hasPersonsWithoutRequiredEquipment() == other.hasPersonsWithoutRequiredEquipment()
                && Objects.equals(personsWithoutRequiredEquipment(), other.personsWithoutRequiredEquipment())
                && hasPersonsIndeterminate() == other.hasPersonsIndeterminate()
                && Objects.equals(personsIndeterminate(), other.personsIndeterminate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ProtectiveEquipmentSummary")
                .add("PersonsWithRequiredEquipment", hasPersonsWithRequiredEquipment() ? personsWithRequiredEquipment() : null)
                .add("PersonsWithoutRequiredEquipment",
                        hasPersonsWithoutRequiredEquipment() ? personsWithoutRequiredEquipment() : null)
                .add("PersonsIndeterminate", hasPersonsIndeterminate() ? personsIndeterminate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PersonsWithRequiredEquipment":
            return Optional.ofNullable(clazz.cast(personsWithRequiredEquipment()));
        case "PersonsWithoutRequiredEquipment":
            return Optional.ofNullable(clazz.cast(personsWithoutRequiredEquipment()));
        case "PersonsIndeterminate":
            return Optional.ofNullable(clazz.cast(personsIndeterminate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProtectiveEquipmentSummary, T> g) {
        return obj -> g.apply((ProtectiveEquipmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectiveEquipmentSummary> {
        /**
         * <p>
         * An array of IDs for persons who are wearing detected personal protective equipment.
         * </p>
         * 
         * @param personsWithRequiredEquipment
         *        An array of IDs for persons who are wearing detected personal protective equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personsWithRequiredEquipment(Collection<Integer> personsWithRequiredEquipment);

        /**
         * <p>
         * An array of IDs for persons who are wearing detected personal protective equipment.
         * </p>
         * 
         * @param personsWithRequiredEquipment
         *        An array of IDs for persons who are wearing detected personal protective equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personsWithRequiredEquipment(Integer... personsWithRequiredEquipment);

        /**
         * <p>
         * An array of IDs for persons who are not wearing all of the types of PPE specified in the
         * <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment.
         * </p>
         * 
         * @param personsWithoutRequiredEquipment
         *        An array of IDs for persons who are not wearing all of the types of PPE specified in the
         *        <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personsWithoutRequiredEquipment(Collection<Integer> personsWithoutRequiredEquipment);

        /**
         * <p>
         * An array of IDs for persons who are not wearing all of the types of PPE specified in the
         * <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment.
         * </p>
         * 
         * @param personsWithoutRequiredEquipment
         *        An array of IDs for persons who are not wearing all of the types of PPE specified in the
         *        <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personsWithoutRequiredEquipment(Integer... personsWithoutRequiredEquipment);

        /**
         * <p>
         * An array of IDs for persons where it was not possible to determine if they are wearing personal protective
         * equipment.
         * </p>
         * 
         * @param personsIndeterminate
         *        An array of IDs for persons where it was not possible to determine if they are wearing personal
         *        protective equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personsIndeterminate(Collection<Integer> personsIndeterminate);

        /**
         * <p>
         * An array of IDs for persons where it was not possible to determine if they are wearing personal protective
         * equipment.
         * </p>
         * 
         * @param personsIndeterminate
         *        An array of IDs for persons where it was not possible to determine if they are wearing personal
         *        protective equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personsIndeterminate(Integer... personsIndeterminate);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> personsWithRequiredEquipment = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> personsWithoutRequiredEquipment = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> personsIndeterminate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectiveEquipmentSummary model) {
            personsWithRequiredEquipment(model.personsWithRequiredEquipment);
            personsWithoutRequiredEquipment(model.personsWithoutRequiredEquipment);
            personsIndeterminate(model.personsIndeterminate);
        }

        public final Collection<Integer> getPersonsWithRequiredEquipment() {
            if (personsWithRequiredEquipment instanceof SdkAutoConstructList) {
                return null;
            }
            return personsWithRequiredEquipment;
        }

        public final void setPersonsWithRequiredEquipment(Collection<Integer> personsWithRequiredEquipment) {
            this.personsWithRequiredEquipment = ProtectiveEquipmentPersonIdsCopier.copy(personsWithRequiredEquipment);
        }

        @Override
        public final Builder personsWithRequiredEquipment(Collection<Integer> personsWithRequiredEquipment) {
            this.personsWithRequiredEquipment = ProtectiveEquipmentPersonIdsCopier.copy(personsWithRequiredEquipment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personsWithRequiredEquipment(Integer... personsWithRequiredEquipment) {
            personsWithRequiredEquipment(Arrays.asList(personsWithRequiredEquipment));
            return this;
        }

        public final Collection<Integer> getPersonsWithoutRequiredEquipment() {
            if (personsWithoutRequiredEquipment instanceof SdkAutoConstructList) {
                return null;
            }
            return personsWithoutRequiredEquipment;
        }

        public final void setPersonsWithoutRequiredEquipment(Collection<Integer> personsWithoutRequiredEquipment) {
            this.personsWithoutRequiredEquipment = ProtectiveEquipmentPersonIdsCopier.copy(personsWithoutRequiredEquipment);
        }

        @Override
        public final Builder personsWithoutRequiredEquipment(Collection<Integer> personsWithoutRequiredEquipment) {
            this.personsWithoutRequiredEquipment = ProtectiveEquipmentPersonIdsCopier.copy(personsWithoutRequiredEquipment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personsWithoutRequiredEquipment(Integer... personsWithoutRequiredEquipment) {
            personsWithoutRequiredEquipment(Arrays.asList(personsWithoutRequiredEquipment));
            return this;
        }

        public final Collection<Integer> getPersonsIndeterminate() {
            if (personsIndeterminate instanceof SdkAutoConstructList) {
                return null;
            }
            return personsIndeterminate;
        }

        public final void setPersonsIndeterminate(Collection<Integer> personsIndeterminate) {
            this.personsIndeterminate = ProtectiveEquipmentPersonIdsCopier.copy(personsIndeterminate);
        }

        @Override
        public final Builder personsIndeterminate(Collection<Integer> personsIndeterminate) {
            this.personsIndeterminate = ProtectiveEquipmentPersonIdsCopier.copy(personsIndeterminate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personsIndeterminate(Integer... personsIndeterminate) {
            personsIndeterminate(Arrays.asList(personsIndeterminate));
            return this;
        }

        @Override
        public ProtectiveEquipmentSummary build() {
            return new ProtectiveEquipmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
