/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProjectPolicyRequest extends RekognitionRequest implements
        ToCopyableBuilder<PutProjectPolicyRequest.Builder, PutProjectPolicyRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectArn").getter(getter(PutProjectPolicyRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(PutProjectPolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyRevisionId").getter(getter(PutProjectPolicyRequest::policyRevisionId))
            .setter(setter(Builder::policyRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRevisionId").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument").getter(getter(PutProjectPolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            POLICY_NAME_FIELD, POLICY_REVISION_ID_FIELD, POLICY_DOCUMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProjectArn", PROJECT_ARN_FIELD);
                    put("PolicyName", POLICY_NAME_FIELD);
                    put("PolicyRevisionId", POLICY_REVISION_ID_FIELD);
                    put("PolicyDocument", POLICY_DOCUMENT_FIELD);
                }
            });

    private final String projectArn;

    private final String policyName;

    private final String policyRevisionId;

    private final String policyDocument;

    private PutProjectPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.policyName = builder.policyName;
        this.policyRevisionId = builder.policyRevisionId;
        this.policyDocument = builder.policyDocument;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project that the project policy is attached to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project that the project policy is attached to.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * A name for the policy.
     * </p>
     * 
     * @return A name for the policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The revision ID for the Project Policy. Each time you modify a policy, Amazon Rekognition Custom Labels generates
     * and assigns a new <code>PolicyRevisionId</code> and then deletes the previous version of the policy.
     * </p>
     * 
     * @return The revision ID for the Project Policy. Each time you modify a policy, Amazon Rekognition Custom Labels
     *         generates and assigns a new <code>PolicyRevisionId</code> and then deletes the previous version of the
     *         policy.
     */
    public final String policyRevisionId() {
        return policyRevisionId;
    }

    /**
     * <p>
     * A resource policy to add to the model. The policy is a JSON structure that contains one or more statements that
     * define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON
     * policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON
     * policy reference</a>.
     * </p>
     * 
     * @return A resource policy to add to the model. The policy is a JSON structure that contains one or more
     *         statements that define the policy. The policy must follow the IAM syntax. For more information about the
     *         contents of a JSON policy document, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON policy
     *         reference</a>.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyRevisionId());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProjectPolicyRequest)) {
            return false;
        }
        PutProjectPolicyRequest other = (PutProjectPolicyRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(policyRevisionId(), other.policyRevisionId())
                && Objects.equals(policyDocument(), other.policyDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutProjectPolicyRequest").add("ProjectArn", projectArn()).add("PolicyName", policyName())
                .add("PolicyRevisionId", policyRevisionId()).add("PolicyDocument", policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyRevisionId":
            return Optional.ofNullable(clazz.cast(policyRevisionId()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutProjectPolicyRequest, T> g) {
        return obj -> g.apply((PutProjectPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutProjectPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project that the project policy is attached to.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project that the project policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * A name for the policy.
         * </p>
         * 
         * @param policyName
         *        A name for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The revision ID for the Project Policy. Each time you modify a policy, Amazon Rekognition Custom Labels
         * generates and assigns a new <code>PolicyRevisionId</code> and then deletes the previous version of the
         * policy.
         * </p>
         * 
         * @param policyRevisionId
         *        The revision ID for the Project Policy. Each time you modify a policy, Amazon Rekognition Custom
         *        Labels generates and assigns a new <code>PolicyRevisionId</code> and then deletes the previous version
         *        of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRevisionId(String policyRevisionId);

        /**
         * <p>
         * A resource policy to add to the model. The policy is a JSON structure that contains one or more statements
         * that define the policy. The policy must follow the IAM syntax. For more information about the contents of a
         * JSON policy document, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON policy
         * reference</a>.
         * </p>
         * 
         * @param policyDocument
         *        A resource policy to add to the model. The policy is a JSON structure that contains one or more
         *        statements that define the policy. The policy must follow the IAM syntax. For more information about
         *        the contents of a JSON policy document, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON policy
         *        reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String policyName;

        private String policyRevisionId;

        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProjectPolicyRequest model) {
            super(model);
            projectArn(model.projectArn);
            policyName(model.policyName);
            policyRevisionId(model.policyRevisionId);
            policyDocument(model.policyDocument);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyRevisionId() {
            return policyRevisionId;
        }

        public final void setPolicyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
        }

        @Override
        public final Builder policyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProjectPolicyRequest build() {
            return new PutProjectPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
