/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFacesByImageRequest extends RekognitionRequest implements
        ToCopyableBuilder<SearchFacesByImageRequest.Builder, SearchFacesByImageRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionId").getter(getter(SearchFacesByImageRequest::collectionId))
            .setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()).build();

    private static final SdkField<Image> IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO).memberName("Image")
            .getter(getter(SearchFacesByImageRequest::image)).setter(setter(Builder::image)).constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<Integer> MAX_FACES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxFaces").getter(getter(SearchFacesByImageRequest::maxFaces)).setter(setter(Builder::maxFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFaces").build()).build();

    private static final SdkField<Float> FACE_MATCH_THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("FaceMatchThreshold").getter(getter(SearchFacesByImageRequest::faceMatchThreshold))
            .setter(setter(Builder::faceMatchThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatchThreshold").build())
            .build();

    private static final SdkField<String> QUALITY_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityFilter").getter(getter(SearchFacesByImageRequest::qualityFilterAsString))
            .setter(setter(Builder::qualityFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            IMAGE_FIELD, MAX_FACES_FIELD, FACE_MATCH_THRESHOLD_FIELD, QUALITY_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CollectionId", COLLECTION_ID_FIELD);
                    put("Image", IMAGE_FIELD);
                    put("MaxFaces", MAX_FACES_FIELD);
                    put("FaceMatchThreshold", FACE_MATCH_THRESHOLD_FIELD);
                    put("QualityFilter", QUALITY_FILTER_FIELD);
                }
            });

    private final String collectionId;

    private final Image image;

    private final Integer maxFaces;

    private final Float faceMatchThreshold;

    private final String qualityFilter;

    private SearchFacesByImageRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
        this.qualityFilter = builder.qualityFilter;
    }

    /**
     * <p>
     * ID of the collection to search.
     * </p>
     * 
     * @return ID of the collection to search.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
     * operations, passing base64-encoded image bytes is not supported.
     * </p>
     * <p>
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed
     * using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.
     * </p>
     * 
     * @return The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
     *         Rekognition operations, passing base64-encoded image bytes is not supported. </p>
     *         <p>
     *         If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
     *         passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
     *         developer guide.
     */
    public final Image image() {
        return image;
    }

    /**
     * <p>
     * Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence
     * in the match.
     * </p>
     * 
     * @return Maximum number of faces to return. The operation returns the maximum number of faces with the highest
     *         confidence in the match.
     */
    public final Integer maxFaces() {
        return maxFaces;
    }

    /**
     * <p>
     * (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any matches
     * where confidence in matches is less than 70%. The default value is 80%.
     * </p>
     * 
     * @return (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any
     *         matches where confidence in matches is less than 70%. The default value is 80%.
     */
    public final Float faceMatchThreshold() {
        return faceMatchThreshold;
    }

    /**
     * <p>
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
     * searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If
     * you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t
     * meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections
     * can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too
     * blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is
     * performed. The default value is <code>NONE</code>.
     * </p>
     * <p>
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
     * higher.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityFilter}
     * will return {@link QualityFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityFilterAsString}.
     * </p>
     * 
     * @return A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
     *         aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the
     *         quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering
     *         removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common
     *         use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's
     *         misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If
     *         you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
     *         <p>
     *         To use quality filtering, the collection you are using must be associated with version 3 of the face
     *         model or higher.
     * @see QualityFilter
     */
    public final QualityFilter qualityFilter() {
        return QualityFilter.fromValue(qualityFilter);
    }

    /**
     * <p>
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
     * searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If
     * you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t
     * meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections
     * can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too
     * blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is
     * performed. The default value is <code>NONE</code>.
     * </p>
     * <p>
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
     * higher.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityFilter}
     * will return {@link QualityFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityFilterAsString}.
     * </p>
     * 
     * @return A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
     *         aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the
     *         quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering
     *         removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common
     *         use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's
     *         misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If
     *         you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
     *         <p>
     *         To use quality filtering, the collection you are using must be associated with version 3 of the face
     *         model or higher.
     * @see QualityFilter
     */
    public final String qualityFilterAsString() {
        return qualityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(faceMatchThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(qualityFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageRequest)) {
            return false;
        }
        SearchFacesByImageRequest other = (SearchFacesByImageRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(image(), other.image())
                && Objects.equals(maxFaces(), other.maxFaces())
                && Objects.equals(faceMatchThreshold(), other.faceMatchThreshold())
                && Objects.equals(qualityFilterAsString(), other.qualityFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchFacesByImageRequest").add("CollectionId", collectionId()).add("Image", image())
                .add("MaxFaces", maxFaces()).add("FaceMatchThreshold", faceMatchThreshold())
                .add("QualityFilter", qualityFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "MaxFaces":
            return Optional.ofNullable(clazz.cast(maxFaces()));
        case "FaceMatchThreshold":
            return Optional.ofNullable(clazz.cast(faceMatchThreshold()));
        case "QualityFilter":
            return Optional.ofNullable(clazz.cast(qualityFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchFacesByImageRequest, T> g) {
        return obj -> g.apply((SearchFacesByImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchFacesByImageRequest> {
        /**
         * <p>
         * ID of the collection to search.
         * </p>
         * 
         * @param collectionId
         *        ID of the collection to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes is not supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * 
         * @param image
         *        The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
         *        Rekognition operations, passing base64-encoded image bytes is not supported. </p>
         *        <p>
         *        If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image
         *        bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon
         *        Rekognition developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes is not supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * Maximum number of faces to return. The operation returns the maximum number of faces with the highest
         * confidence in the match.
         * </p>
         * 
         * @param maxFaces
         *        Maximum number of faces to return. The operation returns the maximum number of faces with the highest
         *        confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFaces(Integer maxFaces);

        /**
         * <p>
         * (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any
         * matches where confidence in matches is less than 70%. The default value is 80%.
         * </p>
         * 
         * @param faceMatchThreshold
         *        (Optional) Specifies the minimum confidence in the face match to return. For example, don't return any
         *        matches where confidence in matches is less than 70%. The default value is 80%.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatchThreshold(Float faceMatchThreshold);

        /**
         * <p>
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
         * searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar.
         * If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
         * don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality
         * detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a
         * face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no
         * filtering is performed. The default value is <code>NONE</code>.
         * </p>
         * <p>
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
         * higher.
         * </p>
         * 
         * @param qualityFilter
         *        A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
         *        aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses
         *        the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering
         *        removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of
         *        common use cases. Low-quality detections can occur for a number of reasons. Some examples are an
         *        object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too
         *        extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is
         *        <code>NONE</code>. </p>
         *        <p>
         *        To use quality filtering, the collection you are using must be associated with version 3 of the face
         *        model or higher.
         * @see QualityFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualityFilter
         */
        Builder qualityFilter(String qualityFilter);

        /**
         * <p>
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
         * searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar.
         * If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
         * don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality
         * detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a
         * face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no
         * filtering is performed. The default value is <code>NONE</code>.
         * </p>
         * <p>
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
         * higher.
         * </p>
         * 
         * @param qualityFilter
         *        A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
         *        aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses
         *        the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering
         *        removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of
         *        common use cases. Low-quality detections can occur for a number of reasons. Some examples are an
         *        object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too
         *        extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is
         *        <code>NONE</code>. </p>
         *        <p>
         *        To use quality filtering, the collection you are using must be associated with version 3 of the face
         *        model or higher.
         * @see QualityFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualityFilter
         */
        Builder qualityFilter(QualityFilter qualityFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private Image image;

        private Integer maxFaces;

        private Float faceMatchThreshold;

        private String qualityFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageRequest model) {
            super(model);
            collectionId(model.collectionId);
            image(model.image);
            maxFaces(model.maxFaces);
            faceMatchThreshold(model.faceMatchThreshold);
            qualityFilter(model.qualityFilter);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final Integer getMaxFaces() {
            return maxFaces;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final Float getFaceMatchThreshold() {
            return faceMatchThreshold;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final String getQualityFilter() {
            return qualityFilter;
        }

        public final void setQualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
        }

        @Override
        public final Builder qualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
            return this;
        }

        @Override
        public final Builder qualityFilter(QualityFilter qualityFilter) {
            this.qualityFilter(qualityFilter == null ? null : qualityFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchFacesByImageRequest build() {
            return new SearchFacesByImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
