/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchUsersRequest extends RekognitionRequest implements
        ToCopyableBuilder<SearchUsersRequest.Builder, SearchUsersRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionId").getter(getter(SearchUsersRequest::collectionId)).setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(SearchUsersRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> FACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FaceId")
            .getter(getter(SearchUsersRequest::faceId)).setter(setter(Builder::faceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()).build();

    private static final SdkField<Float> USER_MATCH_THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("UserMatchThreshold").getter(getter(SearchUsersRequest::userMatchThreshold))
            .setter(setter(Builder::userMatchThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatchThreshold").build())
            .build();

    private static final SdkField<Integer> MAX_USERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxUsers").getter(getter(SearchUsersRequest::maxUsers)).setter(setter(Builder::maxUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUsers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            USER_ID_FIELD, FACE_ID_FIELD, USER_MATCH_THRESHOLD_FIELD, MAX_USERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CollectionId", COLLECTION_ID_FIELD);
                    put("UserId", USER_ID_FIELD);
                    put("FaceId", FACE_ID_FIELD);
                    put("UserMatchThreshold", USER_MATCH_THRESHOLD_FIELD);
                    put("MaxUsers", MAX_USERS_FIELD);
                }
            });

    private final String collectionId;

    private final String userId;

    private final String faceId;

    private final Float userMatchThreshold;

    private final Integer maxUsers;

    private SearchUsersRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.userId = builder.userId;
        this.faceId = builder.faceId;
        this.userMatchThreshold = builder.userMatchThreshold;
        this.maxUsers = builder.maxUsers;
    }

    /**
     * <p>
     * The ID of an existing collection containing the UserID, used with a UserId or FaceId. If a FaceId is provided,
     * UserId isn’t required to be present in the Collection.
     * </p>
     * 
     * @return The ID of an existing collection containing the UserID, used with a UserId or FaceId. If a FaceId is
     *         provided, UserId isn’t required to be present in the Collection.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * ID for the existing User.
     * </p>
     * 
     * @return ID for the existing User.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * ID for the existing face.
     * </p>
     * 
     * @return ID for the existing face.
     */
    public final String faceId() {
        return faceId;
    }

    /**
     * <p>
     * Optional value that specifies the minimum confidence in the matched UserID to return. Default value of 80.
     * </p>
     * 
     * @return Optional value that specifies the minimum confidence in the matched UserID to return. Default value of
     *         80.
     */
    public final Float userMatchThreshold() {
        return userMatchThreshold;
    }

    /**
     * <p>
     * Maximum number of identities to return.
     * </p>
     * 
     * @return Maximum number of identities to return.
     */
    public final Integer maxUsers() {
        return maxUsers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(faceId());
        hashCode = 31 * hashCode + Objects.hashCode(userMatchThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(maxUsers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersRequest)) {
            return false;
        }
        SearchUsersRequest other = (SearchUsersRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(faceId(), other.faceId()) && Objects.equals(userMatchThreshold(), other.userMatchThreshold())
                && Objects.equals(maxUsers(), other.maxUsers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchUsersRequest").add("CollectionId", collectionId()).add("UserId", userId())
                .add("FaceId", faceId()).add("UserMatchThreshold", userMatchThreshold()).add("MaxUsers", maxUsers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "FaceId":
            return Optional.ofNullable(clazz.cast(faceId()));
        case "UserMatchThreshold":
            return Optional.ofNullable(clazz.cast(userMatchThreshold()));
        case "MaxUsers":
            return Optional.ofNullable(clazz.cast(maxUsers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersRequest, T> g) {
        return obj -> g.apply((SearchUsersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchUsersRequest> {
        /**
         * <p>
         * The ID of an existing collection containing the UserID, used with a UserId or FaceId. If a FaceId is
         * provided, UserId isn’t required to be present in the Collection.
         * </p>
         * 
         * @param collectionId
         *        The ID of an existing collection containing the UserID, used with a UserId or FaceId. If a FaceId is
         *        provided, UserId isn’t required to be present in the Collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * ID for the existing User.
         * </p>
         * 
         * @param userId
         *        ID for the existing User.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * ID for the existing face.
         * </p>
         * 
         * @param faceId
         *        ID for the existing face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceId(String faceId);

        /**
         * <p>
         * Optional value that specifies the minimum confidence in the matched UserID to return. Default value of 80.
         * </p>
         * 
         * @param userMatchThreshold
         *        Optional value that specifies the minimum confidence in the matched UserID to return. Default value of
         *        80.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMatchThreshold(Float userMatchThreshold);

        /**
         * <p>
         * Maximum number of identities to return.
         * </p>
         * 
         * @param maxUsers
         *        Maximum number of identities to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUsers(Integer maxUsers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private String userId;

        private String faceId;

        private Float userMatchThreshold;

        private Integer maxUsers;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersRequest model) {
            super(model);
            collectionId(model.collectionId);
            userId(model.userId);
            faceId(model.faceId);
            userMatchThreshold(model.userMatchThreshold);
            maxUsers(model.maxUsers);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getFaceId() {
            return faceId;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final Float getUserMatchThreshold() {
            return userMatchThreshold;
        }

        public final void setUserMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
        }

        @Override
        public final Builder userMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
            return this;
        }

        public final Integer getMaxUsers() {
            return maxUsers;
        }

        public final void setMaxUsers(Integer maxUsers) {
            this.maxUsers = maxUsers;
        }

        @Override
        public final Builder maxUsers(Integer maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchUsersRequest build() {
            return new SearchUsersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
