/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchUsersResponse extends RekognitionResponse implements
        ToCopyableBuilder<SearchUsersResponse.Builder, SearchUsersResponse> {
    private static final SdkField<List<UserMatch>> USER_MATCHES_FIELD = SdkField
            .<List<UserMatch>> builder(MarshallingType.LIST)
            .memberName("UserMatches")
            .getter(getter(SearchUsersResponse::userMatches))
            .setter(setter(Builder::userMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaceModelVersion").getter(getter(SearchUsersResponse::faceModelVersion))
            .setter(setter(Builder::faceModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()).build();

    private static final SdkField<SearchedFace> SEARCHED_FACE_FIELD = SdkField.<SearchedFace> builder(MarshallingType.SDK_POJO)
            .memberName("SearchedFace").getter(getter(SearchUsersResponse::searchedFace)).setter(setter(Builder::searchedFace))
            .constructor(SearchedFace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFace").build()).build();

    private static final SdkField<SearchedUser> SEARCHED_USER_FIELD = SdkField.<SearchedUser> builder(MarshallingType.SDK_POJO)
            .memberName("SearchedUser").getter(getter(SearchUsersResponse::searchedUser)).setter(setter(Builder::searchedUser))
            .constructor(SearchedUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_MATCHES_FIELD,
            FACE_MODEL_VERSION_FIELD, SEARCHED_FACE_FIELD, SEARCHED_USER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UserMatches", USER_MATCHES_FIELD);
                    put("FaceModelVersion", FACE_MODEL_VERSION_FIELD);
                    put("SearchedFace", SEARCHED_FACE_FIELD);
                    put("SearchedUser", SEARCHED_USER_FIELD);
                }
            });

    private final List<UserMatch> userMatches;

    private final String faceModelVersion;

    private final SearchedFace searchedFace;

    private final SearchedUser searchedUser;

    private SearchUsersResponse(BuilderImpl builder) {
        super(builder);
        this.userMatches = builder.userMatches;
        this.faceModelVersion = builder.faceModelVersion;
        this.searchedFace = builder.searchedFace;
        this.searchedUser = builder.searchedUser;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserMatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserMatches() {
        return userMatches != null && !(userMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of UserMatch objects that matched the input face along with the confidence in the match. Array will be
     * empty if there are no matches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserMatches} method.
     * </p>
     * 
     * @return An array of UserMatch objects that matched the input face along with the confidence in the match. Array
     *         will be empty if there are no matches.
     */
    public final List<UserMatch> userMatches() {
        return userMatches;
    }

    /**
     * <p>
     * Version number of the face detection model associated with the input CollectionId.
     * </p>
     * 
     * @return Version number of the face detection model associated with the input CollectionId.
     */
    public final String faceModelVersion() {
        return faceModelVersion;
    }

    /**
     * <p>
     * Contains the ID of a face that was used to search for matches in a collection.
     * </p>
     * 
     * @return Contains the ID of a face that was used to search for matches in a collection.
     */
    public final SearchedFace searchedFace() {
        return searchedFace;
    }

    /**
     * <p>
     * Contains the ID of the UserID that was used to search for matches in a collection.
     * </p>
     * 
     * @return Contains the ID of the UserID that was used to search for matches in a collection.
     */
    public final SearchedUser searchedUser() {
        return searchedUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserMatches() ? userMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(searchedFace());
        hashCode = 31 * hashCode + Objects.hashCode(searchedUser());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersResponse)) {
            return false;
        }
        SearchUsersResponse other = (SearchUsersResponse) obj;
        return hasUserMatches() == other.hasUserMatches() && Objects.equals(userMatches(), other.userMatches())
                && Objects.equals(faceModelVersion(), other.faceModelVersion())
                && Objects.equals(searchedFace(), other.searchedFace()) && Objects.equals(searchedUser(), other.searchedUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchUsersResponse").add("UserMatches", hasUserMatches() ? userMatches() : null)
                .add("FaceModelVersion", faceModelVersion()).add("SearchedFace", searchedFace())
                .add("SearchedUser", searchedUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserMatches":
            return Optional.ofNullable(clazz.cast(userMatches()));
        case "FaceModelVersion":
            return Optional.ofNullable(clazz.cast(faceModelVersion()));
        case "SearchedFace":
            return Optional.ofNullable(clazz.cast(searchedFace()));
        case "SearchedUser":
            return Optional.ofNullable(clazz.cast(searchedUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersResponse, T> g) {
        return obj -> g.apply((SearchUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchUsersResponse> {
        /**
         * <p>
         * An array of UserMatch objects that matched the input face along with the confidence in the match. Array will
         * be empty if there are no matches.
         * </p>
         * 
         * @param userMatches
         *        An array of UserMatch objects that matched the input face along with the confidence in the match.
         *        Array will be empty if there are no matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMatches(Collection<UserMatch> userMatches);

        /**
         * <p>
         * An array of UserMatch objects that matched the input face along with the confidence in the match. Array will
         * be empty if there are no matches.
         * </p>
         * 
         * @param userMatches
         *        An array of UserMatch objects that matched the input face along with the confidence in the match.
         *        Array will be empty if there are no matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMatches(UserMatch... userMatches);

        /**
         * <p>
         * An array of UserMatch objects that matched the input face along with the confidence in the match. Array will
         * be empty if there are no matches.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.UserMatch.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.UserMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.UserMatch.Builder#build()} is called immediately and
         * its result is passed to {@link #userMatches(List<UserMatch>)}.
         * 
         * @param userMatches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.UserMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userMatches(java.util.Collection<UserMatch>)
         */
        Builder userMatches(Consumer<UserMatch.Builder>... userMatches);

        /**
         * <p>
         * Version number of the face detection model associated with the input CollectionId.
         * </p>
         * 
         * @param faceModelVersion
         *        Version number of the face detection model associated with the input CollectionId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersion(String faceModelVersion);

        /**
         * <p>
         * Contains the ID of a face that was used to search for matches in a collection.
         * </p>
         * 
         * @param searchedFace
         *        Contains the ID of a face that was used to search for matches in a collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFace(SearchedFace searchedFace);

        /**
         * <p>
         * Contains the ID of a face that was used to search for matches in a collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchedFace.Builder} avoiding the need
         * to create one manually via {@link SearchedFace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchedFace.Builder#build()} is called immediately and its
         * result is passed to {@link #searchedFace(SearchedFace)}.
         * 
         * @param searchedFace
         *        a consumer that will call methods on {@link SearchedFace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchedFace(SearchedFace)
         */
        default Builder searchedFace(Consumer<SearchedFace.Builder> searchedFace) {
            return searchedFace(SearchedFace.builder().applyMutation(searchedFace).build());
        }

        /**
         * <p>
         * Contains the ID of the UserID that was used to search for matches in a collection.
         * </p>
         * 
         * @param searchedUser
         *        Contains the ID of the UserID that was used to search for matches in a collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedUser(SearchedUser searchedUser);

        /**
         * <p>
         * Contains the ID of the UserID that was used to search for matches in a collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchedUser.Builder} avoiding the need
         * to create one manually via {@link SearchedUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchedUser.Builder#build()} is called immediately and its
         * result is passed to {@link #searchedUser(SearchedUser)}.
         * 
         * @param searchedUser
         *        a consumer that will call methods on {@link SearchedUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchedUser(SearchedUser)
         */
        default Builder searchedUser(Consumer<SearchedUser.Builder> searchedUser) {
            return searchedUser(SearchedUser.builder().applyMutation(searchedUser).build());
        }
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<UserMatch> userMatches = DefaultSdkAutoConstructList.getInstance();

        private String faceModelVersion;

        private SearchedFace searchedFace;

        private SearchedUser searchedUser;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersResponse model) {
            super(model);
            userMatches(model.userMatches);
            faceModelVersion(model.faceModelVersion);
            searchedFace(model.searchedFace);
            searchedUser(model.searchedUser);
        }

        public final List<UserMatch.Builder> getUserMatches() {
            List<UserMatch.Builder> result = UserMatchListCopier.copyToBuilder(this.userMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserMatches(Collection<UserMatch.BuilderImpl> userMatches) {
            this.userMatches = UserMatchListCopier.copyFromBuilder(userMatches);
        }

        @Override
        public final Builder userMatches(Collection<UserMatch> userMatches) {
            this.userMatches = UserMatchListCopier.copy(userMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMatches(UserMatch... userMatches) {
            userMatches(Arrays.asList(userMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMatches(Consumer<UserMatch.Builder>... userMatches) {
            userMatches(Stream.of(userMatches).map(c -> UserMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFaceModelVersion() {
            return faceModelVersion;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final SearchedFace.Builder getSearchedFace() {
            return searchedFace != null ? searchedFace.toBuilder() : null;
        }

        public final void setSearchedFace(SearchedFace.BuilderImpl searchedFace) {
            this.searchedFace = searchedFace != null ? searchedFace.build() : null;
        }

        @Override
        public final Builder searchedFace(SearchedFace searchedFace) {
            this.searchedFace = searchedFace;
            return this;
        }

        public final SearchedUser.Builder getSearchedUser() {
            return searchedUser != null ? searchedUser.toBuilder() : null;
        }

        public final void setSearchedUser(SearchedUser.BuilderImpl searchedUser) {
            this.searchedUser = searchedUser != null ? searchedUser.build() : null;
        }

        @Override
        public final Builder searchedUser(SearchedUser searchedUser) {
            this.searchedUser = searchedUser;
            return this;
        }

        @Override
        public SearchUsersResponse build() {
            return new SearchUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
