/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMediaAnalysisJobRequest extends RekognitionRequest implements
        ToCopyableBuilder<StartMediaAnalysisJobRequest.Builder, StartMediaAnalysisJobRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(StartMediaAnalysisJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(StartMediaAnalysisJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<MediaAnalysisOperationsConfig> OPERATIONS_CONFIG_FIELD = SdkField
            .<MediaAnalysisOperationsConfig> builder(MarshallingType.SDK_POJO).memberName("OperationsConfig")
            .getter(getter(StartMediaAnalysisJobRequest::operationsConfig)).setter(setter(Builder::operationsConfig))
            .constructor(MediaAnalysisOperationsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationsConfig").build()).build();

    private static final SdkField<MediaAnalysisInput> INPUT_FIELD = SdkField
            .<MediaAnalysisInput> builder(MarshallingType.SDK_POJO).memberName("Input")
            .getter(getter(StartMediaAnalysisJobRequest::input)).setter(setter(Builder::input))
            .constructor(MediaAnalysisInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<MediaAnalysisOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<MediaAnalysisOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(StartMediaAnalysisJobRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(MediaAnalysisOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(StartMediaAnalysisJobRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            JOB_NAME_FIELD, OPERATIONS_CONFIG_FIELD, INPUT_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
                    put("JobName", JOB_NAME_FIELD);
                    put("OperationsConfig", OPERATIONS_CONFIG_FIELD);
                    put("Input", INPUT_FIELD);
                    put("OutputConfig", OUTPUT_CONFIG_FIELD);
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                }
            });

    private final String clientRequestToken;

    private final String jobName;

    private final MediaAnalysisOperationsConfig operationsConfig;

    private final MediaAnalysisInput input;

    private final MediaAnalysisOutputConfig outputConfig;

    private final String kmsKeyId;

    private StartMediaAnalysisJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.jobName = builder.jobName;
        this.operationsConfig = builder.operationsConfig;
        this.input = builder.input;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * Idempotency token used to prevent the accidental creation of duplicate versions. If you use the same token with
     * multiple <code>StartMediaAnalysisJobRequest</code> requests, the same response is returned. Use
     * <code>ClientRequestToken</code> to prevent the same request from being processed more than once.
     * </p>
     * 
     * @return Idempotency token used to prevent the accidental creation of duplicate versions. If you use the same
     *         token with multiple <code>StartMediaAnalysisJobRequest</code> requests, the same response is returned.
     *         Use <code>ClientRequestToken</code> to prevent the same request from being processed more than once.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The name of the job. Does not have to be unique.
     * </p>
     * 
     * @return The name of the job. Does not have to be unique.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Configuration options for the media analysis job to be created.
     * </p>
     * 
     * @return Configuration options for the media analysis job to be created.
     */
    public final MediaAnalysisOperationsConfig operationsConfig() {
        return operationsConfig;
    }

    /**
     * <p>
     * Input data to be analyzed by the job.
     * </p>
     * 
     * @return Input data to be analyzed by the job.
     */
    public final MediaAnalysisInput input() {
        return input;
    }

    /**
     * <p>
     * The Amazon S3 bucket location to store the results.
     * </p>
     * 
     * @return The Amazon S3 bucket location to store the results.
     */
    public final MediaAnalysisOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The identifier of customer managed AWS KMS key (name or ARN). The key is used to encrypt images copied into the
     * service. The key is also used to encrypt results and manifest files written to the output Amazon S3 bucket.
     * </p>
     * 
     * @return The identifier of customer managed AWS KMS key (name or ARN). The key is used to encrypt images copied
     *         into the service. The key is also used to encrypt results and manifest files written to the output Amazon
     *         S3 bucket.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(operationsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMediaAnalysisJobRequest)) {
            return false;
        }
        StartMediaAnalysisJobRequest other = (StartMediaAnalysisJobRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(operationsConfig(), other.operationsConfig()) && Objects.equals(input(), other.input())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMediaAnalysisJobRequest").add("ClientRequestToken", clientRequestToken())
                .add("JobName", jobName()).add("OperationsConfig", operationsConfig()).add("Input", input())
                .add("OutputConfig", outputConfig()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "OperationsConfig":
            return Optional.ofNullable(clazz.cast(operationsConfig()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartMediaAnalysisJobRequest, T> g) {
        return obj -> g.apply((StartMediaAnalysisJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartMediaAnalysisJobRequest> {
        /**
         * <p>
         * Idempotency token used to prevent the accidental creation of duplicate versions. If you use the same token
         * with multiple <code>StartMediaAnalysisJobRequest</code> requests, the same response is returned. Use
         * <code>ClientRequestToken</code> to prevent the same request from being processed more than once.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotency token used to prevent the accidental creation of duplicate versions. If you use the same
         *        token with multiple <code>StartMediaAnalysisJobRequest</code> requests, the same response is returned.
         *        Use <code>ClientRequestToken</code> to prevent the same request from being processed more than once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The name of the job. Does not have to be unique.
         * </p>
         * 
         * @param jobName
         *        The name of the job. Does not have to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Configuration options for the media analysis job to be created.
         * </p>
         * 
         * @param operationsConfig
         *        Configuration options for the media analysis job to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationsConfig(MediaAnalysisOperationsConfig operationsConfig);

        /**
         * <p>
         * Configuration options for the media analysis job to be created.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisOperationsConfig.Builder}
         * avoiding the need to create one manually via {@link MediaAnalysisOperationsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisOperationsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #operationsConfig(MediaAnalysisOperationsConfig)}.
         * 
         * @param operationsConfig
         *        a consumer that will call methods on {@link MediaAnalysisOperationsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationsConfig(MediaAnalysisOperationsConfig)
         */
        default Builder operationsConfig(Consumer<MediaAnalysisOperationsConfig.Builder> operationsConfig) {
            return operationsConfig(MediaAnalysisOperationsConfig.builder().applyMutation(operationsConfig).build());
        }

        /**
         * <p>
         * Input data to be analyzed by the job.
         * </p>
         * 
         * @param input
         *        Input data to be analyzed by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(MediaAnalysisInput input);

        /**
         * <p>
         * Input data to be analyzed by the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisInput.Builder} avoiding the
         * need to create one manually via {@link MediaAnalysisInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisInput.Builder#build()} is called immediately and its
         * result is passed to {@link #input(MediaAnalysisInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link MediaAnalysisInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(MediaAnalysisInput)
         */
        default Builder input(Consumer<MediaAnalysisInput.Builder> input) {
            return input(MediaAnalysisInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * The Amazon S3 bucket location to store the results.
         * </p>
         * 
         * @param outputConfig
         *        The Amazon S3 bucket location to store the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(MediaAnalysisOutputConfig outputConfig);

        /**
         * <p>
         * The Amazon S3 bucket location to store the results.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaAnalysisOutputConfig.Builder}
         * avoiding the need to create one manually via {@link MediaAnalysisOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaAnalysisOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfig(MediaAnalysisOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link MediaAnalysisOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(MediaAnalysisOutputConfig)
         */
        default Builder outputConfig(Consumer<MediaAnalysisOutputConfig.Builder> outputConfig) {
            return outputConfig(MediaAnalysisOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The identifier of customer managed AWS KMS key (name or ARN). The key is used to encrypt images copied into
         * the service. The key is also used to encrypt results and manifest files written to the output Amazon S3
         * bucket.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of customer managed AWS KMS key (name or ARN). The key is used to encrypt images copied
         *        into the service. The key is also used to encrypt results and manifest files written to the output
         *        Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String jobName;

        private MediaAnalysisOperationsConfig operationsConfig;

        private MediaAnalysisInput input;

        private MediaAnalysisOutputConfig outputConfig;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMediaAnalysisJobRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            jobName(model.jobName);
            operationsConfig(model.operationsConfig);
            input(model.input);
            outputConfig(model.outputConfig);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final MediaAnalysisOperationsConfig.Builder getOperationsConfig() {
            return operationsConfig != null ? operationsConfig.toBuilder() : null;
        }

        public final void setOperationsConfig(MediaAnalysisOperationsConfig.BuilderImpl operationsConfig) {
            this.operationsConfig = operationsConfig != null ? operationsConfig.build() : null;
        }

        @Override
        public final Builder operationsConfig(MediaAnalysisOperationsConfig operationsConfig) {
            this.operationsConfig = operationsConfig;
            return this;
        }

        public final MediaAnalysisInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(MediaAnalysisInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(MediaAnalysisInput input) {
            this.input = input;
            return this;
        }

        public final MediaAnalysisOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(MediaAnalysisOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(MediaAnalysisOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMediaAnalysisJobRequest build() {
            return new StartMediaAnalysisJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
