/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input parameters used in a streaming video analyzed by a Amazon Rekognition stream processor. You can use
 * <code>FaceSearch</code> to recognize faces in a streaming video, or you can use <code>ConnectedHome</code> to detect
 * labels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessorSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamProcessorSettings.Builder, StreamProcessorSettings> {
    private static final SdkField<FaceSearchSettings> FACE_SEARCH_FIELD = SdkField
            .<FaceSearchSettings> builder(MarshallingType.SDK_POJO).memberName("FaceSearch")
            .getter(getter(StreamProcessorSettings::faceSearch)).setter(setter(Builder::faceSearch))
            .constructor(FaceSearchSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceSearch").build()).build();

    private static final SdkField<ConnectedHomeSettings> CONNECTED_HOME_FIELD = SdkField
            .<ConnectedHomeSettings> builder(MarshallingType.SDK_POJO).memberName("ConnectedHome")
            .getter(getter(StreamProcessorSettings::connectedHome)).setter(setter(Builder::connectedHome))
            .constructor(ConnectedHomeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedHome").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_SEARCH_FIELD,
            CONNECTED_HOME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FaceSearch", FACE_SEARCH_FIELD);
                    put("ConnectedHome", CONNECTED_HOME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final FaceSearchSettings faceSearch;

    private final ConnectedHomeSettings connectedHome;

    private StreamProcessorSettings(BuilderImpl builder) {
        this.faceSearch = builder.faceSearch;
        this.connectedHome = builder.connectedHome;
    }

    /**
     * <p>
     * Face search settings to use on a streaming video.
     * </p>
     * 
     * @return Face search settings to use on a streaming video.
     */
    public final FaceSearchSettings faceSearch() {
        return faceSearch;
    }

    /**
     * Returns the value of the ConnectedHome property for this object.
     * 
     * @return The value of the ConnectedHome property for this object.
     */
    public final ConnectedHomeSettings connectedHome() {
        return connectedHome;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceSearch());
        hashCode = 31 * hashCode + Objects.hashCode(connectedHome());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessorSettings)) {
            return false;
        }
        StreamProcessorSettings other = (StreamProcessorSettings) obj;
        return Objects.equals(faceSearch(), other.faceSearch()) && Objects.equals(connectedHome(), other.connectedHome());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamProcessorSettings").add("FaceSearch", faceSearch()).add("ConnectedHome", connectedHome())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceSearch":
            return Optional.ofNullable(clazz.cast(faceSearch()));
        case "ConnectedHome":
            return Optional.ofNullable(clazz.cast(connectedHome()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessorSettings, T> g) {
        return obj -> g.apply((StreamProcessorSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamProcessorSettings> {
        /**
         * <p>
         * Face search settings to use on a streaming video.
         * </p>
         * 
         * @param faceSearch
         *        Face search settings to use on a streaming video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceSearch(FaceSearchSettings faceSearch);

        /**
         * <p>
         * Face search settings to use on a streaming video.
         * </p>
         * This is a convenience method that creates an instance of the {@link FaceSearchSettings.Builder} avoiding the
         * need to create one manually via {@link FaceSearchSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FaceSearchSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #faceSearch(FaceSearchSettings)}.
         * 
         * @param faceSearch
         *        a consumer that will call methods on {@link FaceSearchSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceSearch(FaceSearchSettings)
         */
        default Builder faceSearch(Consumer<FaceSearchSettings.Builder> faceSearch) {
            return faceSearch(FaceSearchSettings.builder().applyMutation(faceSearch).build());
        }

        /**
         * Sets the value of the ConnectedHome property for this object.
         *
         * @param connectedHome
         *        The new value for the ConnectedHome property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedHome(ConnectedHomeSettings connectedHome);

        /**
         * Sets the value of the ConnectedHome property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConnectedHomeSettings.Builder} avoiding
         * the need to create one manually via {@link ConnectedHomeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectedHomeSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #connectedHome(ConnectedHomeSettings)}.
         * 
         * @param connectedHome
         *        a consumer that will call methods on {@link ConnectedHomeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectedHome(ConnectedHomeSettings)
         */
        default Builder connectedHome(Consumer<ConnectedHomeSettings.Builder> connectedHome) {
            return connectedHome(ConnectedHomeSettings.builder().applyMutation(connectedHome).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FaceSearchSettings faceSearch;

        private ConnectedHomeSettings connectedHome;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessorSettings model) {
            faceSearch(model.faceSearch);
            connectedHome(model.connectedHome);
        }

        public final FaceSearchSettings.Builder getFaceSearch() {
            return faceSearch != null ? faceSearch.toBuilder() : null;
        }

        public final void setFaceSearch(FaceSearchSettings.BuilderImpl faceSearch) {
            this.faceSearch = faceSearch != null ? faceSearch.build() : null;
        }

        @Override
        public final Builder faceSearch(FaceSearchSettings faceSearch) {
            this.faceSearch = faceSearch;
            return this;
        }

        public final ConnectedHomeSettings.Builder getConnectedHome() {
            return connectedHome != null ? connectedHome.toBuilder() : null;
        }

        public final void setConnectedHome(ConnectedHomeSettings.BuilderImpl connectedHome) {
            this.connectedHome = connectedHome != null ? connectedHome.build() : null;
        }

        @Override
        public final Builder connectedHome(ConnectedHomeSettings connectedHome) {
            this.connectedHome = connectedHome;
            return this;
        }

        @Override
        public StreamProcessorSettings build() {
            return new StreamProcessorSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
