/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Face details inferred from the image but not used for search. The response attribute contains reasons for why a face
 * wasn't used for Search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnsearchedFace implements SdkPojo, Serializable, ToCopyableBuilder<UnsearchedFace.Builder, UnsearchedFace> {
    private static final SdkField<FaceDetail> FACE_DETAILS_FIELD = SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
            .memberName("FaceDetails").getter(getter(UnsearchedFace::faceDetails)).setter(setter(Builder::faceDetails))
            .constructor(FaceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceDetails").build()).build();

    private static final SdkField<List<String>> REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Reasons")
            .getter(getter(UnsearchedFace::reasonsAsStrings))
            .setter(setter(Builder::reasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_DETAILS_FIELD,
            REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FaceDetails", FACE_DETAILS_FIELD);
                    put("Reasons", REASONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final FaceDetail faceDetails;

    private final List<String> reasons;

    private UnsearchedFace(BuilderImpl builder) {
        this.faceDetails = builder.faceDetails;
        this.reasons = builder.reasons;
    }

    /**
     * Returns the value of the FaceDetails property for this object.
     * 
     * @return The value of the FaceDetails property for this object.
     */
    public final FaceDetail faceDetails() {
        return faceDetails;
    }

    /**
     * <p>
     * Reasons why a face wasn't used for Search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return Reasons why a face wasn't used for Search.
     */
    public final List<UnsearchedFaceReason> reasons() {
        return UnsearchedFaceReasonsCopier.copyStringToEnum(reasons);
    }

    /**
     * For responses, this returns true if the service returned a value for the Reasons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReasons() {
        return reasons != null && !(reasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Reasons why a face wasn't used for Search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return Reasons why a face wasn't used for Search.
     */
    public final List<String> reasonsAsStrings() {
        return reasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasReasons() ? reasonsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsearchedFace)) {
            return false;
        }
        UnsearchedFace other = (UnsearchedFace) obj;
        return Objects.equals(faceDetails(), other.faceDetails()) && hasReasons() == other.hasReasons()
                && Objects.equals(reasonsAsStrings(), other.reasonsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnsearchedFace").add("FaceDetails", faceDetails())
                .add("Reasons", hasReasons() ? reasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceDetails":
            return Optional.ofNullable(clazz.cast(faceDetails()));
        case "Reasons":
            return Optional.ofNullable(clazz.cast(reasonsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UnsearchedFace, T> g) {
        return obj -> g.apply((UnsearchedFace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnsearchedFace> {
        /**
         * Sets the value of the FaceDetails property for this object.
         *
         * @param faceDetails
         *        The new value for the FaceDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceDetails(FaceDetail faceDetails);

        /**
         * Sets the value of the FaceDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FaceDetail.Builder} avoiding the need to
         * create one manually via {@link FaceDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #faceDetails(FaceDetail)}.
         * 
         * @param faceDetails
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceDetails(FaceDetail)
         */
        default Builder faceDetails(Consumer<FaceDetail.Builder> faceDetails) {
            return faceDetails(FaceDetail.builder().applyMutation(faceDetails).build());
        }

        /**
         * <p>
         * Reasons why a face wasn't used for Search.
         * </p>
         * 
         * @param reasons
         *        Reasons why a face wasn't used for Search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(Collection<String> reasons);

        /**
         * <p>
         * Reasons why a face wasn't used for Search.
         * </p>
         * 
         * @param reasons
         *        Reasons why a face wasn't used for Search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(String... reasons);

        /**
         * <p>
         * Reasons why a face wasn't used for Search.
         * </p>
         * 
         * @param reasons
         *        Reasons why a face wasn't used for Search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Collection<UnsearchedFaceReason> reasons);

        /**
         * <p>
         * Reasons why a face wasn't used for Search.
         * </p>
         * 
         * @param reasons
         *        Reasons why a face wasn't used for Search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(UnsearchedFaceReason... reasons);
    }

    static final class BuilderImpl implements Builder {
        private FaceDetail faceDetails;

        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnsearchedFace model) {
            faceDetails(model.faceDetails);
            reasonsWithStrings(model.reasons);
        }

        public final FaceDetail.Builder getFaceDetails() {
            return faceDetails != null ? faceDetails.toBuilder() : null;
        }

        public final void setFaceDetails(FaceDetail.BuilderImpl faceDetails) {
            this.faceDetails = faceDetails != null ? faceDetails.build() : null;
        }

        @Override
        public final Builder faceDetails(FaceDetail faceDetails) {
            this.faceDetails = faceDetails;
            return this;
        }

        public final Collection<String> getReasons() {
            if (reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = UnsearchedFaceReasonsCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = UnsearchedFaceReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String... reasons) {
            reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<UnsearchedFaceReason> reasons) {
            this.reasons = UnsearchedFaceReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(UnsearchedFaceReason... reasons) {
            reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        public UnsearchedFace build() {
            return new UnsearchedFace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
