/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStreamProcessorRequest extends RekognitionRequest implements
        ToCopyableBuilder<UpdateStreamProcessorRequest.Builder, UpdateStreamProcessorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateStreamProcessorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<StreamProcessorSettingsForUpdate> SETTINGS_FOR_UPDATE_FIELD = SdkField
            .<StreamProcessorSettingsForUpdate> builder(MarshallingType.SDK_POJO).memberName("SettingsForUpdate")
            .getter(getter(UpdateStreamProcessorRequest::settingsForUpdate)).setter(setter(Builder::settingsForUpdate))
            .constructor(StreamProcessorSettingsForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingsForUpdate").build()).build();

    private static final SdkField<List<RegionOfInterest>> REGIONS_OF_INTEREST_FOR_UPDATE_FIELD = SdkField
            .<List<RegionOfInterest>> builder(MarshallingType.LIST)
            .memberName("RegionsOfInterestForUpdate")
            .getter(getter(UpdateStreamProcessorRequest::regionsOfInterestForUpdate))
            .setter(setter(Builder::regionsOfInterestForUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsOfInterestForUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegionOfInterest> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionOfInterest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StreamProcessorDataSharingPreference> DATA_SHARING_PREFERENCE_FOR_UPDATE_FIELD = SdkField
            .<StreamProcessorDataSharingPreference> builder(MarshallingType.SDK_POJO)
            .memberName("DataSharingPreferenceForUpdate")
            .getter(getter(UpdateStreamProcessorRequest::dataSharingPreferenceForUpdate))
            .setter(setter(Builder::dataSharingPreferenceForUpdate))
            .constructor(StreamProcessorDataSharingPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSharingPreferenceForUpdate")
                    .build()).build();

    private static final SdkField<List<String>> PARAMETERS_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ParametersToDelete")
            .getter(getter(UpdateStreamProcessorRequest::parametersToDeleteAsStrings))
            .setter(setter(Builder::parametersToDeleteWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SETTINGS_FOR_UPDATE_FIELD, REGIONS_OF_INTEREST_FOR_UPDATE_FIELD, DATA_SHARING_PREFERENCE_FOR_UPDATE_FIELD,
            PARAMETERS_TO_DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("SettingsForUpdate", SETTINGS_FOR_UPDATE_FIELD);
                    put("RegionsOfInterestForUpdate", REGIONS_OF_INTEREST_FOR_UPDATE_FIELD);
                    put("DataSharingPreferenceForUpdate", DATA_SHARING_PREFERENCE_FOR_UPDATE_FIELD);
                    put("ParametersToDelete", PARAMETERS_TO_DELETE_FIELD);
                }
            });

    private final String name;

    private final StreamProcessorSettingsForUpdate settingsForUpdate;

    private final List<RegionOfInterest> regionsOfInterestForUpdate;

    private final StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate;

    private final List<String> parametersToDelete;

    private UpdateStreamProcessorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.settingsForUpdate = builder.settingsForUpdate;
        this.regionsOfInterestForUpdate = builder.regionsOfInterestForUpdate;
        this.dataSharingPreferenceForUpdate = builder.dataSharingPreferenceForUpdate;
        this.parametersToDelete = builder.parametersToDelete;
    }

    /**
     * <p>
     * Name of the stream processor that you want to update.
     * </p>
     * 
     * @return Name of the stream processor that you want to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The stream processor settings that you want to update. Label detection settings can be updated to detect
     * different labels with a different minimum confidence.
     * </p>
     * 
     * @return The stream processor settings that you want to update. Label detection settings can be updated to detect
     *         different labels with a different minimum confidence.
     */
    public final StreamProcessorSettingsForUpdate settingsForUpdate() {
        return settingsForUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionsOfInterestForUpdate property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegionsOfInterestForUpdate() {
        return regionsOfInterestForUpdate != null && !(regionsOfInterestForUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional
     * parameter for label detection stream processors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionsOfInterestForUpdate} method.
     * </p>
     * 
     * @return Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an
     *         optional parameter for label detection stream processors.
     */
    public final List<RegionOfInterest> regionsOfInterestForUpdate() {
        return regionsOfInterestForUpdate;
    }

    /**
     * <p>
     * Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at
     * the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored
     * on individual streams.
     * </p>
     * 
     * @return Shows whether you are sharing data with Rekognition to improve model performance. You can choose this
     *         option at the account level or on a per-stream basis. Note that if you opt out at the account level this
     *         setting is ignored on individual streams.
     */
    public final StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate() {
        return dataSharingPreferenceForUpdate;
    }

    /**
     * <p>
     * A list of parameters you want to delete from the stream processor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParametersToDelete} method.
     * </p>
     * 
     * @return A list of parameters you want to delete from the stream processor.
     */
    public final List<StreamProcessorParameterToDelete> parametersToDelete() {
        return StreamProcessorParametersToDeleteCopier.copyStringToEnum(parametersToDelete);
    }

    /**
     * For responses, this returns true if the service returned a value for the ParametersToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParametersToDelete() {
        return parametersToDelete != null && !(parametersToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameters you want to delete from the stream processor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParametersToDelete} method.
     * </p>
     * 
     * @return A list of parameters you want to delete from the stream processor.
     */
    public final List<String> parametersToDeleteAsStrings() {
        return parametersToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(settingsForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionsOfInterestForUpdate() ? regionsOfInterestForUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSharingPreferenceForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasParametersToDelete() ? parametersToDeleteAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamProcessorRequest)) {
            return false;
        }
        UpdateStreamProcessorRequest other = (UpdateStreamProcessorRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(settingsForUpdate(), other.settingsForUpdate())
                && hasRegionsOfInterestForUpdate() == other.hasRegionsOfInterestForUpdate()
                && Objects.equals(regionsOfInterestForUpdate(), other.regionsOfInterestForUpdate())
                && Objects.equals(dataSharingPreferenceForUpdate(), other.dataSharingPreferenceForUpdate())
                && hasParametersToDelete() == other.hasParametersToDelete()
                && Objects.equals(parametersToDeleteAsStrings(), other.parametersToDeleteAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStreamProcessorRequest").add("Name", name()).add("SettingsForUpdate", settingsForUpdate())
                .add("RegionsOfInterestForUpdate", hasRegionsOfInterestForUpdate() ? regionsOfInterestForUpdate() : null)
                .add("DataSharingPreferenceForUpdate", dataSharingPreferenceForUpdate())
                .add("ParametersToDelete", hasParametersToDelete() ? parametersToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SettingsForUpdate":
            return Optional.ofNullable(clazz.cast(settingsForUpdate()));
        case "RegionsOfInterestForUpdate":
            return Optional.ofNullable(clazz.cast(regionsOfInterestForUpdate()));
        case "DataSharingPreferenceForUpdate":
            return Optional.ofNullable(clazz.cast(dataSharingPreferenceForUpdate()));
        case "ParametersToDelete":
            return Optional.ofNullable(clazz.cast(parametersToDeleteAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamProcessorRequest, T> g) {
        return obj -> g.apply((UpdateStreamProcessorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStreamProcessorRequest> {
        /**
         * <p>
         * Name of the stream processor that you want to update.
         * </p>
         * 
         * @param name
         *        Name of the stream processor that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The stream processor settings that you want to update. Label detection settings can be updated to detect
         * different labels with a different minimum confidence.
         * </p>
         * 
         * @param settingsForUpdate
         *        The stream processor settings that you want to update. Label detection settings can be updated to
         *        detect different labels with a different minimum confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingsForUpdate(StreamProcessorSettingsForUpdate settingsForUpdate);

        /**
         * <p>
         * The stream processor settings that you want to update. Label detection settings can be updated to detect
         * different labels with a different minimum confidence.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamProcessorSettingsForUpdate.Builder}
         * avoiding the need to create one manually via {@link StreamProcessorSettingsForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamProcessorSettingsForUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #settingsForUpdate(StreamProcessorSettingsForUpdate)}.
         * 
         * @param settingsForUpdate
         *        a consumer that will call methods on {@link StreamProcessorSettingsForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settingsForUpdate(StreamProcessorSettingsForUpdate)
         */
        default Builder settingsForUpdate(Consumer<StreamProcessorSettingsForUpdate.Builder> settingsForUpdate) {
            return settingsForUpdate(StreamProcessorSettingsForUpdate.builder().applyMutation(settingsForUpdate).build());
        }

        /**
         * <p>
         * Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional
         * parameter for label detection stream processors.
         * </p>
         * 
         * @param regionsOfInterestForUpdate
         *        Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an
         *        optional parameter for label detection stream processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsOfInterestForUpdate(Collection<RegionOfInterest> regionsOfInterestForUpdate);

        /**
         * <p>
         * Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional
         * parameter for label detection stream processors.
         * </p>
         * 
         * @param regionsOfInterestForUpdate
         *        Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an
         *        optional parameter for label detection stream processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsOfInterestForUpdate(RegionOfInterest... regionsOfInterestForUpdate);

        /**
         * <p>
         * Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional
         * parameter for label detection stream processors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.RegionOfInterest.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rekognition.model.RegionOfInterest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.RegionOfInterest.Builder#build()} is called
         * immediately and its result is passed to {@link #regionsOfInterestForUpdate(List<RegionOfInterest>)}.
         * 
         * @param regionsOfInterestForUpdate
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.RegionOfInterest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionsOfInterestForUpdate(java.util.Collection<RegionOfInterest>)
         */
        Builder regionsOfInterestForUpdate(Consumer<RegionOfInterest.Builder>... regionsOfInterestForUpdate);

        /**
         * <p>
         * Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option
         * at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is
         * ignored on individual streams.
         * </p>
         * 
         * @param dataSharingPreferenceForUpdate
         *        Shows whether you are sharing data with Rekognition to improve model performance. You can choose this
         *        option at the account level or on a per-stream basis. Note that if you opt out at the account level
         *        this setting is ignored on individual streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSharingPreferenceForUpdate(StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate);

        /**
         * <p>
         * Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option
         * at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is
         * ignored on individual streams.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StreamProcessorDataSharingPreference.Builder} avoiding the need to create one manually via
         * {@link StreamProcessorDataSharingPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamProcessorDataSharingPreference.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dataSharingPreferenceForUpdate(StreamProcessorDataSharingPreference)}.
         * 
         * @param dataSharingPreferenceForUpdate
         *        a consumer that will call methods on {@link StreamProcessorDataSharingPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSharingPreferenceForUpdate(StreamProcessorDataSharingPreference)
         */
        default Builder dataSharingPreferenceForUpdate(
                Consumer<StreamProcessorDataSharingPreference.Builder> dataSharingPreferenceForUpdate) {
            return dataSharingPreferenceForUpdate(StreamProcessorDataSharingPreference.builder()
                    .applyMutation(dataSharingPreferenceForUpdate).build());
        }

        /**
         * <p>
         * A list of parameters you want to delete from the stream processor.
         * </p>
         * 
         * @param parametersToDelete
         *        A list of parameters you want to delete from the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersToDeleteWithStrings(Collection<String> parametersToDelete);

        /**
         * <p>
         * A list of parameters you want to delete from the stream processor.
         * </p>
         * 
         * @param parametersToDelete
         *        A list of parameters you want to delete from the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersToDeleteWithStrings(String... parametersToDelete);

        /**
         * <p>
         * A list of parameters you want to delete from the stream processor.
         * </p>
         * 
         * @param parametersToDelete
         *        A list of parameters you want to delete from the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersToDelete(Collection<StreamProcessorParameterToDelete> parametersToDelete);

        /**
         * <p>
         * A list of parameters you want to delete from the stream processor.
         * </p>
         * 
         * @param parametersToDelete
         *        A list of parameters you want to delete from the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersToDelete(StreamProcessorParameterToDelete... parametersToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String name;

        private StreamProcessorSettingsForUpdate settingsForUpdate;

        private List<RegionOfInterest> regionsOfInterestForUpdate = DefaultSdkAutoConstructList.getInstance();

        private StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate;

        private List<String> parametersToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamProcessorRequest model) {
            super(model);
            name(model.name);
            settingsForUpdate(model.settingsForUpdate);
            regionsOfInterestForUpdate(model.regionsOfInterestForUpdate);
            dataSharingPreferenceForUpdate(model.dataSharingPreferenceForUpdate);
            parametersToDeleteWithStrings(model.parametersToDelete);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamProcessorSettingsForUpdate.Builder getSettingsForUpdate() {
            return settingsForUpdate != null ? settingsForUpdate.toBuilder() : null;
        }

        public final void setSettingsForUpdate(StreamProcessorSettingsForUpdate.BuilderImpl settingsForUpdate) {
            this.settingsForUpdate = settingsForUpdate != null ? settingsForUpdate.build() : null;
        }

        @Override
        @Transient
        public final Builder settingsForUpdate(StreamProcessorSettingsForUpdate settingsForUpdate) {
            this.settingsForUpdate = settingsForUpdate;
            return this;
        }

        public final List<RegionOfInterest.Builder> getRegionsOfInterestForUpdate() {
            List<RegionOfInterest.Builder> result = RegionsOfInterestCopier.copyToBuilder(this.regionsOfInterestForUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionsOfInterestForUpdate(Collection<RegionOfInterest.BuilderImpl> regionsOfInterestForUpdate) {
            this.regionsOfInterestForUpdate = RegionsOfInterestCopier.copyFromBuilder(regionsOfInterestForUpdate);
        }

        @Override
        public final Builder regionsOfInterestForUpdate(Collection<RegionOfInterest> regionsOfInterestForUpdate) {
            this.regionsOfInterestForUpdate = RegionsOfInterestCopier.copy(regionsOfInterestForUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterestForUpdate(RegionOfInterest... regionsOfInterestForUpdate) {
            regionsOfInterestForUpdate(Arrays.asList(regionsOfInterestForUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterestForUpdate(Consumer<RegionOfInterest.Builder>... regionsOfInterestForUpdate) {
            regionsOfInterestForUpdate(Stream.of(regionsOfInterestForUpdate)
                    .map(c -> RegionOfInterest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final StreamProcessorDataSharingPreference.Builder getDataSharingPreferenceForUpdate() {
            return dataSharingPreferenceForUpdate != null ? dataSharingPreferenceForUpdate.toBuilder() : null;
        }

        public final void setDataSharingPreferenceForUpdate(
                StreamProcessorDataSharingPreference.BuilderImpl dataSharingPreferenceForUpdate) {
            this.dataSharingPreferenceForUpdate = dataSharingPreferenceForUpdate != null ? dataSharingPreferenceForUpdate.build()
                    : null;
        }

        @Override
        public final Builder dataSharingPreferenceForUpdate(StreamProcessorDataSharingPreference dataSharingPreferenceForUpdate) {
            this.dataSharingPreferenceForUpdate = dataSharingPreferenceForUpdate;
            return this;
        }

        public final Collection<String> getParametersToDelete() {
            if (parametersToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return parametersToDelete;
        }

        public final void setParametersToDelete(Collection<String> parametersToDelete) {
            this.parametersToDelete = StreamProcessorParametersToDeleteCopier.copy(parametersToDelete);
        }

        @Override
        public final Builder parametersToDeleteWithStrings(Collection<String> parametersToDelete) {
            this.parametersToDelete = StreamProcessorParametersToDeleteCopier.copy(parametersToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parametersToDeleteWithStrings(String... parametersToDelete) {
            parametersToDeleteWithStrings(Arrays.asList(parametersToDelete));
            return this;
        }

        @Override
        public final Builder parametersToDelete(Collection<StreamProcessorParameterToDelete> parametersToDelete) {
            this.parametersToDelete = StreamProcessorParametersToDeleteCopier.copyEnumToString(parametersToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parametersToDelete(StreamProcessorParameterToDelete... parametersToDelete) {
            parametersToDelete(Arrays.asList(parametersToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamProcessorRequest build() {
            return new UpdateStreamProcessorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
