/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFaceSearchRequest extends RekognitionRequest implements
        ToCopyableBuilder<GetFaceSearchRequest.Builder, GetFaceSearchRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFaceSearchRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetFaceSearchRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFaceSearchRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFaceSearchRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD));

    private final String jobId;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortBy;

    private GetFaceSearchRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * The job identifer for the search request. You get the job identifier from an initial call to
     * <code>StartFaceSearch</code>.
     * </p>
     * 
     * @return The job identifer for the search request. You get the job identifier from an initial call to
     *         <code>StartFaceSearch</code>.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify
     * a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.
     * </p>
     * 
     * @return Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you
     *         specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more search results to retrieve), Amazon Rekognition
     * Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     * search results.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more search results to retrieve), Amazon
     *         Rekognition Video returns a pagination token in the response. You can use this pagination token to
     *         retrieve the next set of search results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time that they
     * are recognized. Use <code>INDEX</code> to sort by recognized faces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link FaceSearchSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time
     *         that they are recognized. Use <code>INDEX</code> to sort by recognized faces.
     * @see FaceSearchSortBy
     */
    public FaceSearchSortBy sortBy() {
        return FaceSearchSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time that they
     * are recognized. Use <code>INDEX</code> to sort by recognized faces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link FaceSearchSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time
     *         that they are recognized. Use <code>INDEX</code> to sort by recognized faces.
     * @see FaceSearchSortBy
     */
    public String sortByAsString() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceSearchRequest)) {
            return false;
        }
        GetFaceSearchRequest other = (GetFaceSearchRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortByAsString(), other.sortByAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetFaceSearchRequest").add("JobId", jobId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SortBy", sortByAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFaceSearchRequest, T> g) {
        return obj -> g.apply((GetFaceSearchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFaceSearchRequest> {
        /**
         * <p>
         * The job identifer for the search request. You get the job identifier from an initial call to
         * <code>StartFaceSearch</code>.
         * </p>
         * 
         * @param jobId
         *        The job identifer for the search request. You get the job identifier from an initial call to
         *        <code>StartFaceSearch</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you
         * specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return per paginated call. The largest value you can specify is 1000. If
         *        you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is
         *        1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous response was incomplete (because there is more search results to retrieve), Amazon
         * Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve
         * the next set of search results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more search results to retrieve), Amazon
         *        Rekognition Video returns a pagination token in the response. You can use this pagination token to
         *        retrieve the next set of search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time that
         * they are recognized. Use <code>INDEX</code> to sort by recognized faces.
         * </p>
         * 
         * @param sortBy
         *        Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time
         *        that they are recognized. Use <code>INDEX</code> to sort by recognized faces.
         * @see FaceSearchSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaceSearchSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time that
         * they are recognized. Use <code>INDEX</code> to sort by recognized faces.
         * </p>
         * 
         * @param sortBy
         *        Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time
         *        that they are recognized. Use <code>INDEX</code> to sort by recognized faces.
         * @see FaceSearchSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaceSearchSortBy
         */
        Builder sortBy(FaceSearchSortBy sortBy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String jobId;

        private Integer maxResults;

        private String nextToken;

        private String sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFaceSearchRequest model) {
            super(model);
            jobId(model.jobId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSortByAsString() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(FaceSearchSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFaceSearchRequest build() {
            return new GetFaceSearchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
