/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a person detected in a video analysis request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PersonDetail implements SdkPojo, Serializable, ToCopyableBuilder<PersonDetail.Builder, PersonDetail> {
    private static final SdkField<Long> INDEX_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(PersonDetail::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .getter(getter(PersonDetail::boundingBox)).setter(setter(Builder::boundingBox)).constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<FaceDetail> FACE_FIELD = SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(PersonDetail::face)).setter(setter(Builder::face)).constructor(FaceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD,
            BOUNDING_BOX_FIELD, FACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long index;

    private final BoundingBox boundingBox;

    private final FaceDetail face;

    private PersonDetail(BuilderImpl builder) {
        this.index = builder.index;
        this.boundingBox = builder.boundingBox;
        this.face = builder.face;
    }

    /**
     * <p>
     * Identifier for the person detected person within a video. Use to keep track of the person throughout the video.
     * The identifier is not stored by Amazon Rekognition.
     * </p>
     * 
     * @return Identifier for the person detected person within a video. Use to keep track of the person throughout the
     *         video. The identifier is not stored by Amazon Rekognition.
     */
    public Long index() {
        return index;
    }

    /**
     * <p>
     * Bounding box around the detected person.
     * </p>
     * 
     * @return Bounding box around the detected person.
     */
    public BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Face details for the detected person.
     * </p>
     * 
     * @return Face details for the detected person.
     */
    public FaceDetail face() {
        return face;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(face());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonDetail)) {
            return false;
        }
        PersonDetail other = (PersonDetail) obj;
        return Objects.equals(index(), other.index()) && Objects.equals(boundingBox(), other.boundingBox())
                && Objects.equals(face(), other.face());
    }

    @Override
    public String toString() {
        return ToString.builder("PersonDetail").add("Index", index()).add("BoundingBox", boundingBox()).add("Face", face())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PersonDetail, T> g) {
        return obj -> g.apply((PersonDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PersonDetail> {
        /**
         * <p>
         * Identifier for the person detected person within a video. Use to keep track of the person throughout the
         * video. The identifier is not stored by Amazon Rekognition.
         * </p>
         * 
         * @param index
         *        Identifier for the person detected person within a video. Use to keep track of the person throughout
         *        the video. The identifier is not stored by Amazon Rekognition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Long index);

        /**
         * <p>
         * Bounding box around the detected person.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box around the detected person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Bounding box around the detected person.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * Face details for the detected person.
         * </p>
         * 
         * @param face
         *        Face details for the detected person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(FaceDetail face);

        /**
         * <p>
         * Face details for the detected person.
         * </p>
         * This is a convenience that creates an instance of the {@link FaceDetail.Builder} avoiding the need to create
         * one manually via {@link FaceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #face(FaceDetail)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(FaceDetail)
         */
        default Builder face(Consumer<FaceDetail.Builder> face) {
            return face(FaceDetail.builder().applyMutation(face).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long index;

        private BoundingBox boundingBox;

        private FaceDetail face;

        private BuilderImpl() {
        }

        private BuilderImpl(PersonDetail model) {
            index(model.index);
            boundingBox(model.boundingBox);
            face(model.face);
        }

        public final Long getIndex() {
            return index;
        }

        @Override
        public final Builder index(Long index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Long index) {
            this.index = index;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final FaceDetail.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public PersonDetail build() {
            return new PersonDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
