/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<SearchFacesRequest.Builder, SearchFacesRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchFacesRequest::collectionId)).setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()).build();

    private static final SdkField<String> FACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchFacesRequest::faceId)).setter(setter(Builder::faceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()).build();

    private static final SdkField<Integer> MAX_FACES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SearchFacesRequest::maxFaces)).setter(setter(Builder::maxFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFaces").build()).build();

    private static final SdkField<Float> FACE_MATCH_THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(SearchFacesRequest::faceMatchThreshold)).setter(setter(Builder::faceMatchThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatchThreshold").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            FACE_ID_FIELD, MAX_FACES_FIELD, FACE_MATCH_THRESHOLD_FIELD));

    private final String collectionId;

    private final String faceId;

    private final Integer maxFaces;

    private final Float faceMatchThreshold;

    private SearchFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.faceId = builder.faceId;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    /**
     * <p>
     * ID of the collection the face belongs to.
     * </p>
     * 
     * @return ID of the collection the face belongs to.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * ID of a face to find matches for in the collection.
     * </p>
     * 
     * @return ID of a face to find matches for in the collection.
     */
    public String faceId() {
        return faceId;
    }

    /**
     * <p>
     * Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence
     * in the match.
     * </p>
     * 
     * @return Maximum number of faces to return. The operation returns the maximum number of faces with the highest
     *         confidence in the match.
     */
    public Integer maxFaces() {
        return maxFaces;
    }

    /**
     * <p>
     * Optional value specifying the minimum confidence in the face match to return. For example, don't return any
     * matches where confidence in matches is less than 70%.
     * </p>
     * 
     * @return Optional value specifying the minimum confidence in the face match to return. For example, don't return
     *         any matches where confidence in matches is less than 70%.
     */
    public Float faceMatchThreshold() {
        return faceMatchThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(faceId());
        hashCode = 31 * hashCode + Objects.hashCode(maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(faceMatchThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesRequest)) {
            return false;
        }
        SearchFacesRequest other = (SearchFacesRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(faceId(), other.faceId())
                && Objects.equals(maxFaces(), other.maxFaces())
                && Objects.equals(faceMatchThreshold(), other.faceMatchThreshold());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchFacesRequest").add("CollectionId", collectionId()).add("FaceId", faceId())
                .add("MaxFaces", maxFaces()).add("FaceMatchThreshold", faceMatchThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "FaceId":
            return Optional.ofNullable(clazz.cast(faceId()));
        case "MaxFaces":
            return Optional.ofNullable(clazz.cast(maxFaces()));
        case "FaceMatchThreshold":
            return Optional.ofNullable(clazz.cast(faceMatchThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFacesRequest, T> g) {
        return obj -> g.apply((SearchFacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchFacesRequest> {
        /**
         * <p>
         * ID of the collection the face belongs to.
         * </p>
         * 
         * @param collectionId
         *        ID of the collection the face belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * ID of a face to find matches for in the collection.
         * </p>
         * 
         * @param faceId
         *        ID of a face to find matches for in the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceId(String faceId);

        /**
         * <p>
         * Maximum number of faces to return. The operation returns the maximum number of faces with the highest
         * confidence in the match.
         * </p>
         * 
         * @param maxFaces
         *        Maximum number of faces to return. The operation returns the maximum number of faces with the highest
         *        confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFaces(Integer maxFaces);

        /**
         * <p>
         * Optional value specifying the minimum confidence in the face match to return. For example, don't return any
         * matches where confidence in matches is less than 70%.
         * </p>
         * 
         * @param faceMatchThreshold
         *        Optional value specifying the minimum confidence in the face match to return. For example, don't
         *        return any matches where confidence in matches is less than 70%.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatchThreshold(Float faceMatchThreshold);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private String faceId;

        private Integer maxFaces;

        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesRequest model) {
            super(model);
            collectionId(model.collectionId);
            faceId(model.faceId);
            maxFaces(model.maxFaces);
            faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final String getFaceId() {
            return faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        public final Integer getMaxFaces() {
            return maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        public final Float getFaceMatchThreshold() {
            return faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchFacesRequest build() {
            return new SearchFacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
