/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamProcessorResponse extends RekognitionResponse implements
        ToCopyableBuilder<CreateStreamProcessorResponse.Builder, CreateStreamProcessorResponse> {
    private static final SdkField<String> STREAM_PROCESSOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStreamProcessorResponse::streamProcessorArn)).setter(setter(Builder::streamProcessorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamProcessorArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_PROCESSOR_ARN_FIELD));

    private final String streamProcessorArn;

    private CreateStreamProcessorResponse(BuilderImpl builder) {
        super(builder);
        this.streamProcessorArn = builder.streamProcessorArn;
    }

    /**
     * <p>
     * ARN for the newly create stream processor.
     * </p>
     * 
     * @return ARN for the newly create stream processor.
     */
    public String streamProcessorArn() {
        return streamProcessorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamProcessorArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamProcessorResponse)) {
            return false;
        }
        CreateStreamProcessorResponse other = (CreateStreamProcessorResponse) obj;
        return Objects.equals(streamProcessorArn(), other.streamProcessorArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamProcessorResponse").add("StreamProcessorArn", streamProcessorArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamProcessorArn":
            return Optional.ofNullable(clazz.cast(streamProcessorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamProcessorResponse, T> g) {
        return obj -> g.apply((CreateStreamProcessorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStreamProcessorResponse> {
        /**
         * <p>
         * ARN for the newly create stream processor.
         * </p>
         * 
         * @param streamProcessorArn
         *        ARN for the newly create stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamProcessorArn(String streamProcessorArn);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String streamProcessorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamProcessorResponse model) {
            super(model);
            streamProcessorArn(model.streamProcessorArn);
        }

        public final String getStreamProcessorArn() {
            return streamProcessorArn;
        }

        @Override
        public final Builder streamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
            return this;
        }

        public final void setStreamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
        }

        @Override
        public CreateStreamProcessorResponse build() {
            return new CreateStreamProcessorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
