/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFaceSearchResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetFaceSearchResponse.Builder, GetFaceSearchResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFaceSearchResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFaceSearchResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetFaceSearchResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField
            .<VideoMetadata> builder(MarshallingType.SDK_POJO).getter(getter(GetFaceSearchResponse::videoMetadata))
            .setter(setter(Builder::videoMetadata)).constructor(VideoMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()).build();

    private static final SdkField<List<PersonMatch>> PERSONS_FIELD = SdkField
            .<List<PersonMatch>> builder(MarshallingType.LIST)
            .getter(getter(GetFaceSearchResponse::persons))
            .setter(setter(Builder::persons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PersonMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(PersonMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            STATUS_MESSAGE_FIELD, NEXT_TOKEN_FIELD, VIDEO_METADATA_FIELD, PERSONS_FIELD));

    private final String jobStatus;

    private final String statusMessage;

    private final String nextToken;

    private final VideoMetadata videoMetadata;

    private final List<PersonMatch> persons;

    private GetFaceSearchResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.nextToken = builder.nextToken;
        this.videoMetadata = builder.videoMetadata;
        this.persons = builder.persons;
    }

    /**
     * <p>
     * The current status of the face search job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the face search job.
     * @see VideoJobStatus
     */
    public VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the face search job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the face search job.
     * @see VideoJobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     * </p>
     * 
     * @return If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
     * request to retrieve the next set of search results.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
     *         subsequent request to retrieve the next set of search results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page
     * of paginated responses from a Amazon Rekognition Video operation.
     * </p>
     * 
     * @return Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in
     *         every page of paginated responses from a Amazon Rekognition Video operation.
     */
    public VideoMetadata videoMetadata() {
        return videoMetadata;
    }

    /**
     * <p>
     * An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon Rekognition
     * collection. It also includes time information for when persons are matched in the video. You specify the input
     * collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code> element includes a time
     * the person was matched, face match details (<code>FaceMatches</code>) for matching faces in the collection, and
     * person information (<code>Person</code>) for the matched person.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
     *         Rekognition collection. It also includes time information for when persons are matched in the video. You
     *         specify the input collection in an initial call to <code>StartFaceSearch</code>. Each
     *         <code>Persons</code> element includes a time the person was matched, face match details (
     *         <code>FaceMatches</code>) for matching faces in the collection, and person information (
     *         <code>Person</code>) for the matched person.
     */
    public List<PersonMatch> persons() {
        return persons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(persons());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceSearchResponse)) {
            return false;
        }
        GetFaceSearchResponse other = (GetFaceSearchResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(videoMetadata(), other.videoMetadata()) && Objects.equals(persons(), other.persons());
    }

    @Override
    public String toString() {
        return ToString.builder("GetFaceSearchResponse").add("JobStatus", jobStatusAsString())
                .add("StatusMessage", statusMessage()).add("NextToken", nextToken()).add("VideoMetadata", videoMetadata())
                .add("Persons", persons()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VideoMetadata":
            return Optional.ofNullable(clazz.cast(videoMetadata()));
        case "Persons":
            return Optional.ofNullable(clazz.cast(persons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFaceSearchResponse, T> g) {
        return obj -> g.apply((GetFaceSearchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFaceSearchResponse> {
        /**
         * <p>
         * The current status of the face search job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the face search job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the face search job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the face search job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(VideoJobStatus jobStatus);

        /**
         * <p>
         * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * </p>
         * 
         * @param statusMessage
         *        If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
         * request to retrieve the next set of search results.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
         *        subsequent request to retrieve the next set of search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every
         * page of paginated responses from a Amazon Rekognition Video operation.
         * </p>
         * 
         * @param videoMetadata
         *        Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in
         *        every page of paginated responses from a Amazon Rekognition Video operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMetadata(VideoMetadata videoMetadata);

        /**
         * <p>
         * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every
         * page of paginated responses from a Amazon Rekognition Video operation.
         * </p>
         * This is a convenience that creates an instance of the {@link VideoMetadata.Builder} avoiding the need to
         * create one manually via {@link VideoMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #videoMetadata(VideoMetadata)}.
         * 
         * @param videoMetadata
         *        a consumer that will call methods on {@link VideoMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoMetadata(VideoMetadata)
         */
        default Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return videoMetadata(VideoMetadata.builder().applyMutation(videoMetadata).build());
        }

        /**
         * <p>
         * An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         * Rekognition collection. It also includes time information for when persons are matched in the video. You
         * specify the input collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code>
         * element includes a time the person was matched, face match details (<code>FaceMatches</code>) for matching
         * faces in the collection, and person information (<code>Person</code>) for the matched person.
         * </p>
         * 
         * @param persons
         *        An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         *        Rekognition collection. It also includes time information for when persons are matched in the video.
         *        You specify the input collection in an initial call to <code>StartFaceSearch</code>. Each
         *        <code>Persons</code> element includes a time the person was matched, face match details (
         *        <code>FaceMatches</code>) for matching faces in the collection, and person information (
         *        <code>Person</code>) for the matched person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persons(Collection<PersonMatch> persons);

        /**
         * <p>
         * An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         * Rekognition collection. It also includes time information for when persons are matched in the video. You
         * specify the input collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code>
         * element includes a time the person was matched, face match details (<code>FaceMatches</code>) for matching
         * faces in the collection, and person information (<code>Person</code>) for the matched person.
         * </p>
         * 
         * @param persons
         *        An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         *        Rekognition collection. It also includes time information for when persons are matched in the video.
         *        You specify the input collection in an initial call to <code>StartFaceSearch</code>. Each
         *        <code>Persons</code> element includes a time the person was matched, face match details (
         *        <code>FaceMatches</code>) for matching faces in the collection, and person information (
         *        <code>Person</code>) for the matched person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persons(PersonMatch... persons);

        /**
         * <p>
         * An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         * Rekognition collection. It also includes time information for when persons are matched in the video. You
         * specify the input collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code>
         * element includes a time the person was matched, face match details (<code>FaceMatches</code>) for matching
         * faces in the collection, and person information (<code>Person</code>) for the matched person.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PersonMatch>.Builder} avoiding the need to
         * create one manually via {@link List<PersonMatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PersonMatch>.Builder#build()} is called immediately and its
         * result is passed to {@link #persons(List<PersonMatch>)}.
         * 
         * @param persons
         *        a consumer that will call methods on {@link List<PersonMatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #persons(List<PersonMatch>)
         */
        Builder persons(Consumer<PersonMatch.Builder>... persons);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String statusMessage;

        private String nextToken;

        private VideoMetadata videoMetadata;

        private List<PersonMatch> persons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFaceSearchResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            statusMessage(model.statusMessage);
            nextToken(model.nextToken);
            videoMetadata(model.videoMetadata);
            persons(model.persons);
        }

        public final String getJobStatusAsString() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return videoMetadata != null ? videoMetadata.toBuilder() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        public final Collection<PersonMatch.Builder> getPersons() {
            return persons != null ? persons.stream().map(PersonMatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder persons(Collection<PersonMatch> persons) {
            this.persons = PersonMatchesCopier.copy(persons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(PersonMatch... persons) {
            persons(Arrays.asList(persons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(Consumer<PersonMatch.Builder>... persons) {
            persons(Stream.of(persons).map(c -> PersonMatch.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPersons(Collection<PersonMatch.BuilderImpl> persons) {
            this.persons = PersonMatchesCopier.copyFromBuilder(persons);
        }

        @Override
        public GetFaceSearchResponse build() {
            return new GetFaceSearchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
