/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details and path tracking information for a single time a person's path is tracked in a video. Amazon Rekognition
 * operations that track people's paths return an array of <code>PersonDetection</code> objects with elements for each
 * time a person's path is tracked in a video.
 * </p>
 * <p>
 * For more information, see GetPersonTracking in the Amazon Rekognition Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PersonDetection implements SdkPojo, Serializable, ToCopyableBuilder<PersonDetection.Builder, PersonDetection> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(PersonDetection::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<PersonDetail> PERSON_FIELD = SdkField.<PersonDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(PersonDetection::person)).setter(setter(Builder::person)).constructor(PersonDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Person").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, PERSON_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long timestamp;

    private final PersonDetail person;

    private PersonDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.person = builder.person;
    }

    /**
     * <p>
     * The time, in milliseconds from the start of the video, that the person's path was tracked.
     * </p>
     * 
     * @return The time, in milliseconds from the start of the video, that the person's path was tracked.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Details about a person whose path was tracked in a video.
     * </p>
     * 
     * @return Details about a person whose path was tracked in a video.
     */
    public PersonDetail person() {
        return person;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(person());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonDetection)) {
            return false;
        }
        PersonDetection other = (PersonDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(person(), other.person());
    }

    @Override
    public String toString() {
        return ToString.builder("PersonDetection").add("Timestamp", timestamp()).add("Person", person()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Person":
            return Optional.ofNullable(clazz.cast(person()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PersonDetection, T> g) {
        return obj -> g.apply((PersonDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PersonDetection> {
        /**
         * <p>
         * The time, in milliseconds from the start of the video, that the person's path was tracked.
         * </p>
         * 
         * @param timestamp
         *        The time, in milliseconds from the start of the video, that the person's path was tracked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * Details about a person whose path was tracked in a video.
         * </p>
         * 
         * @param person
         *        Details about a person whose path was tracked in a video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder person(PersonDetail person);

        /**
         * <p>
         * Details about a person whose path was tracked in a video.
         * </p>
         * This is a convenience that creates an instance of the {@link PersonDetail.Builder} avoiding the need to
         * create one manually via {@link PersonDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link PersonDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #person(PersonDetail)}.
         * 
         * @param person
         *        a consumer that will call methods on {@link PersonDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #person(PersonDetail)
         */
        default Builder person(Consumer<PersonDetail.Builder> person) {
            return person(PersonDetail.builder().applyMutation(person).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private PersonDetail person;

        private BuilderImpl() {
        }

        private BuilderImpl(PersonDetection model) {
            timestamp(model.timestamp);
            person(model.person);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final PersonDetail.Builder getPerson() {
            return person != null ? person.toBuilder() : null;
        }

        @Override
        public final Builder person(PersonDetail person) {
            this.person = person;
            return this;
        }

        public final void setPerson(PersonDetail.BuilderImpl person) {
            this.person = person != null ? person.build() : null;
        }

        @Override
        public PersonDetection build() {
            return new PersonDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
