/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse;

public class ListStreamProcessorsIterable
implements SdkIterable<ListStreamProcessorsResponse> {
    private final RekognitionClient client;
    private final ListStreamProcessorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamProcessorsIterable(RekognitionClient client, ListStreamProcessorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamProcessorsResponseFetcher();
    }

    public Iterator<ListStreamProcessorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListStreamProcessorsIterable resume(ListStreamProcessorsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStreamProcessorsIterable(this.client, (ListStreamProcessorsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListStreamProcessorsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListStreamProcessorsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListStreamProcessorsResponseFetcher
    implements SyncPageFetcher<ListStreamProcessorsResponse> {
        private ListStreamProcessorsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamProcessorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamProcessorsResponse nextPage(ListStreamProcessorsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamProcessorsIterable.this.client.listStreamProcessors(ListStreamProcessorsIterable.this.firstRequest);
            }
            return ListStreamProcessorsIterable.this.client.listStreamProcessors((ListStreamProcessorsRequest)((Object)ListStreamProcessorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

