/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<DeleteFacesResponse.Builder, DeleteFacesResponse> {
    private static final SdkField<List<String>> DELETED_FACES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeletedFaces")
            .getter(getter(DeleteFacesResponse::deletedFaces))
            .setter(setter(Builder::deletedFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedFaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnsuccessfulFaceDeletion>> UNSUCCESSFUL_FACE_DELETIONS_FIELD = SdkField
            .<List<UnsuccessfulFaceDeletion>> builder(MarshallingType.LIST)
            .memberName("UnsuccessfulFaceDeletions")
            .getter(getter(DeleteFacesResponse::unsuccessfulFaceDeletions))
            .setter(setter(Builder::unsuccessfulFaceDeletions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFaceDeletions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnsuccessfulFaceDeletion> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsuccessfulFaceDeletion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_FACES_FIELD,
            UNSUCCESSFUL_FACE_DELETIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> deletedFaces;

    private final List<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions;

    private DeleteFacesResponse(BuilderImpl builder) {
        super(builder);
        this.deletedFaces = builder.deletedFaces;
        this.unsuccessfulFaceDeletions = builder.unsuccessfulFaceDeletions;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeletedFaces property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeletedFaces() {
        return deletedFaces != null && !(deletedFaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings (face IDs) of the faces that were deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeletedFaces} method.
     * </p>
     * 
     * @return An array of strings (face IDs) of the faces that were deleted.
     */
    public final List<String> deletedFaces() {
        return deletedFaces;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnsuccessfulFaceDeletions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnsuccessfulFaceDeletions() {
        return unsuccessfulFaceDeletions != null && !(unsuccessfulFaceDeletions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of any faces that weren't deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsuccessfulFaceDeletions} method.
     * </p>
     * 
     * @return An array of any faces that weren't deleted.
     */
    public final List<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions() {
        return unsuccessfulFaceDeletions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeletedFaces() ? deletedFaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsuccessfulFaceDeletions() ? unsuccessfulFaceDeletions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesResponse)) {
            return false;
        }
        DeleteFacesResponse other = (DeleteFacesResponse) obj;
        return hasDeletedFaces() == other.hasDeletedFaces() && Objects.equals(deletedFaces(), other.deletedFaces())
                && hasUnsuccessfulFaceDeletions() == other.hasUnsuccessfulFaceDeletions()
                && Objects.equals(unsuccessfulFaceDeletions(), other.unsuccessfulFaceDeletions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFacesResponse").add("DeletedFaces", hasDeletedFaces() ? deletedFaces() : null)
                .add("UnsuccessfulFaceDeletions", hasUnsuccessfulFaceDeletions() ? unsuccessfulFaceDeletions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletedFaces":
            return Optional.ofNullable(clazz.cast(deletedFaces()));
        case "UnsuccessfulFaceDeletions":
            return Optional.ofNullable(clazz.cast(unsuccessfulFaceDeletions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeletedFaces", DELETED_FACES_FIELD);
        map.put("UnsuccessfulFaceDeletions", UNSUCCESSFUL_FACE_DELETIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFacesResponse, T> g) {
        return obj -> g.apply((DeleteFacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFacesResponse> {
        /**
         * <p>
         * An array of strings (face IDs) of the faces that were deleted.
         * </p>
         * 
         * @param deletedFaces
         *        An array of strings (face IDs) of the faces that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedFaces(Collection<String> deletedFaces);

        /**
         * <p>
         * An array of strings (face IDs) of the faces that were deleted.
         * </p>
         * 
         * @param deletedFaces
         *        An array of strings (face IDs) of the faces that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedFaces(String... deletedFaces);

        /**
         * <p>
         * An array of any faces that weren't deleted.
         * </p>
         * 
         * @param unsuccessfulFaceDeletions
         *        An array of any faces that weren't deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFaceDeletions(Collection<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions);

        /**
         * <p>
         * An array of any faces that weren't deleted.
         * </p>
         * 
         * @param unsuccessfulFaceDeletions
         *        An array of any faces that weren't deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFaceDeletions(UnsuccessfulFaceDeletion... unsuccessfulFaceDeletions);

        /**
         * <p>
         * An array of any faces that weren't deleted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion.Builder#build()} is called
         * immediately and its result is passed to {@link #unsuccessfulFaceDeletions(List<UnsuccessfulFaceDeletion>)}.
         * 
         * @param unsuccessfulFaceDeletions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDeletion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessfulFaceDeletions(java.util.Collection<UnsuccessfulFaceDeletion>)
         */
        Builder unsuccessfulFaceDeletions(Consumer<UnsuccessfulFaceDeletion.Builder>... unsuccessfulFaceDeletions);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<String> deletedFaces = DefaultSdkAutoConstructList.getInstance();

        private List<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesResponse model) {
            super(model);
            deletedFaces(model.deletedFaces);
            unsuccessfulFaceDeletions(model.unsuccessfulFaceDeletions);
        }

        public final Collection<String> getDeletedFaces() {
            if (deletedFaces instanceof SdkAutoConstructList) {
                return null;
            }
            return deletedFaces;
        }

        public final void setDeletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
        }

        @Override
        public final Builder deletedFaces(Collection<String> deletedFaces) {
            this.deletedFaces = FaceIdListCopier.copy(deletedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedFaces(String... deletedFaces) {
            deletedFaces(Arrays.asList(deletedFaces));
            return this;
        }

        public final List<UnsuccessfulFaceDeletion.Builder> getUnsuccessfulFaceDeletions() {
            List<UnsuccessfulFaceDeletion.Builder> result = UnsuccessfulFaceDeletionsListCopier
                    .copyToBuilder(this.unsuccessfulFaceDeletions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulFaceDeletions(Collection<UnsuccessfulFaceDeletion.BuilderImpl> unsuccessfulFaceDeletions) {
            this.unsuccessfulFaceDeletions = UnsuccessfulFaceDeletionsListCopier.copyFromBuilder(unsuccessfulFaceDeletions);
        }

        @Override
        public final Builder unsuccessfulFaceDeletions(Collection<UnsuccessfulFaceDeletion> unsuccessfulFaceDeletions) {
            this.unsuccessfulFaceDeletions = UnsuccessfulFaceDeletionsListCopier.copy(unsuccessfulFaceDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceDeletions(UnsuccessfulFaceDeletion... unsuccessfulFaceDeletions) {
            unsuccessfulFaceDeletions(Arrays.asList(unsuccessfulFaceDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceDeletions(Consumer<UnsuccessfulFaceDeletion.Builder>... unsuccessfulFaceDeletions) {
            unsuccessfulFaceDeletions(Stream.of(unsuccessfulFaceDeletions)
                    .map(c -> UnsuccessfulFaceDeletion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteFacesResponse build() {
            return new DeleteFacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
