/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFaceSearchResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetFaceSearchResponse.Builder, GetFaceSearchResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(GetFaceSearchResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetFaceSearchResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetFaceSearchResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField
            .<VideoMetadata> builder(MarshallingType.SDK_POJO).memberName("VideoMetadata")
            .getter(getter(GetFaceSearchResponse::videoMetadata)).setter(setter(Builder::videoMetadata))
            .constructor(VideoMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()).build();

    private static final SdkField<List<PersonMatch>> PERSONS_FIELD = SdkField
            .<List<PersonMatch>> builder(MarshallingType.LIST)
            .memberName("Persons")
            .getter(getter(GetFaceSearchResponse::persons))
            .setter(setter(Builder::persons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PersonMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(PersonMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetFaceSearchResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<Video> VIDEO_FIELD = SdkField.<Video> builder(MarshallingType.SDK_POJO).memberName("Video")
            .getter(getter(GetFaceSearchResponse::video)).setter(setter(Builder::video)).constructor(Video::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<String> JOB_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobTag")
            .getter(getter(GetFaceSearchResponse::jobTag)).setter(setter(Builder::jobTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOB_STATUS_FIELD, STATUS_MESSAGE_FIELD, NEXT_TOKEN_FIELD, VIDEO_METADATA_FIELD, PERSONS_FIELD, JOB_ID_FIELD,
                    VIDEO_FIELD, JOB_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobStatus;

    private final String statusMessage;

    private final String nextToken;

    private final VideoMetadata videoMetadata;

    private final List<PersonMatch> persons;

    private final String jobId;

    private final Video video;

    private final String jobTag;

    private GetFaceSearchResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.nextToken = builder.nextToken;
        this.videoMetadata = builder.videoMetadata;
        this.persons = builder.persons;
        this.jobId = builder.jobId;
        this.video = builder.video;
        this.jobTag = builder.jobTag;
    }

    /**
     * <p>
     * The current status of the face search job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the face search job.
     * @see VideoJobStatus
     */
    public final VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the face search job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the face search job.
     * @see VideoJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     * </p>
     * 
     * @return If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
     * request to retrieve the next set of search results.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
     *         subsequent request to retrieve the next set of search results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page
     * of paginated responses from a Amazon Rekognition Video operation.
     * </p>
     * 
     * @return Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in
     *         every page of paginated responses from a Amazon Rekognition Video operation.
     */
    public final VideoMetadata videoMetadata() {
        return videoMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Persons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPersons() {
        return persons != null && !(persons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon Rekognition
     * collection. It also includes time information for when persons are matched in the video. You specify the input
     * collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code> element includes a time
     * the person was matched, face match details (<code>FaceMatches</code>) for matching faces in the collection, and
     * person information (<code>Person</code>) for the matched person.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersons} method.
     * </p>
     * 
     * @return An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
     *         Rekognition collection. It also includes time information for when persons are matched in the video. You
     *         specify the input collection in an initial call to <code>StartFaceSearch</code>. Each
     *         <code>Persons</code> element includes a time the person was matched, face match details (
     *         <code>FaceMatches</code>) for matching faces in the collection, and person information (
     *         <code>Person</code>) for the matched person.
     */
    public final List<PersonMatch> persons() {
        return persons;
    }

    /**
     * <p>
     * Job identifier for the face search operation for which you want to obtain results. The job identifer is returned
     * by an initial call to StartFaceSearch.
     * </p>
     * 
     * @return Job identifier for the face search operation for which you want to obtain results. The job identifer is
     *         returned by an initial call to StartFaceSearch.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * Returns the value of the Video property for this object.
     * 
     * @return The value of the Video property for this object.
     */
    public final Video video() {
        return video;
    }

    /**
     * <p>
     * A job identifier specified in the call to StartFaceSearch and returned in the job completion notification sent to
     * your Amazon Simple Notification Service topic.
     * </p>
     * 
     * @return A job identifier specified in the call to StartFaceSearch and returned in the job completion notification
     *         sent to your Amazon Simple Notification Service topic.
     */
    public final String jobTag() {
        return jobTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasPersons() ? persons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(jobTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceSearchResponse)) {
            return false;
        }
        GetFaceSearchResponse other = (GetFaceSearchResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(videoMetadata(), other.videoMetadata()) && hasPersons() == other.hasPersons()
                && Objects.equals(persons(), other.persons()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(video(), other.video()) && Objects.equals(jobTag(), other.jobTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFaceSearchResponse").add("JobStatus", jobStatusAsString())
                .add("StatusMessage", statusMessage()).add("NextToken", nextToken()).add("VideoMetadata", videoMetadata())
                .add("Persons", hasPersons() ? persons() : null).add("JobId", jobId()).add("Video", video())
                .add("JobTag", jobTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VideoMetadata":
            return Optional.ofNullable(clazz.cast(videoMetadata()));
        case "Persons":
            return Optional.ofNullable(clazz.cast(persons()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "JobTag":
            return Optional.ofNullable(clazz.cast(jobTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("VideoMetadata", VIDEO_METADATA_FIELD);
        map.put("Persons", PERSONS_FIELD);
        map.put("JobId", JOB_ID_FIELD);
        map.put("Video", VIDEO_FIELD);
        map.put("JobTag", JOB_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFaceSearchResponse, T> g) {
        return obj -> g.apply((GetFaceSearchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFaceSearchResponse> {
        /**
         * <p>
         * The current status of the face search job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the face search job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the face search job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the face search job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(VideoJobStatus jobStatus);

        /**
         * <p>
         * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * </p>
         * 
         * @param statusMessage
         *        If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
         * request to retrieve the next set of search results.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
         *        subsequent request to retrieve the next set of search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every
         * page of paginated responses from a Amazon Rekognition Video operation.
         * </p>
         * 
         * @param videoMetadata
         *        Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in
         *        every page of paginated responses from a Amazon Rekognition Video operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMetadata(VideoMetadata videoMetadata);

        /**
         * <p>
         * Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every
         * page of paginated responses from a Amazon Rekognition Video operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoMetadata.Builder} avoiding the need
         * to create one manually via {@link VideoMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #videoMetadata(VideoMetadata)}.
         * 
         * @param videoMetadata
         *        a consumer that will call methods on {@link VideoMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoMetadata(VideoMetadata)
         */
        default Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return videoMetadata(VideoMetadata.builder().applyMutation(videoMetadata).build());
        }

        /**
         * <p>
         * An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         * Rekognition collection. It also includes time information for when persons are matched in the video. You
         * specify the input collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code>
         * element includes a time the person was matched, face match details (<code>FaceMatches</code>) for matching
         * faces in the collection, and person information (<code>Person</code>) for the matched person.
         * </p>
         * 
         * @param persons
         *        An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         *        Rekognition collection. It also includes time information for when persons are matched in the video.
         *        You specify the input collection in an initial call to <code>StartFaceSearch</code>. Each
         *        <code>Persons</code> element includes a time the person was matched, face match details (
         *        <code>FaceMatches</code>) for matching faces in the collection, and person information (
         *        <code>Person</code>) for the matched person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persons(Collection<PersonMatch> persons);

        /**
         * <p>
         * An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         * Rekognition collection. It also includes time information for when persons are matched in the video. You
         * specify the input collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code>
         * element includes a time the person was matched, face match details (<code>FaceMatches</code>) for matching
         * faces in the collection, and person information (<code>Person</code>) for the matched person.
         * </p>
         * 
         * @param persons
         *        An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         *        Rekognition collection. It also includes time information for when persons are matched in the video.
         *        You specify the input collection in an initial call to <code>StartFaceSearch</code>. Each
         *        <code>Persons</code> element includes a time the person was matched, face match details (
         *        <code>FaceMatches</code>) for matching faces in the collection, and person information (
         *        <code>Person</code>) for the matched person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persons(PersonMatch... persons);

        /**
         * <p>
         * An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon
         * Rekognition collection. It also includes time information for when persons are matched in the video. You
         * specify the input collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code>
         * element includes a time the person was matched, face match details (<code>FaceMatches</code>) for matching
         * faces in the collection, and person information (<code>Person</code>) for the matched person.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.PersonMatch.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.PersonMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.PersonMatch.Builder#build()} is called immediately
         * and its result is passed to {@link #persons(List<PersonMatch>)}.
         * 
         * @param persons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.PersonMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #persons(java.util.Collection<PersonMatch>)
         */
        Builder persons(Consumer<PersonMatch.Builder>... persons);

        /**
         * <p>
         * Job identifier for the face search operation for which you want to obtain results. The job identifer is
         * returned by an initial call to StartFaceSearch.
         * </p>
         * 
         * @param jobId
         *        Job identifier for the face search operation for which you want to obtain results. The job identifer
         *        is returned by an initial call to StartFaceSearch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * Sets the value of the Video property for this object.
         *
         * @param video
         *        The new value for the Video property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(Video video);

        /**
         * Sets the value of the Video property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Video.Builder} avoiding the need to
         * create one manually via {@link Video#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Video.Builder#build()} is called immediately and its result is
         * passed to {@link #video(Video)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link Video.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(Video)
         */
        default Builder video(Consumer<Video.Builder> video) {
            return video(Video.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * A job identifier specified in the call to StartFaceSearch and returned in the job completion notification
         * sent to your Amazon Simple Notification Service topic.
         * </p>
         * 
         * @param jobTag
         *        A job identifier specified in the call to StartFaceSearch and returned in the job completion
         *        notification sent to your Amazon Simple Notification Service topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTag(String jobTag);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String statusMessage;

        private String nextToken;

        private VideoMetadata videoMetadata;

        private List<PersonMatch> persons = DefaultSdkAutoConstructList.getInstance();

        private String jobId;

        private Video video;

        private String jobTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFaceSearchResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            statusMessage(model.statusMessage);
            nextToken(model.nextToken);
            videoMetadata(model.videoMetadata);
            persons(model.persons);
            jobId(model.jobId);
            video(model.video);
            jobTag(model.jobTag);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return videoMetadata != null ? videoMetadata.toBuilder() : null;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final List<PersonMatch.Builder> getPersons() {
            List<PersonMatch.Builder> result = PersonMatchesCopier.copyToBuilder(this.persons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPersons(Collection<PersonMatch.BuilderImpl> persons) {
            this.persons = PersonMatchesCopier.copyFromBuilder(persons);
        }

        @Override
        public final Builder persons(Collection<PersonMatch> persons) {
            this.persons = PersonMatchesCopier.copy(persons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(PersonMatch... persons) {
            persons(Arrays.asList(persons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(Consumer<PersonMatch.Builder>... persons) {
            persons(Stream.of(persons).map(c -> PersonMatch.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Video.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final String getJobTag() {
            return jobTag;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        @Override
        public GetFaceSearchResponse build() {
            return new GetFaceSearchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
