/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomizationFeature {
    CONTENT_MODERATION("CONTENT_MODERATION"),
    CUSTOM_LABELS("CUSTOM_LABELS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomizationFeature> VALUE_MAP;
    private final String value;

    private CustomizationFeature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomizationFeature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomizationFeature> knownValues() {
        EnumSet<CustomizationFeature> knownValues = EnumSet.allOf(CustomizationFeature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomizationFeature.class, CustomizationFeature::toString);
    }
}

