/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse;

public class GetFaceSearchIterable
implements SdkIterable<GetFaceSearchResponse> {
    private final RekognitionClient client;
    private final GetFaceSearchRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFaceSearchIterable(RekognitionClient client, GetFaceSearchRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetFaceSearchResponseFetcher();
    }

    public Iterator<GetFaceSearchResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetFaceSearchResponseFetcher
    implements SyncPageFetcher<GetFaceSearchResponse> {
        private GetFaceSearchResponseFetcher() {
        }

        public boolean hasNextPage(GetFaceSearchResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFaceSearchResponse nextPage(GetFaceSearchResponse previousPage) {
            if (previousPage == null) {
                return GetFaceSearchIterable.this.client.getFaceSearch(GetFaceSearchIterable.this.firstRequest);
            }
            return GetFaceSearchIterable.this.client.getFaceSearch((GetFaceSearchRequest)((Object)GetFaceSearchIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

