/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.DatasetLabelsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetEntriesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, ListDatasetEntriesRequest> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::datasetArn)).setter(ListDatasetEntriesRequest.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<List<String>> CONTAINS_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainsLabels").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::containsLabels)).setter(ListDatasetEntriesRequest.setter(Builder::containsLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> LABELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Labeled").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::labeled)).setter(ListDatasetEntriesRequest.setter(Builder::labeled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labeled").build()}).build();
    private static final SdkField<String> SOURCE_REF_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRefContains").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::sourceRefContains)).setter(ListDatasetEntriesRequest.setter(Builder::sourceRefContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRefContains").build()}).build();
    private static final SdkField<Boolean> HAS_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasErrors").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::hasErrors)).setter(ListDatasetEntriesRequest.setter(Builder::hasErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasErrors").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::nextToken)).setter(ListDatasetEntriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDatasetEntriesRequest.getter(ListDatasetEntriesRequest::maxResults)).setter(ListDatasetEntriesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD, CONTAINS_LABELS_FIELD, LABELED_FIELD, SOURCE_REF_CONTAINS_FIELD, HAS_ERRORS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDatasetEntriesRequest.memberNameToFieldInitializer();
    private final String datasetArn;
    private final List<String> containsLabels;
    private final Boolean labeled;
    private final String sourceRefContains;
    private final Boolean hasErrors;
    private final String nextToken;
    private final Integer maxResults;

    private ListDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.datasetArn = builder.datasetArn;
        this.containsLabels = builder.containsLabels;
        this.labeled = builder.labeled;
        this.sourceRefContains = builder.sourceRefContains;
        this.hasErrors = builder.hasErrors;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final boolean hasContainsLabels() {
        return this.containsLabels != null && !(this.containsLabels instanceof SdkAutoConstructList);
    }

    public final List<String> containsLabels() {
        return this.containsLabels;
    }

    public final Boolean labeled() {
        return this.labeled;
    }

    public final String sourceRefContains() {
        return this.sourceRefContains;
    }

    public final Boolean hasErrors() {
        return this.hasErrors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainsLabels() ? this.containsLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.labeled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRefContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetEntriesRequest)) {
            return false;
        }
        ListDatasetEntriesRequest other = (ListDatasetEntriesRequest)((Object)obj);
        return Objects.equals(this.datasetArn(), other.datasetArn()) && this.hasContainsLabels() == other.hasContainsLabels() && Objects.equals(this.containsLabels(), other.containsLabels()) && Objects.equals(this.labeled(), other.labeled()) && Objects.equals(this.sourceRefContains(), other.sourceRefContains()) && Objects.equals(this.hasErrors(), other.hasErrors()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetEntriesRequest").add("DatasetArn", (Object)this.datasetArn()).add("ContainsLabels", this.hasContainsLabels() ? this.containsLabels() : null).add("Labeled", (Object)this.labeled()).add("SourceRefContains", (Object)this.sourceRefContains()).add("HasErrors", (Object)this.hasErrors()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "ContainsLabels": {
                return Optional.ofNullable(clazz.cast(this.containsLabels()));
            }
            case "Labeled": {
                return Optional.ofNullable(clazz.cast(this.labeled()));
            }
            case "SourceRefContains": {
                return Optional.ofNullable(clazz.cast(this.sourceRefContains()));
            }
            case "HasErrors": {
                return Optional.ofNullable(clazz.cast(this.hasErrors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("ContainsLabels", CONTAINS_LABELS_FIELD);
        map.put("Labeled", LABELED_FIELD);
        map.put("SourceRefContains", SOURCE_REF_CONTAINS_FIELD);
        map.put("HasErrors", HAS_ERRORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetEntriesRequest, T> g) {
        return obj -> g.apply((ListDatasetEntriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String datasetArn;
        private List<String> containsLabels = DefaultSdkAutoConstructList.getInstance();
        private Boolean labeled;
        private String sourceRefContains;
        private Boolean hasErrors;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetEntriesRequest model) {
            super(model);
            this.datasetArn(model.datasetArn);
            this.containsLabels(model.containsLabels);
            this.labeled(model.labeled);
            this.sourceRefContains(model.sourceRefContains);
            this.hasErrors(model.hasErrors);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final Collection<String> getContainsLabels() {
            if (this.containsLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containsLabels;
        }

        public final void setContainsLabels(Collection<String> containsLabels) {
            this.containsLabels = DatasetLabelsCopier.copy(containsLabels);
        }

        @Override
        public final Builder containsLabels(Collection<String> containsLabels) {
            this.containsLabels = DatasetLabelsCopier.copy(containsLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containsLabels(String ... containsLabels) {
            this.containsLabels(Arrays.asList(containsLabels));
            return this;
        }

        public final Boolean getLabeled() {
            return this.labeled;
        }

        public final void setLabeled(Boolean labeled) {
            this.labeled = labeled;
        }

        @Override
        public final Builder labeled(Boolean labeled) {
            this.labeled = labeled;
            return this;
        }

        public final String getSourceRefContains() {
            return this.sourceRefContains;
        }

        public final void setSourceRefContains(String sourceRefContains) {
            this.sourceRefContains = sourceRefContains;
        }

        @Override
        public final Builder sourceRefContains(String sourceRefContains) {
            this.sourceRefContains = sourceRefContains;
            return this;
        }

        public final Boolean getHasErrors() {
            return this.hasErrors;
        }

        public final void setHasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
        }

        @Override
        public final Builder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDatasetEntriesRequest build() {
            return new ListDatasetEntriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetEntriesRequest> {
        public Builder datasetArn(String var1);

        public Builder containsLabels(Collection<String> var1);

        public Builder containsLabels(String ... var1);

        public Builder labeled(Boolean var1);

        public Builder sourceRefContains(String var1);

        public Builder hasErrors(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

