/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure containing details about the detected label, including the name, detected instances, parent labels, and
 * level of confidence.
 * </p>
 * <p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Label implements SdkPojo, Serializable, ToCopyableBuilder<Label.Builder, Label> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Label::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(Label::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField
            .<List<Instance>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(Label::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instance> builder(MarshallingType.SDK_POJO)
                                            .constructor(Instance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Parent>> PARENTS_FIELD = SdkField
            .<List<Parent>> builder(MarshallingType.LIST)
            .memberName("Parents")
            .getter(getter(Label::parents))
            .setter(setter(Builder::parents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parent> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LabelAlias>> ALIASES_FIELD = SdkField
            .<List<LabelAlias>> builder(MarshallingType.LIST)
            .memberName("Aliases")
            .getter(getter(Label::aliases))
            .setter(setter(Builder::aliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LabelCategory>> CATEGORIES_FIELD = SdkField
            .<List<LabelCategory>> builder(MarshallingType.LIST)
            .memberName("Categories")
            .getter(getter(Label::categories))
            .setter(setter(Builder::categories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelCategory> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelCategory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIDENCE_FIELD,
            INSTANCES_FIELD, PARENTS_FIELD, ALIASES_FIELD, CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Float confidence;

    private final List<Instance> instances;

    private final List<Parent> parents;

    private final List<LabelAlias> aliases;

    private final List<LabelCategory> categories;

    private Label(BuilderImpl builder) {
        this.name = builder.name;
        this.confidence = builder.confidence;
        this.instances = builder.instances;
        this.parents = builder.parents;
        this.aliases = builder.aliases;
        this.categories = builder.categories;
    }

    /**
     * <p>
     * The name (label) of the object or scene.
     * </p>
     * 
     * @return The name (label) of the object or scene.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Level of confidence.
     * </p>
     * 
     * @return Level of confidence.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each instance
     * of the detected object. Bounding boxes are returned for common object labels such as people, cars, furniture,
     * apparel or pets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each
     *         instance of the detected object. Bounding boxes are returned for common object labels such as people,
     *         cars, furniture, apparel or pets.
     */
    public final List<Instance> instances() {
        return instances;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParents() {
        return parents != null && !(parents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parent labels for a label. The response includes all ancestor labels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParents} method.
     * </p>
     * 
     * @return The parent labels for a label. The response includes all ancestor labels.
     */
    public final List<Parent> parents() {
        return parents;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aliases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAliases() {
        return aliases != null && !(aliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of potential aliases for a given label.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliases} method.
     * </p>
     * 
     * @return A list of potential aliases for a given label.
     */
    public final List<LabelAlias> aliases() {
        return aliases;
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the categories associated with a given label.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return A list of the categories associated with a given label.
     */
    public final List<LabelCategory> categories() {
        return categories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParents() ? parents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAliases() ? aliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Label)) {
            return false;
        }
        Label other = (Label) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(confidence(), other.confidence())
                && hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && hasParents() == other.hasParents() && Objects.equals(parents(), other.parents())
                && hasAliases() == other.hasAliases() && Objects.equals(aliases(), other.aliases())
                && hasCategories() == other.hasCategories() && Objects.equals(categories(), other.categories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Label").add("Name", name()).add("Confidence", confidence())
                .add("Instances", hasInstances() ? instances() : null).add("Parents", hasParents() ? parents() : null)
                .add("Aliases", hasAliases() ? aliases() : null).add("Categories", hasCategories() ? categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "Parents":
            return Optional.ofNullable(clazz.cast(parents()));
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Instances", INSTANCES_FIELD);
        map.put("Parents", PARENTS_FIELD);
        map.put("Aliases", ALIASES_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Label, T> g) {
        return obj -> g.apply((Label) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Label> {
        /**
         * <p>
         * The name (label) of the object or scene.
         * </p>
         * 
         * @param name
         *        The name (label) of the object or scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Level of confidence.
         * </p>
         * 
         * @param confidence
         *        Level of confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each
         * instance of the detected object. Bounding boxes are returned for common object labels such as people, cars,
         * furniture, apparel or pets.
         * </p>
         * 
         * @param instances
         *        If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for
         *        each instance of the detected object. Bounding boxes are returned for common object labels such as
         *        people, cars, furniture, apparel or pets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each
         * instance of the detected object. Bounding boxes are returned for common object labels such as people, cars,
         * furniture, apparel or pets.
         * </p>
         * 
         * @param instances
         *        If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for
         *        each instance of the detected object. Bounding boxes are returned for common object labels such as
         *        people, cars, furniture, apparel or pets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each
         * instance of the detected object. Bounding boxes are returned for common object labels such as people, cars,
         * furniture, apparel or pets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.Instance.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.Instance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.Instance.Builder#build()} is called immediately and
         * its result is passed to {@link #instances(List<Instance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(java.util.Collection<Instance>)
         */
        Builder instances(Consumer<Instance.Builder>... instances);

        /**
         * <p>
         * The parent labels for a label. The response includes all ancestor labels.
         * </p>
         * 
         * @param parents
         *        The parent labels for a label. The response includes all ancestor labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parents(Collection<Parent> parents);

        /**
         * <p>
         * The parent labels for a label. The response includes all ancestor labels.
         * </p>
         * 
         * @param parents
         *        The parent labels for a label. The response includes all ancestor labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parents(Parent... parents);

        /**
         * <p>
         * The parent labels for a label. The response includes all ancestor labels.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.Parent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.Parent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.Parent.Builder#build()} is called immediately and
         * its result is passed to {@link #parents(List<Parent>)}.
         * 
         * @param parents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.Parent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parents(java.util.Collection<Parent>)
         */
        Builder parents(Consumer<Parent.Builder>... parents);

        /**
         * <p>
         * A list of potential aliases for a given label.
         * </p>
         * 
         * @param aliases
         *        A list of potential aliases for a given label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Collection<LabelAlias> aliases);

        /**
         * <p>
         * A list of potential aliases for a given label.
         * </p>
         * 
         * @param aliases
         *        A list of potential aliases for a given label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(LabelAlias... aliases);

        /**
         * <p>
         * A list of potential aliases for a given label.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.LabelAlias.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.LabelAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.LabelAlias.Builder#build()} is called immediately
         * and its result is passed to {@link #aliases(List<LabelAlias>)}.
         * 
         * @param aliases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.LabelAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(java.util.Collection<LabelAlias>)
         */
        Builder aliases(Consumer<LabelAlias.Builder>... aliases);

        /**
         * <p>
         * A list of the categories associated with a given label.
         * </p>
         * 
         * @param categories
         *        A list of the categories associated with a given label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<LabelCategory> categories);

        /**
         * <p>
         * A list of the categories associated with a given label.
         * </p>
         * 
         * @param categories
         *        A list of the categories associated with a given label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(LabelCategory... categories);

        /**
         * <p>
         * A list of the categories associated with a given label.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.LabelCategory.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.LabelCategory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.LabelCategory.Builder#build()} is called immediately
         * and its result is passed to {@link #categories(List<LabelCategory>)}.
         * 
         * @param categories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.LabelCategory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(java.util.Collection<LabelCategory>)
         */
        Builder categories(Consumer<LabelCategory.Builder>... categories);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Float confidence;

        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private List<Parent> parents = DefaultSdkAutoConstructList.getInstance();

        private List<LabelAlias> aliases = DefaultSdkAutoConstructList.getInstance();

        private List<LabelCategory> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Label model) {
            name(model.name);
            confidence(model.confidence);
            instances(model.instances);
            parents(model.parents);
            aliases(model.aliases);
            categories(model.categories);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final List<Instance.Builder> getInstances() {
            List<Instance.Builder> result = InstancesCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> Instance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Parent.Builder> getParents() {
            List<Parent.Builder> result = ParentsCopier.copyToBuilder(this.parents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParents(Collection<Parent.BuilderImpl> parents) {
            this.parents = ParentsCopier.copyFromBuilder(parents);
        }

        @Override
        public final Builder parents(Collection<Parent> parents) {
            this.parents = ParentsCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Parent... parents) {
            parents(Arrays.asList(parents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Consumer<Parent.Builder>... parents) {
            parents(Stream.of(parents).map(c -> Parent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LabelAlias.Builder> getAliases() {
            List<LabelAlias.Builder> result = LabelAliasesCopier.copyToBuilder(this.aliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliases(Collection<LabelAlias.BuilderImpl> aliases) {
            this.aliases = LabelAliasesCopier.copyFromBuilder(aliases);
        }

        @Override
        public final Builder aliases(Collection<LabelAlias> aliases) {
            this.aliases = LabelAliasesCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(LabelAlias... aliases) {
            aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<LabelAlias.Builder>... aliases) {
            aliases(Stream.of(aliases).map(c -> LabelAlias.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LabelCategory.Builder> getCategories() {
            List<LabelCategory.Builder> result = LabelCategoriesCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<LabelCategory.BuilderImpl> categories) {
            this.categories = LabelCategoriesCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<LabelCategory> categories) {
            this.categories = LabelCategoriesCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(LabelCategory... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<LabelCategory.Builder>... categories) {
            categories(Stream.of(categories).map(c -> LabelCategory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Label build() {
            return new Label(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
