/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectLabelsResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectLabelsResponse.Builder, DetectLabelsResponse> {
    private static final SdkField<List<Label>> LABELS_FIELD = SdkField
            .<List<Label>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(DetectLabelsResponse::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Label> builder(MarshallingType.SDK_POJO)
                                            .constructor(Label::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrientationCorrection").getter(getter(DetectLabelsResponse::orientationCorrectionAsString))
            .setter(setter(Builder::orientationCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build())
            .build();

    private static final SdkField<String> LABEL_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelModelVersion").getter(getter(DetectLabelsResponse::labelModelVersion))
            .setter(setter(Builder::labelModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelModelVersion").build()).build();

    private static final SdkField<DetectLabelsImageProperties> IMAGE_PROPERTIES_FIELD = SdkField
            .<DetectLabelsImageProperties> builder(MarshallingType.SDK_POJO).memberName("ImageProperties")
            .getter(getter(DetectLabelsResponse::imageProperties)).setter(setter(Builder::imageProperties))
            .constructor(DetectLabelsImageProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD,
            ORIENTATION_CORRECTION_FIELD, LABEL_MODEL_VERSION_FIELD, IMAGE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Label> labels;

    private final String orientationCorrection;

    private final String labelModelVersion;

    private final DetectLabelsImageProperties imageProperties;

    private DetectLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.labels = builder.labels;
        this.orientationCorrection = builder.orientationCorrection;
        this.labelModelVersion = builder.labelModelVersion;
        this.imageProperties = builder.imageProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of labels for the real-world objects detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return An array of labels for the real-world objects detected.
     */
    public final List<Label> labels() {
        return labels;
    }

    /**
     * <p>
     * The value of <code>OrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>OrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public final OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(orientationCorrection);
    }

    /**
     * <p>
     * The value of <code>OrientationCorrection</code> is always null.
     * </p>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
     * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
     * correction. The bounding box coordinates are translated to represent object locations after the orientation
     * information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain
     * Exif metadata.
     * </p>
     * <p>
     * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent
     * the object locations before the image is rotated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The value of <code>OrientationCorrection</code> is always null.</p>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
     *         that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
     *         image correction. The bounding box coordinates are translated to represent object locations after the
     *         orientation information in the Exif metadata is used to correct the image orientation. Images in .png
     *         format don't contain Exif metadata.
     *         </p>
     *         <p>
     *         Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
     *         orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
     *         represent the object locations before the image is rotated.
     * @see OrientationCorrection
     */
    public final String orientationCorrectionAsString() {
        return orientationCorrection;
    }

    /**
     * <p>
     * Version number of the label detection model that was used to detect labels.
     * </p>
     * 
     * @return Version number of the label detection model that was used to detect labels.
     */
    public final String labelModelVersion() {
        return labelModelVersion;
    }

    /**
     * <p>
     * Information about the properties of the input image, such as brightness, sharpness, contrast, and dominant
     * colors.
     * </p>
     * 
     * @return Information about the properties of the input image, such as brightness, sharpness, contrast, and
     *         dominant colors.
     */
    public final DetectLabelsImageProperties imageProperties() {
        return imageProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(labelModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(imageProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResponse)) {
            return false;
        }
        DetectLabelsResponse other = (DetectLabelsResponse) obj;
        return hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && Objects.equals(orientationCorrectionAsString(), other.orientationCorrectionAsString())
                && Objects.equals(labelModelVersion(), other.labelModelVersion())
                && Objects.equals(imageProperties(), other.imageProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectLabelsResponse").add("Labels", hasLabels() ? labels() : null)
                .add("OrientationCorrection", orientationCorrectionAsString()).add("LabelModelVersion", labelModelVersion())
                .add("ImageProperties", imageProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "OrientationCorrection":
            return Optional.ofNullable(clazz.cast(orientationCorrectionAsString()));
        case "LabelModelVersion":
            return Optional.ofNullable(clazz.cast(labelModelVersion()));
        case "ImageProperties":
            return Optional.ofNullable(clazz.cast(imageProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Labels", LABELS_FIELD);
        map.put("OrientationCorrection", ORIENTATION_CORRECTION_FIELD);
        map.put("LabelModelVersion", LABEL_MODEL_VERSION_FIELD);
        map.put("ImageProperties", IMAGE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsResponse, T> g) {
        return obj -> g.apply((DetectLabelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectLabelsResponse> {
        /**
         * <p>
         * An array of labels for the real-world objects detected.
         * </p>
         * 
         * @param labels
         *        An array of labels for the real-world objects detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<Label> labels);

        /**
         * <p>
         * An array of labels for the real-world objects detected.
         * </p>
         * 
         * @param labels
         *        An array of labels for the real-world objects detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Label... labels);

        /**
         * <p>
         * An array of labels for the real-world objects detected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.Label.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.Label#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.Label.Builder#build()} is called immediately and its
         * result is passed to {@link #labels(List<Label>)}.
         * 
         * @param labels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.Label.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(java.util.Collection<Label>)
         */
        Builder labels(Consumer<Label.Builder>... labels);

        /**
         * <p>
         * The value of <code>OrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param orientationCorrection
         *        The value of <code>OrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The value of <code>OrientationCorrection</code> is always null.
         * </p>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that
         * includes the image's orientation. Amazon Rekognition uses this orientation information to perform image
         * correction. The bounding box coordinates are translated to represent object locations after the orientation
         * information in the Exif metadata is used to correct the image orientation. Images in .png format don't
         * contain Exif metadata.
         * </p>
         * <p>
         * Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         * orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         * represent the object locations before the image is rotated.
         * </p>
         * 
         * @param orientationCorrection
         *        The value of <code>OrientationCorrection</code> is always null.</p>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata
         *        that includes the image's orientation. Amazon Rekognition uses this orientation information to perform
         *        image correction. The bounding box coordinates are translated to represent object locations after the
         *        orientation information in the Exif metadata is used to correct the image orientation. Images in .png
         *        format don't contain Exif metadata.
         *        </p>
         *        <p>
         *        Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without
         *        orientation information in the image Exif metadata. The bounding box coordinates aren't translated and
         *        represent the object locations before the image is rotated.
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);

        /**
         * <p>
         * Version number of the label detection model that was used to detect labels.
         * </p>
         * 
         * @param labelModelVersion
         *        Version number of the label detection model that was used to detect labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelModelVersion(String labelModelVersion);

        /**
         * <p>
         * Information about the properties of the input image, such as brightness, sharpness, contrast, and dominant
         * colors.
         * </p>
         * 
         * @param imageProperties
         *        Information about the properties of the input image, such as brightness, sharpness, contrast, and
         *        dominant colors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageProperties(DetectLabelsImageProperties imageProperties);

        /**
         * <p>
         * Information about the properties of the input image, such as brightness, sharpness, contrast, and dominant
         * colors.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetectLabelsImageProperties.Builder}
         * avoiding the need to create one manually via {@link DetectLabelsImageProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectLabelsImageProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #imageProperties(DetectLabelsImageProperties)}.
         * 
         * @param imageProperties
         *        a consumer that will call methods on {@link DetectLabelsImageProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageProperties(DetectLabelsImageProperties)
         */
        default Builder imageProperties(Consumer<DetectLabelsImageProperties.Builder> imageProperties) {
            return imageProperties(DetectLabelsImageProperties.builder().applyMutation(imageProperties).build());
        }
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();

        private String orientationCorrection;

        private String labelModelVersion;

        private DetectLabelsImageProperties imageProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsResponse model) {
            super(model);
            labels(model.labels);
            orientationCorrection(model.orientationCorrection);
            labelModelVersion(model.labelModelVersion);
            imageProperties(model.imageProperties);
        }

        public final List<Label.Builder> getLabels() {
            List<Label.Builder> result = LabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder>... labels) {
            labels(Stream.of(labels).map(c -> Label.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection == null ? null : orientationCorrection.toString());
            return this;
        }

        public final String getLabelModelVersion() {
            return labelModelVersion;
        }

        public final void setLabelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
        }

        @Override
        public final Builder labelModelVersion(String labelModelVersion) {
            this.labelModelVersion = labelModelVersion;
            return this;
        }

        public final DetectLabelsImageProperties.Builder getImageProperties() {
            return imageProperties != null ? imageProperties.toBuilder() : null;
        }

        public final void setImageProperties(DetectLabelsImageProperties.BuilderImpl imageProperties) {
            this.imageProperties = imageProperties != null ? imageProperties.build() : null;
        }

        @Override
        public final Builder imageProperties(DetectLabelsImageProperties imageProperties) {
            this.imageProperties = imageProperties;
            return this;
        }

        @Override
        public DetectLabelsResponse build() {
            return new DetectLabelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
