/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the specified filters that should be applied to a list of returned GENERAL_LABELS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelDetectionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelDetectionSettings.Builder, LabelDetectionSettings> {
    private static final SdkField<GeneralLabelsSettings> GENERAL_LABELS_FIELD = SdkField
            .<GeneralLabelsSettings> builder(MarshallingType.SDK_POJO).memberName("GeneralLabels")
            .getter(getter(LabelDetectionSettings::generalLabels)).setter(setter(Builder::generalLabels))
            .constructor(GeneralLabelsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneralLabels").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERAL_LABELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeneralLabelsSettings generalLabels;

    private LabelDetectionSettings(BuilderImpl builder) {
        this.generalLabels = builder.generalLabels;
    }

    /**
     * Returns the value of the GeneralLabels property for this object.
     * 
     * @return The value of the GeneralLabels property for this object.
     */
    public final GeneralLabelsSettings generalLabels() {
        return generalLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generalLabels());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelDetectionSettings)) {
            return false;
        }
        LabelDetectionSettings other = (LabelDetectionSettings) obj;
        return Objects.equals(generalLabels(), other.generalLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelDetectionSettings").add("GeneralLabels", generalLabels()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneralLabels":
            return Optional.ofNullable(clazz.cast(generalLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GeneralLabels", GENERAL_LABELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LabelDetectionSettings, T> g) {
        return obj -> g.apply((LabelDetectionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelDetectionSettings> {
        /**
         * Sets the value of the GeneralLabels property for this object.
         *
         * @param generalLabels
         *        The new value for the GeneralLabels property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generalLabels(GeneralLabelsSettings generalLabels);

        /**
         * Sets the value of the GeneralLabels property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GeneralLabelsSettings.Builder} avoiding
         * the need to create one manually via {@link GeneralLabelsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneralLabelsSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #generalLabels(GeneralLabelsSettings)}.
         * 
         * @param generalLabels
         *        a consumer that will call methods on {@link GeneralLabelsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generalLabels(GeneralLabelsSettings)
         */
        default Builder generalLabels(Consumer<GeneralLabelsSettings.Builder> generalLabels) {
            return generalLabels(GeneralLabelsSettings.builder().applyMutation(generalLabels).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeneralLabelsSettings generalLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelDetectionSettings model) {
            generalLabels(model.generalLabels);
        }

        public final GeneralLabelsSettings.Builder getGeneralLabels() {
            return generalLabels != null ? generalLabels.toBuilder() : null;
        }

        public final void setGeneralLabels(GeneralLabelsSettings.BuilderImpl generalLabels) {
            this.generalLabels = generalLabels != null ? generalLabels.build() : null;
        }

        @Override
        public final Builder generalLabels(GeneralLabelsSettings generalLabels) {
            this.generalLabels = generalLabels;
            return this;
        }

        @Override
        public LabelDetectionSettings build() {
            return new LabelDetectionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
