/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatasetEntriesRequest extends RekognitionRequest implements
        ToCopyableBuilder<UpdateDatasetEntriesRequest.Builder, UpdateDatasetEntriesRequest> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(UpdateDatasetEntriesRequest::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<DatasetChanges> CHANGES_FIELD = SdkField.<DatasetChanges> builder(MarshallingType.SDK_POJO)
            .memberName("Changes").getter(getter(UpdateDatasetEntriesRequest::changes)).setter(setter(Builder::changes))
            .constructor(DatasetChanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD,
            CHANGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datasetArn;

    private final DatasetChanges changes;

    private UpdateDatasetEntriesRequest(BuilderImpl builder) {
        super(builder);
        this.datasetArn = builder.datasetArn;
        this.changes = builder.changes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset that you want to update.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The changes that you want to make to the dataset.
     * </p>
     * 
     * @return The changes that you want to make to the dataset.
     */
    public final DatasetChanges changes() {
        return changes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(changes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetEntriesRequest)) {
            return false;
        }
        UpdateDatasetEntriesRequest other = (UpdateDatasetEntriesRequest) obj;
        return Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(changes(), other.changes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDatasetEntriesRequest").add("DatasetArn", datasetArn()).add("Changes", changes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "Changes":
            return Optional.ofNullable(clazz.cast(changes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("Changes", CHANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetEntriesRequest, T> g) {
        return obj -> g.apply((UpdateDatasetEntriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatasetEntriesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset that you want to update.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The changes that you want to make to the dataset.
         * </p>
         * 
         * @param changes
         *        The changes that you want to make to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(DatasetChanges changes);

        /**
         * <p>
         * The changes that you want to make to the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetChanges.Builder} avoiding the need
         * to create one manually via {@link DatasetChanges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetChanges.Builder#build()} is called immediately and its
         * result is passed to {@link #changes(DatasetChanges)}.
         * 
         * @param changes
         *        a consumer that will call methods on {@link DatasetChanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changes(DatasetChanges)
         */
        default Builder changes(Consumer<DatasetChanges.Builder> changes) {
            return changes(DatasetChanges.builder().applyMutation(changes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String datasetArn;

        private DatasetChanges changes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetEntriesRequest model) {
            super(model);
            datasetArn(model.datasetArn);
            changes(model.changes);
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final DatasetChanges.Builder getChanges() {
            return changes != null ? changes.toBuilder() : null;
        }

        public final void setChanges(DatasetChanges.BuilderImpl changes) {
            this.changes = changes != null ? changes.build() : null;
        }

        @Override
        public final Builder changes(DatasetChanges changes) {
            this.changes = changes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetEntriesRequest build() {
            return new UpdateDatasetEntriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
