/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UnsuccessfulFaceDisassociationReason {
    FACE_NOT_FOUND("FACE_NOT_FOUND"),
    ASSOCIATED_TO_A_DIFFERENT_USER("ASSOCIATED_TO_A_DIFFERENT_USER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UnsuccessfulFaceDisassociationReason> VALUE_MAP;
    private final String value;

    private UnsuccessfulFaceDisassociationReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UnsuccessfulFaceDisassociationReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UnsuccessfulFaceDisassociationReason> knownValues() {
        EnumSet<UnsuccessfulFaceDisassociationReason> knownValues = EnumSet.allOf(UnsuccessfulFaceDisassociationReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UnsuccessfulFaceDisassociationReason.class, UnsuccessfulFaceDisassociationReason::toString);
    }
}

