/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<DisassociateFacesResponse.Builder, DisassociateFacesResponse> {
    private static final SdkField<List<DisassociatedFace>> DISASSOCIATED_FACES_FIELD = SdkField
            .<List<DisassociatedFace>> builder(MarshallingType.LIST)
            .memberName("DisassociatedFaces")
            .getter(getter(DisassociateFacesResponse::disassociatedFaces))
            .setter(setter(Builder::disassociatedFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociatedFaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DisassociatedFace> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisassociatedFace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnsuccessfulFaceDisassociation>> UNSUCCESSFUL_FACE_DISASSOCIATIONS_FIELD = SdkField
            .<List<UnsuccessfulFaceDisassociation>> builder(MarshallingType.LIST)
            .memberName("UnsuccessfulFaceDisassociations")
            .getter(getter(DisassociateFacesResponse::unsuccessfulFaceDisassociations))
            .setter(setter(Builder::unsuccessfulFaceDisassociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFaceDisassociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnsuccessfulFaceDisassociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsuccessfulFaceDisassociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserStatus").getter(getter(DisassociateFacesResponse::userStatusAsString))
            .setter(setter(Builder::userStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISASSOCIATED_FACES_FIELD,
            UNSUCCESSFUL_FACE_DISASSOCIATIONS_FIELD, USER_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DisassociatedFace> disassociatedFaces;

    private final List<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations;

    private final String userStatus;

    private DisassociateFacesResponse(BuilderImpl builder) {
        super(builder);
        this.disassociatedFaces = builder.disassociatedFaces;
        this.unsuccessfulFaceDisassociations = builder.unsuccessfulFaceDisassociations;
        this.userStatus = builder.userStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisassociatedFaces property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDisassociatedFaces() {
        return disassociatedFaces != null && !(disassociatedFaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of DissociatedFace objects containing FaceIds that are successfully disassociated with the UserID is
     * returned. Returned if the DisassociatedFaces action is successful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisassociatedFaces} method.
     * </p>
     * 
     * @return An array of DissociatedFace objects containing FaceIds that are successfully disassociated with the
     *         UserID is returned. Returned if the DisassociatedFaces action is successful.
     */
    public final List<DisassociatedFace> disassociatedFaces() {
        return disassociatedFaces;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnsuccessfulFaceDisassociations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasUnsuccessfulFaceDisassociations() {
        return unsuccessfulFaceDisassociations != null && !(unsuccessfulFaceDisassociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of UnsuccessfulDisassociation objects containing FaceIds that are not successfully associated, along
     * with the reasons for the failure to associate. Returned if the DisassociateFaces action is successful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsuccessfulFaceDisassociations}
     * method.
     * </p>
     * 
     * @return An array of UnsuccessfulDisassociation objects containing FaceIds that are not successfully associated,
     *         along with the reasons for the failure to associate. Returned if the DisassociateFaces action is
     *         successful.
     */
    public final List<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations() {
        return unsuccessfulFaceDisassociations;
    }

    /**
     * <p>
     * The status of an update made to a User. Reflects if the User has been updated for every requested change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The status of an update made to a User. Reflects if the User has been updated for every requested change.
     * @see UserStatus
     */
    public final UserStatus userStatus() {
        return UserStatus.fromValue(userStatus);
    }

    /**
     * <p>
     * The status of an update made to a User. Reflects if the User has been updated for every requested change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The status of an update made to a User. Reflects if the User has been updated for every requested change.
     * @see UserStatus
     */
    public final String userStatusAsString() {
        return userStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDisassociatedFaces() ? disassociatedFaces() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasUnsuccessfulFaceDisassociations() ? unsuccessfulFaceDisassociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateFacesResponse)) {
            return false;
        }
        DisassociateFacesResponse other = (DisassociateFacesResponse) obj;
        return hasDisassociatedFaces() == other.hasDisassociatedFaces()
                && Objects.equals(disassociatedFaces(), other.disassociatedFaces())
                && hasUnsuccessfulFaceDisassociations() == other.hasUnsuccessfulFaceDisassociations()
                && Objects.equals(unsuccessfulFaceDisassociations(), other.unsuccessfulFaceDisassociations())
                && Objects.equals(userStatusAsString(), other.userStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DisassociateFacesResponse")
                .add("DisassociatedFaces", hasDisassociatedFaces() ? disassociatedFaces() : null)
                .add("UnsuccessfulFaceDisassociations",
                        hasUnsuccessfulFaceDisassociations() ? unsuccessfulFaceDisassociations() : null)
                .add("UserStatus", userStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisassociatedFaces":
            return Optional.ofNullable(clazz.cast(disassociatedFaces()));
        case "UnsuccessfulFaceDisassociations":
            return Optional.ofNullable(clazz.cast(unsuccessfulFaceDisassociations()));
        case "UserStatus":
            return Optional.ofNullable(clazz.cast(userStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisassociatedFaces", DISASSOCIATED_FACES_FIELD);
        map.put("UnsuccessfulFaceDisassociations", UNSUCCESSFUL_FACE_DISASSOCIATIONS_FIELD);
        map.put("UserStatus", USER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateFacesResponse, T> g) {
        return obj -> g.apply((DisassociateFacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateFacesResponse> {
        /**
         * <p>
         * An array of DissociatedFace objects containing FaceIds that are successfully disassociated with the UserID is
         * returned. Returned if the DisassociatedFaces action is successful.
         * </p>
         * 
         * @param disassociatedFaces
         *        An array of DissociatedFace objects containing FaceIds that are successfully disassociated with the
         *        UserID is returned. Returned if the DisassociatedFaces action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociatedFaces(Collection<DisassociatedFace> disassociatedFaces);

        /**
         * <p>
         * An array of DissociatedFace objects containing FaceIds that are successfully disassociated with the UserID is
         * returned. Returned if the DisassociatedFaces action is successful.
         * </p>
         * 
         * @param disassociatedFaces
         *        An array of DissociatedFace objects containing FaceIds that are successfully disassociated with the
         *        UserID is returned. Returned if the DisassociatedFaces action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociatedFaces(DisassociatedFace... disassociatedFaces);

        /**
         * <p>
         * An array of DissociatedFace objects containing FaceIds that are successfully disassociated with the UserID is
         * returned. Returned if the DisassociatedFaces action is successful.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.DisassociatedFace.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.rekognition.model.DisassociatedFace#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.DisassociatedFace.Builder#build()} is called
         * immediately and its result is passed to {@link #disassociatedFaces(List<DisassociatedFace>)}.
         * 
         * @param disassociatedFaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.DisassociatedFace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disassociatedFaces(java.util.Collection<DisassociatedFace>)
         */
        Builder disassociatedFaces(Consumer<DisassociatedFace.Builder>... disassociatedFaces);

        /**
         * <p>
         * An array of UnsuccessfulDisassociation objects containing FaceIds that are not successfully associated, along
         * with the reasons for the failure to associate. Returned if the DisassociateFaces action is successful.
         * </p>
         * 
         * @param unsuccessfulFaceDisassociations
         *        An array of UnsuccessfulDisassociation objects containing FaceIds that are not successfully
         *        associated, along with the reasons for the failure to associate. Returned if the DisassociateFaces
         *        action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFaceDisassociations(Collection<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations);

        /**
         * <p>
         * An array of UnsuccessfulDisassociation objects containing FaceIds that are not successfully associated, along
         * with the reasons for the failure to associate. Returned if the DisassociateFaces action is successful.
         * </p>
         * 
         * @param unsuccessfulFaceDisassociations
         *        An array of UnsuccessfulDisassociation objects containing FaceIds that are not successfully
         *        associated, along with the reasons for the failure to associate. Returned if the DisassociateFaces
         *        action is successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFaceDisassociations(UnsuccessfulFaceDisassociation... unsuccessfulFaceDisassociations);

        /**
         * <p>
         * An array of UnsuccessfulDisassociation objects containing FaceIds that are not successfully associated, along
         * with the reasons for the failure to associate. Returned if the DisassociateFaces action is successful.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #unsuccessfulFaceDisassociations(List<UnsuccessfulFaceDisassociation>)}.
         * 
         * @param unsuccessfulFaceDisassociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.UnsuccessfulFaceDisassociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessfulFaceDisassociations(java.util.Collection<UnsuccessfulFaceDisassociation>)
         */
        Builder unsuccessfulFaceDisassociations(
                Consumer<UnsuccessfulFaceDisassociation.Builder>... unsuccessfulFaceDisassociations);

        /**
         * <p>
         * The status of an update made to a User. Reflects if the User has been updated for every requested change.
         * </p>
         * 
         * @param userStatus
         *        The status of an update made to a User. Reflects if the User has been updated for every requested
         *        change.
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder userStatus(String userStatus);

        /**
         * <p>
         * The status of an update made to a User. Reflects if the User has been updated for every requested change.
         * </p>
         * 
         * @param userStatus
         *        The status of an update made to a User. Reflects if the User has been updated for every requested
         *        change.
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder userStatus(UserStatus userStatus);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<DisassociatedFace> disassociatedFaces = DefaultSdkAutoConstructList.getInstance();

        private List<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations = DefaultSdkAutoConstructList.getInstance();

        private String userStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateFacesResponse model) {
            super(model);
            disassociatedFaces(model.disassociatedFaces);
            unsuccessfulFaceDisassociations(model.unsuccessfulFaceDisassociations);
            userStatus(model.userStatus);
        }

        public final List<DisassociatedFace.Builder> getDisassociatedFaces() {
            List<DisassociatedFace.Builder> result = DisassociatedFacesListCopier.copyToBuilder(this.disassociatedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisassociatedFaces(Collection<DisassociatedFace.BuilderImpl> disassociatedFaces) {
            this.disassociatedFaces = DisassociatedFacesListCopier.copyFromBuilder(disassociatedFaces);
        }

        @Override
        public final Builder disassociatedFaces(Collection<DisassociatedFace> disassociatedFaces) {
            this.disassociatedFaces = DisassociatedFacesListCopier.copy(disassociatedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disassociatedFaces(DisassociatedFace... disassociatedFaces) {
            disassociatedFaces(Arrays.asList(disassociatedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disassociatedFaces(Consumer<DisassociatedFace.Builder>... disassociatedFaces) {
            disassociatedFaces(Stream.of(disassociatedFaces).map(c -> DisassociatedFace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnsuccessfulFaceDisassociation.Builder> getUnsuccessfulFaceDisassociations() {
            List<UnsuccessfulFaceDisassociation.Builder> result = UnsuccessfulFaceDisassociationListCopier
                    .copyToBuilder(this.unsuccessfulFaceDisassociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfulFaceDisassociations(
                Collection<UnsuccessfulFaceDisassociation.BuilderImpl> unsuccessfulFaceDisassociations) {
            this.unsuccessfulFaceDisassociations = UnsuccessfulFaceDisassociationListCopier
                    .copyFromBuilder(unsuccessfulFaceDisassociations);
        }

        @Override
        public final Builder unsuccessfulFaceDisassociations(
                Collection<UnsuccessfulFaceDisassociation> unsuccessfulFaceDisassociations) {
            this.unsuccessfulFaceDisassociations = UnsuccessfulFaceDisassociationListCopier.copy(unsuccessfulFaceDisassociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceDisassociations(UnsuccessfulFaceDisassociation... unsuccessfulFaceDisassociations) {
            unsuccessfulFaceDisassociations(Arrays.asList(unsuccessfulFaceDisassociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFaceDisassociations(
                Consumer<UnsuccessfulFaceDisassociation.Builder>... unsuccessfulFaceDisassociations) {
            unsuccessfulFaceDisassociations(Stream.of(unsuccessfulFaceDisassociations)
                    .map(c -> UnsuccessfulFaceDisassociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserStatus() {
            return userStatus;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatus userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        @Override
        public DisassociateFacesResponse build() {
            return new DisassociateFacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
