/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the type of a segment requested in a call to <a>StartSegmentDetection</a>. An array of
 * <code>SegmentTypeInfo</code> objects is returned by the response from <a>GetSegmentDetection</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentTypeInfo implements SdkPojo, Serializable, ToCopyableBuilder<SegmentTypeInfo.Builder, SegmentTypeInfo> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SegmentTypeInfo::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(SegmentTypeInfo::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            MODEL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String modelVersion;

    private SegmentTypeInfo(BuilderImpl builder) {
        this.type = builder.type;
        this.modelVersion = builder.modelVersion;
    }

    /**
     * <p>
     * The type of a segment (technical cue or shot detection).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of a segment (technical cue or shot detection).
     * @see SegmentType
     */
    public final SegmentType type() {
        return SegmentType.fromValue(type);
    }

    /**
     * <p>
     * The type of a segment (technical cue or shot detection).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of a segment (technical cue or shot detection).
     * @see SegmentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The version of the model used to detect segments.
     * </p>
     * 
     * @return The version of the model used to detect segments.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentTypeInfo)) {
            return false;
        }
        SegmentTypeInfo other = (SegmentTypeInfo) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(modelVersion(), other.modelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SegmentTypeInfo").add("Type", typeAsString()).add("ModelVersion", modelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ModelVersion", MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SegmentTypeInfo, T> g) {
        return obj -> g.apply((SegmentTypeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentTypeInfo> {
        /**
         * <p>
         * The type of a segment (technical cue or shot detection).
         * </p>
         * 
         * @param type
         *        The type of a segment (technical cue or shot detection).
         * @see SegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of a segment (technical cue or shot detection).
         * </p>
         * 
         * @param type
         *        The type of a segment (technical cue or shot detection).
         * @see SegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentType
         */
        Builder type(SegmentType type);

        /**
         * <p>
         * The version of the model used to detect segments.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model used to detect segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentTypeInfo model) {
            type(model.type);
            modelVersion(model.modelVersion);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SegmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Override
        public SegmentTypeInfo build() {
            return new SegmentTypeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
