/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an inappropriate, unwanted, or offensive content label detection in a stored video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentModerationDetection implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentModerationDetection.Builder, ContentModerationDetection> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Timestamp")
            .getter(getter(ContentModerationDetection::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<ModerationLabel> MODERATION_LABEL_FIELD = SdkField
            .<ModerationLabel> builder(MarshallingType.SDK_POJO).memberName("ModerationLabel")
            .getter(getter(ContentModerationDetection::moderationLabel)).setter(setter(Builder::moderationLabel))
            .constructor(ModerationLabel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationLabel").build()).build();

    private static final SdkField<Long> START_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StartTimestampMillis").getter(getter(ContentModerationDetection::startTimestampMillis))
            .setter(setter(Builder::startTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestampMillis").build())
            .build();

    private static final SdkField<Long> END_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndTimestampMillis").getter(getter(ContentModerationDetection::endTimestampMillis))
            .setter(setter(Builder::endTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestampMillis").build())
            .build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(ContentModerationDetection::durationMillis))
            .setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<List<ContentType>> CONTENT_TYPES_FIELD = SdkField
            .<List<ContentType>> builder(MarshallingType.LIST)
            .memberName("ContentTypes")
            .getter(getter(ContentModerationDetection::contentTypes))
            .setter(setter(Builder::contentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContentType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContentType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            MODERATION_LABEL_FIELD, START_TIMESTAMP_MILLIS_FIELD, END_TIMESTAMP_MILLIS_FIELD, DURATION_MILLIS_FIELD,
            CONTENT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long timestamp;

    private final ModerationLabel moderationLabel;

    private final Long startTimestampMillis;

    private final Long endTimestampMillis;

    private final Long durationMillis;

    private final List<ContentType> contentTypes;

    private ContentModerationDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.moderationLabel = builder.moderationLabel;
        this.startTimestampMillis = builder.startTimestampMillis;
        this.endTimestampMillis = builder.endTimestampMillis;
        this.durationMillis = builder.durationMillis;
        this.contentTypes = builder.contentTypes;
    }

    /**
     * <p>
     * Time, in milliseconds from the beginning of the video, that the content moderation label was detected. Note that
     * <code>Timestamp</code> is not guaranteed to be accurate to the individual frame where the moderated content first
     * appears.
     * </p>
     * 
     * @return Time, in milliseconds from the beginning of the video, that the content moderation label was detected.
     *         Note that <code>Timestamp</code> is not guaranteed to be accurate to the individual frame where the
     *         moderated content first appears.
     */
    public final Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The content moderation label detected by in the stored video.
     * </p>
     * 
     * @return The content moderation label detected by in the stored video.
     */
    public final ModerationLabel moderationLabel() {
        return moderationLabel;
    }

    /**
     * <p>
     * The time in milliseconds defining the start of the timeline segment containing a continuously detected moderation
     * label.
     * </p>
     * 
     * @return The time in milliseconds defining the start of the timeline segment containing a continuously detected
     *         moderation label.
     */
    public final Long startTimestampMillis() {
        return startTimestampMillis;
    }

    /**
     * <p>
     * The time in milliseconds defining the end of the timeline segment containing a continuously detected moderation
     * label.
     * </p>
     * 
     * @return The time in milliseconds defining the end of the timeline segment containing a continuously detected
     *         moderation label.
     */
    public final Long endTimestampMillis() {
        return endTimestampMillis;
    }

    /**
     * <p>
     * The time duration of a segment in milliseconds, I.e. time elapsed from StartTimestampMillis to
     * EndTimestampMillis.
     * </p>
     * 
     * @return The time duration of a segment in milliseconds, I.e. time elapsed from StartTimestampMillis to
     *         EndTimestampMillis.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContentTypes() {
        return contentTypes != null && !(contentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of predicted results for the type of content an image contains. For example, the image content might be
     * from animation, sports, or a video game.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContentTypes} method.
     * </p>
     * 
     * @return A list of predicted results for the type of content an image contains. For example, the image content
     *         might be from animation, sports, or a video game.
     */
    public final List<ContentType> contentTypes() {
        return contentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(moderationLabel());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(hasContentTypes() ? contentTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentModerationDetection)) {
            return false;
        }
        ContentModerationDetection other = (ContentModerationDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(moderationLabel(), other.moderationLabel())
                && Objects.equals(startTimestampMillis(), other.startTimestampMillis())
                && Objects.equals(endTimestampMillis(), other.endTimestampMillis())
                && Objects.equals(durationMillis(), other.durationMillis()) && hasContentTypes() == other.hasContentTypes()
                && Objects.equals(contentTypes(), other.contentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentModerationDetection").add("Timestamp", timestamp())
                .add("ModerationLabel", moderationLabel()).add("StartTimestampMillis", startTimestampMillis())
                .add("EndTimestampMillis", endTimestampMillis()).add("DurationMillis", durationMillis())
                .add("ContentTypes", hasContentTypes() ? contentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "ModerationLabel":
            return Optional.ofNullable(clazz.cast(moderationLabel()));
        case "StartTimestampMillis":
            return Optional.ofNullable(clazz.cast(startTimestampMillis()));
        case "EndTimestampMillis":
            return Optional.ofNullable(clazz.cast(endTimestampMillis()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "ContentTypes":
            return Optional.ofNullable(clazz.cast(contentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("ModerationLabel", MODERATION_LABEL_FIELD);
        map.put("StartTimestampMillis", START_TIMESTAMP_MILLIS_FIELD);
        map.put("EndTimestampMillis", END_TIMESTAMP_MILLIS_FIELD);
        map.put("DurationMillis", DURATION_MILLIS_FIELD);
        map.put("ContentTypes", CONTENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentModerationDetection, T> g) {
        return obj -> g.apply((ContentModerationDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentModerationDetection> {
        /**
         * <p>
         * Time, in milliseconds from the beginning of the video, that the content moderation label was detected. Note
         * that <code>Timestamp</code> is not guaranteed to be accurate to the individual frame where the moderated
         * content first appears.
         * </p>
         * 
         * @param timestamp
         *        Time, in milliseconds from the beginning of the video, that the content moderation label was detected.
         *        Note that <code>Timestamp</code> is not guaranteed to be accurate to the individual frame where the
         *        moderated content first appears.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The content moderation label detected by in the stored video.
         * </p>
         * 
         * @param moderationLabel
         *        The content moderation label detected by in the stored video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabel(ModerationLabel moderationLabel);

        /**
         * <p>
         * The content moderation label detected by in the stored video.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModerationLabel.Builder} avoiding the
         * need to create one manually via {@link ModerationLabel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModerationLabel.Builder#build()} is called immediately and its
         * result is passed to {@link #moderationLabel(ModerationLabel)}.
         * 
         * @param moderationLabel
         *        a consumer that will call methods on {@link ModerationLabel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moderationLabel(ModerationLabel)
         */
        default Builder moderationLabel(Consumer<ModerationLabel.Builder> moderationLabel) {
            return moderationLabel(ModerationLabel.builder().applyMutation(moderationLabel).build());
        }

        /**
         * <p>
         * The time in milliseconds defining the start of the timeline segment containing a continuously detected
         * moderation label.
         * </p>
         * 
         * @param startTimestampMillis
         *        The time in milliseconds defining the start of the timeline segment containing a continuously detected
         *        moderation label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestampMillis(Long startTimestampMillis);

        /**
         * <p>
         * The time in milliseconds defining the end of the timeline segment containing a continuously detected
         * moderation label.
         * </p>
         * 
         * @param endTimestampMillis
         *        The time in milliseconds defining the end of the timeline segment containing a continuously detected
         *        moderation label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestampMillis(Long endTimestampMillis);

        /**
         * <p>
         * The time duration of a segment in milliseconds, I.e. time elapsed from StartTimestampMillis to
         * EndTimestampMillis.
         * </p>
         * 
         * @param durationMillis
         *        The time duration of a segment in milliseconds, I.e. time elapsed from StartTimestampMillis to
         *        EndTimestampMillis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * A list of predicted results for the type of content an image contains. For example, the image content might
         * be from animation, sports, or a video game.
         * </p>
         * 
         * @param contentTypes
         *        A list of predicted results for the type of content an image contains. For example, the image content
         *        might be from animation, sports, or a video game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentTypes(Collection<ContentType> contentTypes);

        /**
         * <p>
         * A list of predicted results for the type of content an image contains. For example, the image content might
         * be from animation, sports, or a video game.
         * </p>
         * 
         * @param contentTypes
         *        A list of predicted results for the type of content an image contains. For example, the image content
         *        might be from animation, sports, or a video game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentTypes(ContentType... contentTypes);

        /**
         * <p>
         * A list of predicted results for the type of content an image contains. For example, the image content might
         * be from animation, sports, or a video game.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.ContentType.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.ContentType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.ContentType.Builder#build()} is called immediately
         * and its result is passed to {@link #contentTypes(List<ContentType>)}.
         * 
         * @param contentTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.ContentType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentTypes(java.util.Collection<ContentType>)
         */
        Builder contentTypes(Consumer<ContentType.Builder>... contentTypes);
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private ModerationLabel moderationLabel;

        private Long startTimestampMillis;

        private Long endTimestampMillis;

        private Long durationMillis;

        private List<ContentType> contentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentModerationDetection model) {
            timestamp(model.timestamp);
            moderationLabel(model.moderationLabel);
            startTimestampMillis(model.startTimestampMillis);
            endTimestampMillis(model.endTimestampMillis);
            durationMillis(model.durationMillis);
            contentTypes(model.contentTypes);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final ModerationLabel.Builder getModerationLabel() {
            return moderationLabel != null ? moderationLabel.toBuilder() : null;
        }

        public final void setModerationLabel(ModerationLabel.BuilderImpl moderationLabel) {
            this.moderationLabel = moderationLabel != null ? moderationLabel.build() : null;
        }

        @Override
        public final Builder moderationLabel(ModerationLabel moderationLabel) {
            this.moderationLabel = moderationLabel;
            return this;
        }

        public final Long getStartTimestampMillis() {
            return startTimestampMillis;
        }

        public final void setStartTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
        }

        @Override
        public final Builder startTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
            return this;
        }

        public final Long getEndTimestampMillis() {
            return endTimestampMillis;
        }

        public final void setEndTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
        }

        @Override
        public final Builder endTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
            return this;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final List<ContentType.Builder> getContentTypes() {
            List<ContentType.Builder> result = ContentTypesCopier.copyToBuilder(this.contentTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentTypes(Collection<ContentType.BuilderImpl> contentTypes) {
            this.contentTypes = ContentTypesCopier.copyFromBuilder(contentTypes);
        }

        @Override
        public final Builder contentTypes(Collection<ContentType> contentTypes) {
            this.contentTypes = ContentTypesCopier.copy(contentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentTypes(ContentType... contentTypes) {
            contentTypes(Arrays.asList(contentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentTypes(Consumer<ContentType.Builder>... contentTypes) {
            contentTypes(Stream.of(contentTypes).map(c -> ContentType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContentModerationDetection build() {
            return new ContentModerationDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
