/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an item of Personal Protective Equipment covering a corresponding body part. For more information,
 * see <a>DetectProtectiveEquipment</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoversBodyPart implements SdkPojo, Serializable, ToCopyableBuilder<CoversBodyPart.Builder, CoversBodyPart> {
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(CoversBodyPart::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Boolean> VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Value")
            .getter(getter(CoversBodyPart::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONFIDENCE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float confidence;

    private final Boolean value;

    private CoversBodyPart(BuilderImpl builder) {
        this.confidence = builder.confidence;
        this.value = builder.value;
    }

    /**
     * <p>
     * The confidence that Amazon Rekognition has in the value of <code>Value</code>.
     * </p>
     * 
     * @return The confidence that Amazon Rekognition has in the value of <code>Value</code>.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * True if the PPE covers the corresponding body part, otherwise false.
     * </p>
     * 
     * @return True if the PPE covers the corresponding body part, otherwise false.
     */
    public final Boolean value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoversBodyPart)) {
            return false;
        }
        CoversBodyPart other = (CoversBodyPart) obj;
        return Objects.equals(confidence(), other.confidence()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoversBodyPart").add("Confidence", confidence()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoversBodyPart, T> g) {
        return obj -> g.apply((CoversBodyPart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoversBodyPart> {
        /**
         * <p>
         * The confidence that Amazon Rekognition has in the value of <code>Value</code>.
         * </p>
         * 
         * @param confidence
         *        The confidence that Amazon Rekognition has in the value of <code>Value</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * True if the PPE covers the corresponding body part, otherwise false.
         * </p>
         * 
         * @param value
         *        True if the PPE covers the corresponding body part, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Boolean value);
    }

    static final class BuilderImpl implements Builder {
        private Float confidence;

        private Boolean value;

        private BuilderImpl() {
        }

        private BuilderImpl(CoversBodyPart model) {
            confidence(model.confidence);
            value(model.value);
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Boolean getValue() {
            return value;
        }

        public final void setValue(Boolean value) {
            this.value = value;
        }

        @Override
        public final Builder value(Boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public CoversBodyPart build() {
            return new CoversBodyPart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
