/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a label detected in a video analysis request and the time the label was detected in the video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelDetection implements SdkPojo, Serializable, ToCopyableBuilder<LabelDetection.Builder, LabelDetection> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Timestamp")
            .getter(getter(LabelDetection::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Label> LABEL_FIELD = SdkField.<Label> builder(MarshallingType.SDK_POJO).memberName("Label")
            .getter(getter(LabelDetection::label)).setter(setter(Builder::label)).constructor(Label::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<Long> START_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StartTimestampMillis").getter(getter(LabelDetection::startTimestampMillis))
            .setter(setter(Builder::startTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestampMillis").build())
            .build();

    private static final SdkField<Long> END_TIMESTAMP_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndTimestampMillis").getter(getter(LabelDetection::endTimestampMillis))
            .setter(setter(Builder::endTimestampMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestampMillis").build())
            .build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(LabelDetection::durationMillis)).setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, LABEL_FIELD,
            START_TIMESTAMP_MILLIS_FIELD, END_TIMESTAMP_MILLIS_FIELD, DURATION_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long timestamp;

    private final Label label;

    private final Long startTimestampMillis;

    private final Long endTimestampMillis;

    private final Long durationMillis;

    private LabelDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.label = builder.label;
        this.startTimestampMillis = builder.startTimestampMillis;
        this.endTimestampMillis = builder.endTimestampMillis;
        this.durationMillis = builder.durationMillis;
    }

    /**
     * <p>
     * Time, in milliseconds from the start of the video, that the label was detected. Note that <code>Timestamp</code>
     * is not guaranteed to be accurate to the individual frame where the label first appears.
     * </p>
     * 
     * @return Time, in milliseconds from the start of the video, that the label was detected. Note that
     *         <code>Timestamp</code> is not guaranteed to be accurate to the individual frame where the label first
     *         appears.
     */
    public final Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Details about the detected label.
     * </p>
     * 
     * @return Details about the detected label.
     */
    public final Label label() {
        return label;
    }

    /**
     * <p>
     * The time in milliseconds defining the start of the timeline segment containing a continuously detected label.
     * </p>
     * 
     * @return The time in milliseconds defining the start of the timeline segment containing a continuously detected
     *         label.
     */
    public final Long startTimestampMillis() {
        return startTimestampMillis;
    }

    /**
     * <p>
     * The time in milliseconds defining the end of the timeline segment containing a continuously detected label.
     * </p>
     * 
     * @return The time in milliseconds defining the end of the timeline segment containing a continuously detected
     *         label.
     */
    public final Long endTimestampMillis() {
        return endTimestampMillis;
    }

    /**
     * <p>
     * The time duration of a segment in milliseconds, I.e. time elapsed from StartTimestampMillis to
     * EndTimestampMillis.
     * </p>
     * 
     * @return The time duration of a segment in milliseconds, I.e. time elapsed from StartTimestampMillis to
     *         EndTimestampMillis.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestampMillis());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelDetection)) {
            return false;
        }
        LabelDetection other = (LabelDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(label(), other.label())
                && Objects.equals(startTimestampMillis(), other.startTimestampMillis())
                && Objects.equals(endTimestampMillis(), other.endTimestampMillis())
                && Objects.equals(durationMillis(), other.durationMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelDetection").add("Timestamp", timestamp()).add("Label", label())
                .add("StartTimestampMillis", startTimestampMillis()).add("EndTimestampMillis", endTimestampMillis())
                .add("DurationMillis", durationMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "StartTimestampMillis":
            return Optional.ofNullable(clazz.cast(startTimestampMillis()));
        case "EndTimestampMillis":
            return Optional.ofNullable(clazz.cast(endTimestampMillis()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("StartTimestampMillis", START_TIMESTAMP_MILLIS_FIELD);
        map.put("EndTimestampMillis", END_TIMESTAMP_MILLIS_FIELD);
        map.put("DurationMillis", DURATION_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LabelDetection, T> g) {
        return obj -> g.apply((LabelDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelDetection> {
        /**
         * <p>
         * Time, in milliseconds from the start of the video, that the label was detected. Note that
         * <code>Timestamp</code> is not guaranteed to be accurate to the individual frame where the label first
         * appears.
         * </p>
         * 
         * @param timestamp
         *        Time, in milliseconds from the start of the video, that the label was detected. Note that
         *        <code>Timestamp</code> is not guaranteed to be accurate to the individual frame where the label first
         *        appears.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * Details about the detected label.
         * </p>
         * 
         * @param label
         *        Details about the detected label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(Label label);

        /**
         * <p>
         * Details about the detected label.
         * </p>
         * This is a convenience method that creates an instance of the {@link Label.Builder} avoiding the need to
         * create one manually via {@link Label#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Label.Builder#build()} is called immediately and its result is
         * passed to {@link #label(Label)}.
         * 
         * @param label
         *        a consumer that will call methods on {@link Label.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #label(Label)
         */
        default Builder label(Consumer<Label.Builder> label) {
            return label(Label.builder().applyMutation(label).build());
        }

        /**
         * <p>
         * The time in milliseconds defining the start of the timeline segment containing a continuously detected label.
         * </p>
         * 
         * @param startTimestampMillis
         *        The time in milliseconds defining the start of the timeline segment containing a continuously detected
         *        label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestampMillis(Long startTimestampMillis);

        /**
         * <p>
         * The time in milliseconds defining the end of the timeline segment containing a continuously detected label.
         * </p>
         * 
         * @param endTimestampMillis
         *        The time in milliseconds defining the end of the timeline segment containing a continuously detected
         *        label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestampMillis(Long endTimestampMillis);

        /**
         * <p>
         * The time duration of a segment in milliseconds, I.e. time elapsed from StartTimestampMillis to
         * EndTimestampMillis.
         * </p>
         * 
         * @param durationMillis
         *        The time duration of a segment in milliseconds, I.e. time elapsed from StartTimestampMillis to
         *        EndTimestampMillis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private Label label;

        private Long startTimestampMillis;

        private Long endTimestampMillis;

        private Long durationMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelDetection model) {
            timestamp(model.timestamp);
            label(model.label);
            startTimestampMillis(model.startTimestampMillis);
            endTimestampMillis(model.endTimestampMillis);
            durationMillis(model.durationMillis);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Label.Builder getLabel() {
            return label != null ? label.toBuilder() : null;
        }

        public final void setLabel(Label.BuilderImpl label) {
            this.label = label != null ? label.build() : null;
        }

        @Override
        public final Builder label(Label label) {
            this.label = label;
            return this;
        }

        public final Long getStartTimestampMillis() {
            return startTimestampMillis;
        }

        public final void setStartTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
        }

        @Override
        public final Builder startTimestampMillis(Long startTimestampMillis) {
            this.startTimestampMillis = startTimestampMillis;
            return this;
        }

        public final Long getEndTimestampMillis() {
            return endTimestampMillis;
        }

        public final void setEndTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
        }

        @Override
        public final Builder endTimestampMillis(Long endTimestampMillis) {
            this.endTimestampMillis = endTimestampMillis;
            return this;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        @Override
        public LabelDetection build() {
            return new LabelDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
