/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProjectPolicyRequest extends RekognitionRequest implements
        ToCopyableBuilder<DeleteProjectPolicyRequest.Builder, DeleteProjectPolicyRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectArn").getter(getter(DeleteProjectPolicyRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(DeleteProjectPolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyRevisionId").getter(getter(DeleteProjectPolicyRequest::policyRevisionId))
            .setter(setter(Builder::policyRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            POLICY_NAME_FIELD, POLICY_REVISION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectArn;

    private final String policyName;

    private final String policyRevisionId;

    private DeleteProjectPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.policyName = builder.policyName;
        this.policyRevisionId = builder.policyRevisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project that the project policy you want to delete is attached to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project that the project policy you want to delete is attached to.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The name of the policy that you want to delete.
     * </p>
     * 
     * @return The name of the policy that you want to delete.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The ID of the project policy revision that you want to delete.
     * </p>
     * 
     * @return The ID of the project policy revision that you want to delete.
     */
    public final String policyRevisionId() {
        return policyRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyRevisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectPolicyRequest)) {
            return false;
        }
        DeleteProjectPolicyRequest other = (DeleteProjectPolicyRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(policyRevisionId(), other.policyRevisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteProjectPolicyRequest").add("ProjectArn", projectArn()).add("PolicyName", policyName())
                .add("PolicyRevisionId", policyRevisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyRevisionId":
            return Optional.ofNullable(clazz.cast(policyRevisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProjectArn", PROJECT_ARN_FIELD);
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("PolicyRevisionId", POLICY_REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectPolicyRequest, T> g) {
        return obj -> g.apply((DeleteProjectPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteProjectPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project that the project policy you want to delete is attached to.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project that the project policy you want to delete is attached
         *        to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The name of the policy that you want to delete.
         * </p>
         * 
         * @param policyName
         *        The name of the policy that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The ID of the project policy revision that you want to delete.
         * </p>
         * 
         * @param policyRevisionId
         *        The ID of the project policy revision that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRevisionId(String policyRevisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String policyName;

        private String policyRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectPolicyRequest model) {
            super(model);
            projectArn(model.projectArn);
            policyName(model.policyName);
            policyRevisionId(model.policyRevisionId);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyRevisionId() {
            return policyRevisionId;
        }

        public final void setPolicyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
        }

        @Override
        public final Builder policyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProjectPolicyRequest build() {
            return new DeleteProjectPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
