/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata for a UserID matched with a given face.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchedUser implements SdkPojo, Serializable, ToCopyableBuilder<MatchedUser.Builder, MatchedUser> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(MatchedUser::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> USER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserStatus").getter(getter(MatchedUser::userStatusAsString)).setter(setter(Builder::userStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            USER_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userId;

    private final String userStatus;

    private MatchedUser(BuilderImpl builder) {
        this.userId = builder.userId;
        this.userStatus = builder.userStatus;
    }

    /**
     * <p>
     * A provided ID for the UserID. Unique within the collection.
     * </p>
     * 
     * @return A provided ID for the UserID. Unique within the collection.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The status of the user matched to a provided FaceID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The status of the user matched to a provided FaceID.
     * @see UserStatus
     */
    public final UserStatus userStatus() {
        return UserStatus.fromValue(userStatus);
    }

    /**
     * <p>
     * The status of the user matched to a provided FaceID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The status of the user matched to a provided FaceID.
     * @see UserStatus
     */
    public final String userStatusAsString() {
        return userStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchedUser)) {
            return false;
        }
        MatchedUser other = (MatchedUser) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(userStatusAsString(), other.userStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchedUser").add("UserId", userId()).add("UserStatus", userStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "UserStatus":
            return Optional.ofNullable(clazz.cast(userStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserId", USER_ID_FIELD);
        map.put("UserStatus", USER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchedUser, T> g) {
        return obj -> g.apply((MatchedUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchedUser> {
        /**
         * <p>
         * A provided ID for the UserID. Unique within the collection.
         * </p>
         * 
         * @param userId
         *        A provided ID for the UserID. Unique within the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The status of the user matched to a provided FaceID.
         * </p>
         * 
         * @param userStatus
         *        The status of the user matched to a provided FaceID.
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder userStatus(String userStatus);

        /**
         * <p>
         * The status of the user matched to a provided FaceID.
         * </p>
         * 
         * @param userStatus
         *        The status of the user matched to a provided FaceID.
         * @see UserStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatus
         */
        Builder userStatus(UserStatus userStatus);
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String userStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchedUser model) {
            userId(model.userId);
            userStatus(model.userStatus);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserStatus() {
            return userStatus;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatus userStatus) {
            this.userStatus(userStatus == null ? null : userStatus.toString());
            return this;
        }

        @Override
        public MatchedUser build() {
            return new MatchedUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
